/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.dataflow;

import com.oracle.bmc.dataflow.DataFlowAsyncClient;
import com.oracle.bmc.dataflow.requests.ChangeApplicationCompartmentRequest;
import com.oracle.bmc.dataflow.requests.ChangePrivateEndpointCompartmentRequest;
import com.oracle.bmc.dataflow.requests.ChangeRunCompartmentRequest;
import com.oracle.bmc.dataflow.requests.CreateApplicationRequest;
import com.oracle.bmc.dataflow.requests.CreatePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.CreateRunRequest;
import com.oracle.bmc.dataflow.requests.DeleteApplicationRequest;
import com.oracle.bmc.dataflow.requests.DeletePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.DeleteRunRequest;
import com.oracle.bmc.dataflow.requests.GetApplicationRequest;
import com.oracle.bmc.dataflow.requests.GetPrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.GetRunLogRequest;
import com.oracle.bmc.dataflow.requests.GetRunRequest;
import com.oracle.bmc.dataflow.requests.GetWorkRequestRequest;
import com.oracle.bmc.dataflow.requests.ListApplicationsRequest;
import com.oracle.bmc.dataflow.requests.ListPrivateEndpointsRequest;
import com.oracle.bmc.dataflow.requests.ListRunLogsRequest;
import com.oracle.bmc.dataflow.requests.ListRunsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestsRequest;
import com.oracle.bmc.dataflow.requests.UpdateApplicationRequest;
import com.oracle.bmc.dataflow.requests.UpdatePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.UpdateRunRequest;
import com.oracle.bmc.dataflow.responses.ChangeApplicationCompartmentResponse;
import com.oracle.bmc.dataflow.responses.ChangePrivateEndpointCompartmentResponse;
import com.oracle.bmc.dataflow.responses.ChangeRunCompartmentResponse;
import com.oracle.bmc.dataflow.responses.CreateApplicationResponse;
import com.oracle.bmc.dataflow.responses.CreatePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.CreateRunResponse;
import com.oracle.bmc.dataflow.responses.DeleteApplicationResponse;
import com.oracle.bmc.dataflow.responses.DeletePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.DeleteRunResponse;
import com.oracle.bmc.dataflow.responses.GetApplicationResponse;
import com.oracle.bmc.dataflow.responses.GetPrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.GetRunLogResponse;
import com.oracle.bmc.dataflow.responses.GetRunResponse;
import com.oracle.bmc.dataflow.responses.GetWorkRequestResponse;
import com.oracle.bmc.dataflow.responses.ListApplicationsResponse;
import com.oracle.bmc.dataflow.responses.ListPrivateEndpointsResponse;
import com.oracle.bmc.dataflow.responses.ListRunLogsResponse;
import com.oracle.bmc.dataflow.responses.ListRunsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestsResponse;
import com.oracle.bmc.dataflow.responses.UpdateApplicationResponse;
import com.oracle.bmc.dataflow.responses.UpdatePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.UpdateRunResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={DataFlowAsyncClient.class, Single.class})
@Singleton
public class DataFlowRxClient {
    DataFlowAsyncClient client;

    DataFlowRxClient(DataFlowAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeApplicationCompartmentResponse> changeApplicationCompartment(ChangeApplicationCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeApplicationCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangePrivateEndpointCompartmentResponse> changePrivateEndpointCompartment(ChangePrivateEndpointCompartmentRequest request) {
        return Single.create(emitter -> this.client.changePrivateEndpointCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeRunCompartmentResponse> changeRunCompartment(ChangeRunCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeRunCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateApplicationResponse> createApplication(CreateApplicationRequest request) {
        return Single.create(emitter -> this.client.createApplication(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreatePrivateEndpointResponse> createPrivateEndpoint(CreatePrivateEndpointRequest request) {
        return Single.create(emitter -> this.client.createPrivateEndpoint(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateRunResponse> createRun(CreateRunRequest request) {
        return Single.create(emitter -> this.client.createRun(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest request) {
        return Single.create(emitter -> this.client.deleteApplication(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeletePrivateEndpointResponse> deletePrivateEndpoint(DeletePrivateEndpointRequest request) {
        return Single.create(emitter -> this.client.deletePrivateEndpoint(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteRunResponse> deleteRun(DeleteRunRequest request) {
        return Single.create(emitter -> this.client.deleteRun(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetApplicationResponse> getApplication(GetApplicationRequest request) {
        return Single.create(emitter -> this.client.getApplication(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetPrivateEndpointResponse> getPrivateEndpoint(GetPrivateEndpointRequest request) {
        return Single.create(emitter -> this.client.getPrivateEndpoint(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetRunResponse> getRun(GetRunRequest request) {
        return Single.create(emitter -> this.client.getRun(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetRunLogResponse> getRunLog(GetRunLogRequest request) {
        return Single.create(emitter -> this.client.getRunLog(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListApplicationsResponse> listApplications(ListApplicationsRequest request) {
        return Single.create(emitter -> this.client.listApplications(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListPrivateEndpointsResponse> listPrivateEndpoints(ListPrivateEndpointsRequest request) {
        return Single.create(emitter -> this.client.listPrivateEndpoints(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListRunLogsResponse> listRunLogs(ListRunLogsRequest request) {
        return Single.create(emitter -> this.client.listRunLogs(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListRunsResponse> listRuns(ListRunsRequest request) {
        return Single.create(emitter -> this.client.listRuns(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest request) {
        return Single.create(emitter -> this.client.updateApplication(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdatePrivateEndpointResponse> updatePrivateEndpoint(UpdatePrivateEndpointRequest request) {
        return Single.create(emitter -> this.client.updatePrivateEndpoint(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateRunResponse> updateRun(UpdateRunRequest request) {
        return Single.create(emitter -> this.client.updateRun(request, new AsyncHandlerEmitter(emitter)));
    }
}

