/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.dts;

import com.oracle.bmc.dts.TransferPackageAsyncClient;
import com.oracle.bmc.dts.requests.AttachDevicesToTransferPackageRequest;
import com.oracle.bmc.dts.requests.CreateTransferPackageRequest;
import com.oracle.bmc.dts.requests.DeleteTransferPackageRequest;
import com.oracle.bmc.dts.requests.DetachDevicesFromTransferPackageRequest;
import com.oracle.bmc.dts.requests.GetTransferPackageRequest;
import com.oracle.bmc.dts.requests.ListTransferPackagesRequest;
import com.oracle.bmc.dts.requests.UpdateTransferPackageRequest;
import com.oracle.bmc.dts.responses.AttachDevicesToTransferPackageResponse;
import com.oracle.bmc.dts.responses.CreateTransferPackageResponse;
import com.oracle.bmc.dts.responses.DeleteTransferPackageResponse;
import com.oracle.bmc.dts.responses.DetachDevicesFromTransferPackageResponse;
import com.oracle.bmc.dts.responses.GetTransferPackageResponse;
import com.oracle.bmc.dts.responses.ListTransferPackagesResponse;
import com.oracle.bmc.dts.responses.UpdateTransferPackageResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={TransferPackageAsyncClient.class, Single.class})
@Singleton
public class TransferPackageRxClient {
    TransferPackageAsyncClient client;

    TransferPackageRxClient(TransferPackageAsyncClient client) {
        this.client = client;
    }

    public Single<AttachDevicesToTransferPackageResponse> attachDevicesToTransferPackage(AttachDevicesToTransferPackageRequest request) {
        return Single.create(emitter -> this.client.attachDevicesToTransferPackage(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateTransferPackageResponse> createTransferPackage(CreateTransferPackageRequest request) {
        return Single.create(emitter -> this.client.createTransferPackage(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteTransferPackageResponse> deleteTransferPackage(DeleteTransferPackageRequest request) {
        return Single.create(emitter -> this.client.deleteTransferPackage(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DetachDevicesFromTransferPackageResponse> detachDevicesFromTransferPackage(DetachDevicesFromTransferPackageRequest request) {
        return Single.create(emitter -> this.client.detachDevicesFromTransferPackage(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetTransferPackageResponse> getTransferPackage(GetTransferPackageRequest request) {
        return Single.create(emitter -> this.client.getTransferPackage(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListTransferPackagesResponse> listTransferPackages(ListTransferPackagesRequest request) {
        return Single.create(emitter -> this.client.listTransferPackages(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateTransferPackageResponse> updateTransferPackage(UpdateTransferPackageRequest request) {
        return Single.create(emitter -> this.client.updateTransferPackage(request, new AsyncHandlerEmitter(emitter)));
    }
}

