/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.apigateway;

import com.oracle.bmc.apigateway.WorkRequestsAsyncClient;
import com.oracle.bmc.apigateway.requests.CancelWorkRequestRequest;
import com.oracle.bmc.apigateway.requests.GetWorkRequestRequest;
import com.oracle.bmc.apigateway.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.apigateway.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.apigateway.requests.ListWorkRequestsRequest;
import com.oracle.bmc.apigateway.responses.CancelWorkRequestResponse;
import com.oracle.bmc.apigateway.responses.GetWorkRequestResponse;
import com.oracle.bmc.apigateway.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.apigateway.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.apigateway.responses.ListWorkRequestsResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={WorkRequestsAsyncClient.class, Single.class})
@Singleton
public class WorkRequestsRxClient {
    WorkRequestsAsyncClient client;

    WorkRequestsRxClient(WorkRequestsAsyncClient client) {
        this.client = client;
    }

    public Single<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Single.create(emitter -> this.client.cancelWorkRequest(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, new AsyncHandlerEmitter(emitter)));
    }
}

