/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.email;

import com.oracle.bmc.email.EmailAsyncClient;
import com.oracle.bmc.email.requests.ChangeSenderCompartmentRequest;
import com.oracle.bmc.email.requests.CreateSenderRequest;
import com.oracle.bmc.email.requests.CreateSuppressionRequest;
import com.oracle.bmc.email.requests.DeleteSenderRequest;
import com.oracle.bmc.email.requests.DeleteSuppressionRequest;
import com.oracle.bmc.email.requests.GetSenderRequest;
import com.oracle.bmc.email.requests.GetSuppressionRequest;
import com.oracle.bmc.email.requests.ListSendersRequest;
import com.oracle.bmc.email.requests.ListSuppressionsRequest;
import com.oracle.bmc.email.requests.UpdateSenderRequest;
import com.oracle.bmc.email.responses.ChangeSenderCompartmentResponse;
import com.oracle.bmc.email.responses.CreateSenderResponse;
import com.oracle.bmc.email.responses.CreateSuppressionResponse;
import com.oracle.bmc.email.responses.DeleteSenderResponse;
import com.oracle.bmc.email.responses.DeleteSuppressionResponse;
import com.oracle.bmc.email.responses.GetSenderResponse;
import com.oracle.bmc.email.responses.GetSuppressionResponse;
import com.oracle.bmc.email.responses.ListSendersResponse;
import com.oracle.bmc.email.responses.ListSuppressionsResponse;
import com.oracle.bmc.email.responses.UpdateSenderResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={EmailAsyncClient.class, Single.class})
@Singleton
public class EmailRxClient {
    EmailAsyncClient client;

    EmailRxClient(EmailAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeSenderCompartmentResponse> changeSenderCompartment(ChangeSenderCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeSenderCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateSenderResponse> createSender(CreateSenderRequest request) {
        return Single.create(emitter -> this.client.createSender(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateSuppressionResponse> createSuppression(CreateSuppressionRequest request) {
        return Single.create(emitter -> this.client.createSuppression(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteSenderResponse> deleteSender(DeleteSenderRequest request) {
        return Single.create(emitter -> this.client.deleteSender(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteSuppressionResponse> deleteSuppression(DeleteSuppressionRequest request) {
        return Single.create(emitter -> this.client.deleteSuppression(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetSenderResponse> getSender(GetSenderRequest request) {
        return Single.create(emitter -> this.client.getSender(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetSuppressionResponse> getSuppression(GetSuppressionRequest request) {
        return Single.create(emitter -> this.client.getSuppression(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSendersResponse> listSenders(ListSendersRequest request) {
        return Single.create(emitter -> this.client.listSenders(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSuppressionsResponse> listSuppressions(ListSuppressionsRequest request) {
        return Single.create(emitter -> this.client.listSuppressions(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateSenderResponse> updateSender(UpdateSenderRequest request) {
        return Single.create(emitter -> this.client.updateSender(request, new AsyncHandlerEmitter(emitter)));
    }
}

