/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;

@Internal
public final class ElementUtils {
    public static final List<String> CONTAINER_TYPES = Arrays.asList(Optional.class.getName(), Future.class.getName(), "org.reactivestreams.Publisher", "io.reactivex.Single", "io.reactivex.Observable", "io.reactivex.Maybe", "io.reactivex.rxjava3.core.Single", "io.reactivex.rxjava3.core.Observable", "io.reactivex.rxjava3.core.Maybe", "kotlinx.coroutines.flow.Flow");
    public static final List<String> FILE_TYPES = Arrays.asList("io.micronaut.http.server.types.files.FileCustomizableResponseType", File.class.getName(), InputStream.class.getName(), ByteBuffer.class.getName());
    public static final List<String> VOID_TYPES = Arrays.asList(Void.TYPE.getName(), Void.class.getName(), "kotlin.Unit");

    private ElementUtils() {
    }

    public static boolean isJavaElement(ClassElement classElement, VisitorContext context) {
        return classElement != null && "io.micronaut.annotation.processing.visitor.JavaClassElement".equals(classElement.getClass().getName()) && "io.micronaut.annotation.processing.visitor.JavaVisitorContext".equals(context.getClass().getName());
    }

    public static boolean isNullable(TypedElement element) {
        return element.isNullable() || element.getType().isOptional();
    }

    public static boolean isFileUpload(ClassElement type) {
        String typeName;
        ClassElement typeArg;
        if (ElementUtils.isContainerType(type) && (typeArg = (ClassElement)type.getFirstTypeArgument().orElse(null)) != null) {
            type = typeArg;
        }
        return "io.micronaut.http.multipart.StreamingFileUpload".equals(typeName = type.getName()) || "io.micronaut.http.multipart.CompletedFileUpload".equals(typeName) || "io.micronaut.http.multipart.CompletedPart".equals(typeName) || "io.micronaut.http.multipart.PartData".equals(typeName);
    }

    public static boolean isElementNotNullable(Element element, @Nullable Element classElement) {
        return element.isAnnotationPresent("javax.validation.constraints.NotNull$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotNull$List") || element.isAnnotationPresent("javax.validation.constraints.NotBlank$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotBlank$List") || element.isAnnotationPresent("javax.validation.constraints.NotEmpty$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotEmpty$List") || element.isNonNull() || element.booleanValue(JsonProperty.class, "required").orElse(false) != false;
    }

    public static boolean isReturnTypeFile(ClassElement type) {
        return ElementUtils.findAnyAssignable(type, FILE_TYPES);
    }

    public static boolean isContainerType(ClassElement type) {
        return ElementUtils.findAnyAssignable(type, CONTAINER_TYPES);
    }

    public static boolean isVoid(ClassElement type) {
        return ElementUtils.findAnyAssignable(type, VOID_TYPES);
    }

    public static boolean isReactiveAndVoid(ClassElement type) {
        return type.isAssignable("io.reactivex.Completable") || type.isAssignable("io.reactivex.rxjava3.core.Completable") || ElementUtils.isContainerType(type) && type.getFirstTypeArgument().isPresent() && ElementUtils.isVoid((ClassElement)type.getFirstTypeArgument().get());
    }

    private static boolean findAnyAssignable(ClassElement type, List<String> typeNames) {
        for (String typeName : typeNames) {
            if (!type.isAssignable(typeName)) continue;
            return true;
        }
        return false;
    }
}

