/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.websocket.bind;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.ArgumentBinderRegistry;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.QueryValueArgumentBinder;
import io.micronaut.http.bind.binders.UnmatchedRequestArgumentBinder;
import io.micronaut.websocket.WebSocketSession;
import io.micronaut.websocket.bind.WebSocketState;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@Internal
public class WebSocketStateBinderRegistry
implements ArgumentBinderRegistry<WebSocketState> {
    private final ArgumentBinderRegistry<HttpRequest<?>> requestBinderRegistry;
    private final Map<Class<?>, ArgumentBinder<?, WebSocketState>> byType = new HashMap(5);
    private final ArgumentBinder<Object, HttpRequest<?>> queryValueArgumentBinder;

    public WebSocketStateBinderRegistry(RequestBinderRegistry requestBinderRegistry, ConversionService conversionService) {
        this.requestBinderRegistry = requestBinderRegistry;
        ArgumentBinder sessionBinder = (context, source) -> () -> Optional.of(source.getSession());
        this.byType.put(WebSocketSession.class, sessionBinder);
        this.queryValueArgumentBinder = new QueryValueArgumentBinder(conversionService);
    }

    public <T> Optional<ArgumentBinder<T, WebSocketState>> findArgumentBinder(Argument<T> argument) {
        ArgumentBinder adapted;
        boolean isUnmatchedRequestArgumentBinder;
        Optional argumentBinder = this.requestBinderRegistry.findArgumentBinder(argument);
        if (argumentBinder.isPresent() && !(isUnmatchedRequestArgumentBinder = (adapted = (ArgumentBinder)argumentBinder.get()) instanceof UnmatchedRequestArgumentBinder)) {
            return Optional.of((context, source1) -> adapted.bind(context, source1.getOriginatingRequest()));
        }
        ArgumentBinder<?, WebSocketState> binder = this.byType.get(argument.getType());
        if (binder != null) {
            return Optional.of(binder);
        }
        return Optional.of((context, source) -> {
            ConvertibleValues<Object> uriVariables = source.getSession().getUriVariables();
            if (uriVariables.contains(argument.getName())) {
                Optional val = uriVariables.get((CharSequence)argument.getName(), argument);
                return val.isEmpty() ? ArgumentBinder.BindingResult.UNSATISFIED : () -> val;
            }
            return this.queryValueArgumentBinder.bind(context, source.getOriginatingRequest());
        });
    }
}

