/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.exceptions;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.Optional;
import org.grails.datastore.mapping.validation.ValidationException;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;

@Singleton
@Requires(classes={ValidationException.class})
public class ValidationExceptionHandler
implements ExceptionHandler<ValidationException, HttpResponse<?>> {
    private final ErrorResponseProcessor<?> responseProcessor;

    @Deprecated
    public ValidationExceptionHandler() {
        this.responseProcessor = null;
    }

    public ValidationExceptionHandler(ErrorResponseProcessor<?> responseProcessor) {
        this.responseProcessor = responseProcessor;
    }

    public HttpResponse<?> handle(HttpRequest request, final ValidationException exception) {
        Errors errors = exception.getErrors();
        final FieldError fieldError = errors.getFieldError();
        MutableHttpResponse response = HttpResponse.badRequest();
        if (this.responseProcessor != null) {
            return this.responseProcessor.processResponse(ErrorContext.builder((HttpRequest)request).cause((Throwable)exception).error(new Error(){

                public String getMessage() {
                    return exception.getMessage();
                }

                public Optional<String> getPath() {
                    return Optional.ofNullable(fieldError).map(FieldError::getField);
                }
            }).build(), response);
        }
        return response.body((Object)new JsonError(exception.getMessage()).path(fieldError != null ? fieldError.getField() : null).link(Link.SELF, Link.of((URI)request.getUri())));
    }
}

