/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.routes;

import io.micronaut.context.env.DefaultPropertyPlaceholderResolver;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultConversionService;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.validation.InternalUriMatchTemplate;
import io.micronaut.validation.routes.RouteParameterElement;
import io.micronaut.validation.routes.RouteValidationResult;
import io.micronaut.validation.routes.rules.MissingParameterRule;
import io.micronaut.validation.routes.rules.NullableParameterRule;
import io.micronaut.validation.routes.rules.RequestBeanParameterRule;
import io.micronaut.validation.routes.rules.RouteValidationRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.SupportedOptions;

@SupportedOptions(value={"micronaut.route.validation"})
public class RouteValidationVisitor
implements TypeElementVisitor<Object, Object> {
    static final String MICRONAUT_PROCESSING_INCREMENTAL = "micronaut.processing.incremental";
    static final String VALIDATION_OPTION = "micronaut.route.validation";
    private static final String METHOD_MAPPING_ANN = "io.micronaut.http.annotation.HttpMethodMapping";
    private List<RouteValidationRule> rules = new ArrayList<RouteValidationRule>();
    private boolean skipValidation = false;
    private final DefaultPropertyPlaceholderResolver resolver = new DefaultPropertyPlaceholderResolver(null, (ConversionService)new DefaultConversionService());

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public Set<String> getSupportedAnnotationNames() {
        return CollectionUtils.setOf((Object[])new String[]{"io.micronaut.http.annotation.Controller", "io.micronaut.http.client.annotation.Client", METHOD_MAPPING_ANN});
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        if (this.skipValidation) {
            return;
        }
        AnnotationValue mappingAnnotation = element.getAnnotation(METHOD_MAPPING_ANN);
        if (mappingAnnotation != null) {
            Set uris = CollectionUtils.setOf((Object[])mappingAnnotation.stringValues("uris"));
            mappingAnnotation.stringValue().ifPresent(uris::add);
            List<InternalUriMatchTemplate> templates = uris.stream().map(uri -> {
                List segments = this.resolver.buildSegments(uri);
                StringBuilder uriValue = new StringBuilder();
                for (DefaultPropertyPlaceholderResolver.Segment segment : segments) {
                    if (segment instanceof DefaultPropertyPlaceholderResolver.RawSegment) {
                        uriValue.append((String)segment.getValue(String.class));
                        continue;
                    }
                    uriValue.append("tmp");
                }
                return InternalUriMatchTemplate.of(uriValue.toString());
            }).collect(Collectors.toList());
            ParameterElement[] parameters = (RouteParameterElement[])Arrays.stream(element.getParameters()).map(RouteParameterElement::new).toArray(RouteParameterElement[]::new);
            for (RouteValidationRule rule : this.rules) {
                RouteValidationResult result = rule.validate(templates, parameters, element);
                if (result.isValid()) continue;
                for (String err : result.getErrorMessages()) {
                    context.fail(err, (Element)element);
                }
            }
        }
    }

    public void start(VisitorContext visitorContext) {
        this.skipValidation = RouteValidationVisitor.shouldSkipRouteValidation(visitorContext);
        this.rules.add(new MissingParameterRule());
        this.rules.add(new NullableParameterRule());
        this.rules.add(new RequestBeanParameterRule());
    }

    private static boolean shouldSkipRouteValidation(VisitorContext visitorContext) {
        String incremental;
        int javaVersion = RouteValidationVisitor.getVersion();
        if (javaVersion < 9 && (incremental = (String)visitorContext.getOptions().get(MICRONAUT_PROCESSING_INCREMENTAL)) != null && incremental.equals("true")) {
            return true;
        }
        String prop = visitorContext.getOptions().getOrDefault(VALIDATION_OPTION, "true");
        return prop != null && prop.equals("false");
    }

    private static int getVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        try {
            return Integer.parseInt(version);
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }
}

