/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.validation.validator.ExecutableMethodValidator;
import io.micronaut.validation.validator.ReactiveValidator;
import io.micronaut.validation.validator.Validator;
import java.lang.reflect.Method;
import java.util.Set;
import javax.inject.Singleton;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;

@Singleton
public class ValidatingInterceptor
implements MethodInterceptor<Object, Object> {
    public static final int POSITION = InterceptPhase.VALIDATE.getPosition();
    @Nullable
    private final ExecutableValidator executableValidator;
    @Nullable
    private final ExecutableMethodValidator micronautValidator;

    public ValidatingInterceptor(@Nullable Validator micronautValidator, @Nullable ValidatorFactory validatorFactory) {
        if (validatorFactory != null) {
            javax.validation.Validator validator = validatorFactory.getValidator();
            if (validator instanceof Validator) {
                this.micronautValidator = (ExecutableMethodValidator)validator;
                this.executableValidator = null;
            } else {
                this.micronautValidator = null;
                this.executableValidator = validator.forExecutables();
            }
        } else if (micronautValidator != null) {
            this.micronautValidator = micronautValidator.forExecutables();
            this.executableValidator = null;
        } else {
            this.micronautValidator = null;
            this.executableValidator = null;
        }
    }

    public int getOrder() {
        return POSITION;
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        if (this.executableValidator != null) {
            Set constraintViolations;
            Method targetMethod = context.getTargetMethod();
            if (targetMethod.getParameterTypes().length != 0 && !(constraintViolations = this.executableValidator.validateParameters(context.getTarget(), targetMethod, context.getParameterValues(), new Class[0])).isEmpty()) {
                throw new ConstraintViolationException(constraintViolations);
            }
            return this.validateReturnExecutableValidator(context, targetMethod);
        }
        if (this.micronautValidator != null) {
            Set<ConstraintViolation<Object>> constraintViolations;
            ExecutableMethod executableMethod = context.getExecutableMethod();
            if (executableMethod.getArguments().length != 0 && !(constraintViolations = this.micronautValidator.validateParameters(context.getTarget(), executableMethod, context.getParameterValues(), new Class[0])).isEmpty()) {
                throw new ConstraintViolationException(constraintViolations);
            }
            if (this.hasValidationAnnotation(context)) {
                if (this.micronautValidator instanceof ReactiveValidator) {
                    InterceptedMethod interceptedMethod = InterceptedMethod.of(context);
                    try {
                        switch (interceptedMethod.resultType()) {
                            case PUBLISHER: {
                                return interceptedMethod.handleResult(((ReactiveValidator)((Object)this.micronautValidator)).validatePublisher(interceptedMethod.interceptResultAsPublisher(), new Class[0]));
                            }
                            case COMPLETION_STAGE: {
                                return interceptedMethod.handleResult(((ReactiveValidator)((Object)this.micronautValidator)).validateCompletionStage(interceptedMethod.interceptResultAsCompletionStage(), new Class[0]));
                            }
                            case SYNCHRONOUS: {
                                return this.validateReturnMicronautValidator(context, (ExecutableMethod<Object, Object>)executableMethod);
                            }
                        }
                        return interceptedMethod.unsupported();
                    }
                    catch (Exception e) {
                        return interceptedMethod.handleException(e);
                    }
                }
                return this.validateReturnMicronautValidator(context, (ExecutableMethod<Object, Object>)executableMethod);
            }
            return context.proceed();
        }
        return context.proceed();
    }

    private Object validateReturnMicronautValidator(MethodInvocationContext<Object, Object> context, ExecutableMethod<Object, Object> executableMethod) {
        Object result = context.proceed();
        Set<ConstraintViolation<Object>> constraintViolations = this.micronautValidator.validateReturnValue(context.getTarget(), executableMethod, result, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
        return result;
    }

    private Object validateReturnExecutableValidator(MethodInvocationContext<Object, Object> context, Method targetMethod) {
        Set constraintViolations;
        Object result = context.proceed();
        if (this.hasValidationAnnotation(context) && !(constraintViolations = this.executableValidator.validateReturnValue(context.getTarget(), targetMethod, result, new Class[0])).isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
        return result;
    }

    private boolean hasValidationAnnotation(MethodInvocationContext<Object, Object> context) {
        return context.hasStereotype(Validator.ANN_VALID) || context.hasStereotype(Validator.ANN_CONSTRAINT);
    }
}

