/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.constraints;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.validation.ValidationException;
import javax.validation.constraints.Pattern;

abstract class AbstractPatternValidator<A extends Annotation>
implements ConstraintValidator<A, CharSequence> {
    private static final Pattern.Flag[] ZERO_FLAGS = new Pattern.Flag[0];
    private static final Map<PatternKey, Pattern> COMPUTED_PATTERNS = new ConcurrentHashMap<PatternKey, Pattern>(10);

    AbstractPatternValidator() {
    }

    Pattern getPattern(@NonNull AnnotationValue<?> annotationMetadata, boolean isOptional) {
        Optional regexp = annotationMetadata.get((CharSequence)"regexp", String.class);
        String pattern = isOptional ? regexp.orElse(".*") : (String)regexp.orElseThrow(() -> new ValidationException("No pattern specified"));
        Pattern.Flag[] flags = annotationMetadata.get((CharSequence)"flags", Pattern.Flag[].class).orElse(ZERO_FLAGS);
        if (isOptional && pattern.equals(".*") && flags.length == 0) {
            return null;
        }
        int computedFlag = 0;
        for (Pattern.Flag flag : flags) {
            computedFlag |= flag.getValue();
        }
        PatternKey key = new PatternKey(pattern, computedFlag);
        Pattern regex = COMPUTED_PATTERNS.get(key);
        if (regex == null) {
            try {
                regex = computedFlag != 0 ? Pattern.compile(pattern, computedFlag) : Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Invalid regular expression", e);
            }
            COMPUTED_PATTERNS.put(key, regex);
        }
        return regex;
    }

    private static final class PatternKey {
        final String pattern;
        final int flags;

        PatternKey(String pattern, int flags) {
            this.pattern = pattern;
            this.flags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatternKey that = (PatternKey)o;
            return this.flags == that.flags && this.pattern.equals(that.pattern);
        }

        public int hashCode() {
            return Objects.hash(this.pattern, this.flags);
        }
    }
}

