/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.extractors;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.validation.validator.extractors.UnwrapByDefaultValueExtractor;
import io.micronaut.validation.validator.extractors.ValueExtractorRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.valueextraction.UnwrapByDefault;
import javax.validation.valueextraction.ValueExtractor;

@Singleton
@Introspected
public class DefaultValueExtractors
implements ValueExtractorRegistry {
    public static final String ITERABLE_ELEMENT_NODE_NAME = "<iterable element>";
    public static final String LIST_ELEMENT_NODE_NAME = "<list element>";
    public static final String MAP_VALUE_NODE_NAME = "<map value>";
    private final UnwrapByDefaultValueExtractor<Optional> optionalValueExtractor = (originalValue, receiver) -> receiver.value(null, originalValue.orElse(null));
    private final UnwrapByDefaultValueExtractor<OptionalInt> optionalIntValueExtractor = (originalValue, receiver) -> receiver.value(null, originalValue.isPresent() ? Integer.valueOf(originalValue.getAsInt()) : null);
    private final UnwrapByDefaultValueExtractor<OptionalLong> optionalLongValueExtractor = (originalValue, receiver) -> receiver.value(null, originalValue.isPresent() ? Long.valueOf(originalValue.getAsLong()) : null);
    private final UnwrapByDefaultValueExtractor<OptionalDouble> optionalDoubleValueExtractor = (originalValue, receiver) -> receiver.value(null, originalValue.isPresent() ? Double.valueOf(originalValue.getAsDouble()) : null);
    private final ValueExtractor<Iterable> iterableValueExtractor = (originalValue, receiver) -> {
        if (originalValue instanceof List) {
            int i = 0;
            for (Object o : originalValue) {
                receiver.indexedValue(LIST_ELEMENT_NODE_NAME, i++, o);
            }
        } else {
            for (Object o : originalValue) {
                receiver.iterableValue(ITERABLE_ELEMENT_NODE_NAME, o);
            }
        }
    };
    private final ValueExtractor<Map<?, ?>> mapValueExtractor = (originalValue, receiver) -> {
        for (Map.Entry entry : originalValue.entrySet()) {
            receiver.keyedValue(MAP_VALUE_NODE_NAME, entry.getKey(), entry.getValue());
        }
    };
    private final ValueExtractor<Object[]> objectArrayValueExtractor = (originalValue, receiver) -> {
        for (int i = 0; i < ((Object[])originalValue).length; ++i) {
            receiver.indexedValue(LIST_ELEMENT_NODE_NAME, i, originalValue[i]);
        }
    };
    private final ValueExtractor<int[]> intArrayValueExtractor = (originalValue, receiver) -> {
        for (int i = 0; i < ((int[])originalValue).length; ++i) {
            receiver.indexedValue(LIST_ELEMENT_NODE_NAME, i, (Object)originalValue[i]);
        }
    };
    private final ValueExtractor<byte[]> byteArrayValueExtractor = (originalValue, receiver) -> {
        for (int i = 0; i < ((byte[])originalValue).length; ++i) {
            receiver.indexedValue(LIST_ELEMENT_NODE_NAME, i, (Object)originalValue[i]);
        }
    };
    private final ValueExtractor<boolean[]> booleanArrayValueExtractor = (originalValue, receiver) -> {
        for (int i = 0; i < ((boolean[])originalValue).length; ++i) {
            receiver.indexedValue(LIST_ELEMENT_NODE_NAME, i, (Object)originalValue[i]);
        }
    };
    private final ValueExtractor<double[]> doubleArrayValueExtractor = (originalValue, receiver) -> {
        for (int i = 0; i < ((double[])originalValue).length; ++i) {
            receiver.indexedValue(LIST_ELEMENT_NODE_NAME, i, (Object)originalValue[i]);
        }
    };
    private final ValueExtractor<char[]> charArrayValueExtractor = (originalValue, receiver) -> {
        for (int i = 0; i < ((char[])originalValue).length; ++i) {
            receiver.indexedValue(LIST_ELEMENT_NODE_NAME, i, (Object)Character.valueOf(originalValue[i]));
        }
    };
    private final ValueExtractor<float[]> floatArrayValueExtractor = (originalValue, receiver) -> {
        for (int i = 0; i < ((float[])originalValue).length; ++i) {
            receiver.indexedValue(LIST_ELEMENT_NODE_NAME, i, (Object)Float.valueOf(originalValue[i]));
        }
    };
    private final ValueExtractor<short[]> shortArrayValueExtractor = (originalValue, receiver) -> {
        for (int i = 0; i < ((short[])originalValue).length; ++i) {
            receiver.indexedValue(LIST_ELEMENT_NODE_NAME, i, (Object)originalValue[i]);
        }
    };
    private final Map<Class, ValueExtractor> valueExtractors;
    private final Set<Class> unwrapByDefaultTypes = new HashSet<Class>(5);

    public DefaultValueExtractors() {
        this(null);
    }

    @Inject
    protected DefaultValueExtractors(@Nullable BeanContext beanContext) {
        ValueExtractor valueExtractor;
        Collection valueExtractors;
        BeanWrapper wrapper = BeanWrapper.findWrapper((Object)this).orElse(null);
        HashMap<Object, ValueExtractor> extractorMap = new HashMap<Object, ValueExtractor>();
        if (beanContext != null && beanContext.containsBean(ValueExtractor.class) && CollectionUtils.isNotEmpty((Collection)(valueExtractors = beanContext.getBeanRegistrations(ValueExtractor.class)))) {
            for (BeanRegistration reg : valueExtractors) {
                valueExtractor = (ValueExtractor)reg.getBean();
                Object[] typeParameters = reg.getBeanDefinition().getTypeParameters(ValueExtractor.class);
                if (!ArrayUtils.isNotEmpty((Object[])typeParameters)) continue;
                Object targetType = typeParameters[0];
                extractorMap.put(targetType, valueExtractor);
                if (!(valueExtractor instanceof UnwrapByDefaultValueExtractor) && !valueExtractor.getClass().isAnnotationPresent(UnwrapByDefault.class)) continue;
                this.unwrapByDefaultTypes.add((Class)targetType);
            }
        }
        if (wrapper != null) {
            Collection properties = wrapper.getBeanProperties();
            for (BeanProperty property : properties) {
                if (!ValueExtractor.class.isAssignableFrom(property.getType())) continue;
                valueExtractor = wrapper.getProperty(property.getName(), ValueExtractor.class).orElse(null);
                Class targetType = property.asArgument().getFirstTypeVariable().map(Argument::getType).orElse(null);
                extractorMap.put(targetType, valueExtractor);
                if (!(valueExtractor instanceof UnwrapByDefaultValueExtractor) && !valueExtractor.getClass().isAnnotationPresent(UnwrapByDefault.class)) continue;
                this.unwrapByDefaultTypes.add(targetType);
            }
            this.valueExtractors = new HashMap<Class, ValueExtractor>(extractorMap.size());
            this.valueExtractors.putAll(extractorMap);
        } else {
            this.valueExtractors = Collections.emptyMap();
        }
    }

    public UnwrapByDefaultValueExtractor<Optional> getOptionalValueExtractor() {
        return this.optionalValueExtractor;
    }

    public UnwrapByDefaultValueExtractor<OptionalInt> getOptionalIntValueExtractor() {
        return this.optionalIntValueExtractor;
    }

    public UnwrapByDefaultValueExtractor<OptionalLong> getOptionalLongValueExtractor() {
        return this.optionalLongValueExtractor;
    }

    public UnwrapByDefaultValueExtractor<OptionalDouble> getOptionalDoubleValueExtractor() {
        return this.optionalDoubleValueExtractor;
    }

    public ValueExtractor<Iterable> getIterableValueExtractor() {
        return this.iterableValueExtractor;
    }

    public ValueExtractor<Map<?, ?>> getMapValueExtractor() {
        return this.mapValueExtractor;
    }

    public ValueExtractor<Object[]> getObjectArrayValueExtractor() {
        return this.objectArrayValueExtractor;
    }

    public ValueExtractor<int[]> getIntArrayValueExtractor() {
        return this.intArrayValueExtractor;
    }

    public ValueExtractor<byte[]> getByteArrayValueExtractor() {
        return this.byteArrayValueExtractor;
    }

    public ValueExtractor<char[]> getCharArrayValueExtractor() {
        return this.charArrayValueExtractor;
    }

    public ValueExtractor<boolean[]> getBooleanArrayValueExtractor() {
        return this.booleanArrayValueExtractor;
    }

    public ValueExtractor<double[]> getDoubleArrayValueExtractor() {
        return this.doubleArrayValueExtractor;
    }

    public ValueExtractor<float[]> getFloatArrayValueExtractor() {
        return this.floatArrayValueExtractor;
    }

    public ValueExtractor<short[]> getShortArrayValueExtractor() {
        return this.shortArrayValueExtractor;
    }

    @Override
    @Nonnull
    public <T> Optional<ValueExtractor<T>> findValueExtractor(@Nonnull Class<T> targetType) {
        ValueExtractor valueExtractor = this.valueExtractors.get(targetType);
        if (valueExtractor != null) {
            return Optional.of(valueExtractor);
        }
        return this.valueExtractors.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(targetType)).map(Map.Entry::getValue).findFirst();
    }

    @Override
    @Nonnull
    public <T> Optional<ValueExtractor<T>> findUnwrapValueExtractor(@Nonnull Class<T> targetType) {
        if (this.unwrapByDefaultTypes.contains(targetType)) {
            return Optional.ofNullable(this.valueExtractors.get(targetType));
        }
        return Optional.empty();
    }
}

