/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Constraint;
import javax.validation.ConstraintTarget;
import javax.validation.ConstraintValidator;
import javax.validation.Payload;
import javax.validation.Valid;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.ContainerElementTypeDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.GroupConversionDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.MethodType;
import javax.validation.metadata.PropertyDescriptor;
import javax.validation.metadata.Scope;
import javax.validation.metadata.ValidateUnwrappedValue;

@Internal
class IntrospectedBeanDescriptor
implements BeanDescriptor,
ElementDescriptor.ConstraintFinder {
    private final BeanIntrospection<?> beanIntrospection;

    IntrospectedBeanDescriptor(BeanIntrospection<?> beanIntrospection) {
        ArgumentUtils.requireNonNull((String)"beanIntrospection", beanIntrospection);
        this.beanIntrospection = beanIntrospection;
    }

    public boolean isBeanConstrained() {
        return this.hasConstraints();
    }

    public PropertyDescriptor getConstraintsForProperty(String propertyName) {
        return this.beanIntrospection.getProperty(propertyName).map(x$0 -> new IntrospectedPropertyDescriptor((BeanProperty<?, ?>)x$0)).orElse(null);
    }

    public Set<PropertyDescriptor> getConstrainedProperties() {
        return this.beanIntrospection.getIndexedProperties(Constraint.class).stream().map(x$0 -> new IntrospectedPropertyDescriptor((BeanProperty<?, ?>)x$0)).collect(Collectors.toSet());
    }

    public MethodDescriptor getConstraintsForMethod(String methodName, Class<?> ... parameterTypes) {
        return null;
    }

    public Set<MethodDescriptor> getConstrainedMethods(MethodType methodType, MethodType ... methodTypes) {
        return Collections.emptySet();
    }

    public ConstructorDescriptor getConstraintsForConstructor(Class<?> ... parameterTypes) {
        return null;
    }

    public Set<ConstructorDescriptor> getConstrainedConstructors() {
        return Collections.emptySet();
    }

    public boolean hasConstraints() {
        return this.beanIntrospection.getIndexedProperty(Constraint.class).isPresent();
    }

    public Class<?> getElementClass() {
        return this.beanIntrospection.getBeanType();
    }

    public ElementDescriptor.ConstraintFinder unorderedAndMatchingGroups(Class<?> ... groups) {
        return this;
    }

    public ElementDescriptor.ConstraintFinder lookingAt(Scope scope) {
        return this;
    }

    public ElementDescriptor.ConstraintFinder declaredOn(ElementType ... types) {
        return this;
    }

    public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        return Collections.emptySet();
    }

    public ElementDescriptor.ConstraintFinder findConstraints() {
        return this;
    }

    private class DefaultConstraintDescriptor<T extends Annotation>
    implements ConstraintDescriptor<T> {
        private final AnnotationValue<T> annotationValue;
        private final AnnotationMetadata annotationMetadata;
        private final Class<T> type;

        DefaultConstraintDescriptor(AnnotationMetadata annotationMetadata, Class<T> type, AnnotationValue<T> annotationValue) {
            this.annotationValue = annotationValue;
            this.annotationMetadata = annotationMetadata;
            this.type = type;
        }

        public T getAnnotation() {
            return (T)this.annotationMetadata.synthesize(this.type);
        }

        public String getMessageTemplate() {
            return this.annotationValue.get((CharSequence)"groups", String.class).orElse(null);
        }

        public Set<Class<?>> getGroups() {
            Set<Class<?>> groups = this.annotationValue.get((CharSequence)"groups", Argument.setOf(Class.class)).orElse(Collections.emptySet());
            return groups;
        }

        public Set<Class<? extends Payload>> getPayload() {
            Set<Class<? extends Payload>> payload = this.annotationValue.get((CharSequence)"payload", Argument.setOf(Class.class)).orElse(Collections.emptySet());
            return payload;
        }

        public ConstraintTarget getValidationAppliesTo() {
            return ConstraintTarget.IMPLICIT;
        }

        public List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorClasses() {
            return Collections.emptyList();
        }

        public Map<String, Object> getAttributes() {
            return this.annotationValue.getValues().entrySet().stream().collect(Collectors.toMap(entry -> ((CharSequence)entry.getKey()).toString(), Map.Entry::getValue));
        }

        public Set<ConstraintDescriptor<?>> getComposingConstraints() {
            return Collections.emptySet();
        }

        public boolean isReportAsSingleViolation() {
            return false;
        }

        public ValidateUnwrappedValue getValueUnwrapping() {
            return ValidateUnwrappedValue.DEFAULT;
        }

        public Object unwrap(Class type) {
            throw new UnsupportedOperationException("Unwrapping unsupported");
        }
    }

    private final class IntrospectedPropertyDescriptor
    implements PropertyDescriptor,
    ElementDescriptor.ConstraintFinder {
        private final BeanProperty<?, ?> beanProperty;

        IntrospectedPropertyDescriptor(BeanProperty<?, ?> beanProperty) {
            this.beanProperty = beanProperty;
        }

        public String getPropertyName() {
            return this.beanProperty.getName();
        }

        public boolean isCascaded() {
            return this.beanProperty.hasAnnotation(Valid.class);
        }

        public Set<GroupConversionDescriptor> getGroupConversions() {
            return Collections.emptySet();
        }

        public Set<ContainerElementTypeDescriptor> getConstrainedContainerElementTypes() {
            return Collections.emptySet();
        }

        public boolean hasConstraints() {
            return this.beanProperty.hasStereotype(Constraint.class);
        }

        public Class<?> getElementClass() {
            return this.beanProperty.getType();
        }

        public ElementDescriptor.ConstraintFinder unorderedAndMatchingGroups(Class<?> ... groups) {
            return this;
        }

        public ElementDescriptor.ConstraintFinder lookingAt(Scope scope) {
            return this;
        }

        public ElementDescriptor.ConstraintFinder declaredOn(ElementType ... types) {
            return this;
        }

        public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
            return this.beanProperty.getAnnotationTypesByStereotype(Constraint.class).stream().map(type -> {
                AnnotationValue annotation = this.beanProperty.getAnnotation(type);
                DefaultConstraintDescriptor descriptor = new DefaultConstraintDescriptor(this.beanProperty.getAnnotationMetadata(), type, annotation);
                return descriptor;
            }).collect(Collectors.toSet());
        }

        public ElementDescriptor.ConstraintFinder findConstraints() {
            return this;
        }
    }
}

