/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.constraints;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.Digits;

@FunctionalInterface
public interface DigitsValidator<T>
extends ConstraintValidator<Digits, T> {
    @Override
    default public boolean isValid(@Nullable T value, @Nonnull AnnotationValue<Digits> annotationMetadata, @Nonnull ConstraintValidatorContext context) {
        BigDecimal bigDecimal;
        if (value == null) {
            return true;
        }
        int intMax = annotationMetadata.get((CharSequence)"integer", Integer.TYPE).orElse(0);
        int fracMax = annotationMetadata.get((CharSequence)"fraction", Integer.TYPE).orElse(0);
        if (intMax < 0) {
            throw new IllegalArgumentException("The length of the integer part cannot be negative.");
        }
        if (fracMax < 0) {
            throw new IllegalArgumentException("The length of the fraction part cannot be negative.");
        }
        try {
            bigDecimal = this.getBigDecimal(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        int intLen = bigDecimal.precision() - bigDecimal.scale();
        int fracLen = bigDecimal.scale() < 0 ? 0 : bigDecimal.scale();
        return intMax >= intLen && fracMax >= fracLen;
    }

    public BigDecimal getBigDecimal(@Nonnull T var1);
}

