/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.properties;

import io.micronaut.context.annotation.Property;
import io.micronaut.context.env.DefaultPropertyPlaceholderResolver;
import io.micronaut.context.env.PropertySourcePropertyResolver;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class MixedCasePropertyTypeElementVisitor
implements TypeElementVisitor<Object, Object> {
    private boolean skipValidation = false;
    private final DefaultPropertyPlaceholderResolver resolver = new DefaultPropertyPlaceholderResolver((PropertyResolver)new PropertySourcePropertyResolver(), (ConversionService)new DefaultConversionService());

    public void visitClass(ClassElement element, VisitorContext context) {
        this.visitElement((Element)element, context);
    }

    public void visitField(FieldElement element, VisitorContext context) {
        this.visitElement((Element)element, context);
    }

    public void visitConstructor(ConstructorElement element, VisitorContext context) {
        for (ParameterElement parameter : element.getParameters()) {
            this.visitElement((Element)parameter, context);
        }
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        this.visitElement((Element)element, context);
    }

    public void start(VisitorContext visitorContext) {
        String prop = System.getProperty("micronaut.configuration.validation");
        this.skipValidation = prop != null && prop.equals("false");
    }

    private void visitElement(Element element, VisitorContext context) {
        String propertyName;
        if (this.skipValidation) {
            return;
        }
        AnnotationValue propertyAnnotation = element.getAnnotation(Property.class);
        if (propertyAnnotation != null && !NameUtils.isValidHyphenatedPropertyName((String)(propertyName = (String)propertyAnnotation.getRequiredValue("name", String.class)))) {
            this.emitError(propertyName, element, context);
        }
        Set annotationNames = element.getAnnotationNames();
        for (String annotationName : annotationNames) {
            if (!annotationName.startsWith("io.micronaut.")) continue;
            AnnotationValue annotationValue = element.getAnnotation(annotationName);
            Map values = annotationValue.getValues();
            for (Map.Entry entry : values.entrySet()) {
                String[] annValues;
                Optional optAnnValue;
                String key;
                Object value = entry.getValue();
                if (value instanceof String) {
                    key = (String)entry.getKey();
                    optAnnValue = annotationValue.get((CharSequence)key, String.class);
                    if (!optAnnValue.isPresent()) continue;
                    String annValue = (String)optAnnValue.get();
                    this.checkValidPropertyName(annValue, element, context);
                    continue;
                }
                if (!(value instanceof String[]) || !(optAnnValue = annotationValue.get((CharSequence)(key = (String)entry.getKey()), String[].class)).isPresent()) continue;
                for (String annValue : annValues = (String[])optAnnValue.get()) {
                    this.checkValidPropertyName(annValue, element, context);
                }
            }
        }
    }

    private void checkValidPropertyName(String value, Element element, VisitorContext context) {
        this.resolver.buildSegments(value).stream().filter(DefaultPropertyPlaceholderResolver.PlaceholderSegment.class::isInstance).map(DefaultPropertyPlaceholderResolver.PlaceholderSegment.class::cast).flatMap(placeholder -> placeholder.getExpressions().stream()).forEach(propertyName -> {
            if (!this.isValidPropertyName((String)propertyName)) {
                this.emitError((String)propertyName, element, context);
            }
        });
    }

    private boolean isValidPropertyName(String value) {
        return NameUtils.isEnvironmentName((String)value) || NameUtils.isValidHyphenatedPropertyName((String)value);
    }

    private void emitError(String value, Element element, VisitorContext context) {
        String kebabCaseValue = NameUtils.hyphenate((String)value);
        context.fail("Value '" + value + "' is not valid property placeholder. Please use kebab-case notation, for example '" + kebabCaseValue + "'.", element);
    }
}

