/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import javax.inject.Singleton;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ValidatingInterceptor
implements MethodInterceptor {
    public static final int POSITION = InterceptPhase.VALIDATE.getPosition();
    private static final Logger LOG = LoggerFactory.getLogger(ValidatingInterceptor.class);
    private final ExecutableValidator executableValidator;

    public ValidatingInterceptor(Optional<ValidatorFactory> validatorFactory) {
        this.executableValidator = validatorFactory.map(factory -> factory.getValidator().forExecutables()).orElse(null);
        if (this.executableValidator == null && LOG.isWarnEnabled()) {
            LOG.warn("Beans requiring validation present, but no implementation of javax.validation configuration. Add an implementation (such as hibernate-validator) to prevent this error.");
        }
    }

    public int getOrder() {
        return POSITION;
    }

    public Object intercept(MethodInvocationContext context) {
        if (this.executableValidator == null) {
            return context.proceed();
        }
        Method targetMethod = context.getTargetMethod();
        if (targetMethod.getParameterTypes().length == 0) {
            return context.proceed();
        }
        Set constraintViolations = this.executableValidator.validateParameters(context.getTarget(), targetMethod, context.getParameterValues(), new Class[0]);
        if (constraintViolations.isEmpty()) {
            return context.proceed();
        }
        throw new ConstraintViolationException(constraintViolations);
    }
}

