/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.session;

import io.micronaut.caffeine.cache.Cache;
import io.micronaut.caffeine.cache.Caffeine;
import io.micronaut.caffeine.cache.Expiry;
import io.micronaut.caffeine.cache.RemovalListener;
import io.micronaut.caffeine.cache.Scheduler;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.session.InMemorySession;
import io.micronaut.session.Session;
import io.micronaut.session.SessionConfiguration;
import io.micronaut.session.SessionIdGenerator;
import io.micronaut.session.SessionStore;
import io.micronaut.session.event.SessionCreatedEvent;
import io.micronaut.session.event.SessionDeletedEvent;
import io.micronaut.session.event.SessionDestroyedEvent;
import io.micronaut.session.event.SessionExpiredEvent;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@Singleton
@Primary
public class InMemorySessionStore
implements SessionStore<InMemorySession> {
    private final SessionConfiguration sessionConfiguration;
    private final ApplicationEventPublisher eventPublisher;
    private final Cache<String, InMemorySession> sessions;
    private final SessionIdGenerator sessionIdGenerator;

    public InMemorySessionStore(SessionIdGenerator sessionIdGenerator, SessionConfiguration sessionConfiguration, ApplicationEventPublisher eventPublisher) {
        this.sessionIdGenerator = sessionIdGenerator;
        this.eventPublisher = eventPublisher;
        this.sessionConfiguration = sessionConfiguration;
        this.sessions = this.newSessionCache(sessionConfiguration);
    }

    @Override
    public InMemorySession newSession() {
        return new InMemorySession(this.sessionIdGenerator.generateId(), this.sessionConfiguration.getMaxInactiveInterval());
    }

    @Override
    public CompletableFuture<Optional<InMemorySession>> findSession(String id) {
        InMemorySession session = (InMemorySession)this.sessions.getIfPresent((Object)id);
        return CompletableFuture.completedFuture(Optional.ofNullable(session != null && !session.isExpired() ? session : null));
    }

    @Override
    public CompletableFuture<Boolean> deleteSession(String id) {
        this.sessions.invalidate((Object)id);
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<InMemorySession> save(InMemorySession session) {
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null");
        }
        String id = session.getId();
        session.setNew(false);
        InMemorySession existing = (InMemorySession)this.sessions.getIfPresent((Object)id);
        if (session != existing) {
            this.sessions.put((Object)id, (Object)session);
            if (existing == null) {
                this.eventPublisher.publishEvent((Object)new SessionCreatedEvent(session));
            }
        }
        return CompletableFuture.completedFuture(session);
    }

    @Internal
    void cleanUp() {
        this.sessions.cleanUp();
    }

    protected Cache<String, InMemorySession> newSessionCache(SessionConfiguration configuration) {
        Caffeine builder = Caffeine.newBuilder().removalListener(this.newRemovalListener());
        if (configuration.isPromptExpiration()) {
            configuration.getExecutorService().map(Scheduler::forScheduledExecutorService).ifPresent(arg_0 -> ((Caffeine)builder).scheduler(arg_0));
        }
        builder.expireAfter(this.newExpiry());
        configuration.getMaxActiveSessions().ifPresent(arg_0 -> ((Caffeine)builder).maximumSize(arg_0));
        return builder.build();
    }

    private Expiry<String, InMemorySession> newExpiry() {
        return new Expiry<String, InMemorySession>(){

            public long expireAfterCreate(String key, InMemorySession value, long currentTime) {
                return this.newExpiry(value);
            }

            public long expireAfterUpdate(String key, InMemorySession value, long currentTime, long currentDuration) {
                return this.newExpiry(value);
            }

            public long expireAfterRead(String key, InMemorySession value, long currentTime, long currentDuration) {
                return this.newExpiry(value);
            }

            private long newExpiry(InMemorySession value) {
                Instant current = Instant.now();
                value.setLastAccessedTime(current);
                return value.getMaxInactiveInterval().toNanos();
            }
        };
    }

    private RemovalListener<String, Session> newRemovalListener() {
        return (key, value, cause) -> {
            switch (cause) {
                case REPLACED: {
                    this.eventPublisher.publishEvent((Object)new SessionDestroyedEvent((Session)value));
                    break;
                }
                case SIZE: 
                case EXPIRED: {
                    this.eventPublisher.publishEvent((Object)new SessionExpiredEvent((Session)value));
                    break;
                }
                case EXPLICIT: {
                    this.eventPublisher.publishEvent((Object)new SessionDeletedEvent((Session)value));
                    break;
                }
                default: {
                    throw new IllegalStateException("Session should never be garbage collectable");
                }
            }
        };
    }
}

