/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.session.http;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.session.Session;
import io.micronaut.session.http.HttpSessionConfiguration;
import io.micronaut.session.http.HttpSessionIdStrategy;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.List;

@Singleton
@Requires(property="micronaut.session.http.header", notEquals="false")
public class HeadersHttpSessionIdStrategy
implements HttpSessionIdStrategy {
    private final String[] headerNames;

    public HeadersHttpSessionIdStrategy(HttpSessionConfiguration configuration) {
        this.headerNames = configuration.getHeaderNames();
        if (ArrayUtils.isEmpty((Object[])this.headerNames)) {
            throw new ConfigurationException("At least one header name is required");
        }
    }

    public String[] getHeaderNames() {
        return this.headerNames;
    }

    @Override
    public List<String> resolveIds(HttpRequest<?> message) {
        for (String headerName : this.headerNames) {
            List all = message.getHeaders().getAll((CharSequence)headerName);
            if (all.isEmpty()) continue;
            return all;
        }
        return Collections.emptyList();
    }

    @Override
    public void encodeId(HttpRequest<?> request, MutableHttpResponse<?> response, Session session) {
        MutableHttpHeaders headers = response.getHeaders();
        if (session.isExpired()) {
            headers.add((CharSequence)this.headerNames[0], (CharSequence)"");
        } else {
            headers.add((CharSequence)this.headerNames[0], (CharSequence)session.getId());
        }
    }
}

