/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.session.http;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.session.Session;
import io.micronaut.session.http.CookieHttpSessionIdGenerator;
import io.micronaut.session.http.HttpSessionConfiguration;
import io.micronaut.session.http.HttpSessionIdStrategy;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="micronaut.session.http.cookie", notEquals="false")
public class CookieHttpSessionStrategy
implements HttpSessionIdStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(CookieHttpSessionStrategy.class);
    private final HttpSessionConfiguration configuration;
    private final CookieHttpSessionIdGenerator cookieHttpSessionIdGenerator;

    public CookieHttpSessionStrategy(HttpSessionConfiguration configuration) {
        this(configuration, new CookieHttpSessionIdGenerator(configuration));
    }

    public CookieHttpSessionStrategy(HttpSessionConfiguration configuration, CookieHttpSessionIdGenerator cookieHttpSessionIdGenerator) {
        this.configuration = configuration;
        this.cookieHttpSessionIdGenerator = cookieHttpSessionIdGenerator;
    }

    @Override
    public List<String> resolveIds(HttpRequest<?> message) {
        Cookies cookies = message.getCookies();
        ArrayList<String> resolvedIds = new ArrayList<String>();
        String cookieName = this.getConfiguration().getCookieName();
        for (Map.Entry entry : cookies) {
            String name = (String)entry.getKey();
            if (!cookieName.equalsIgnoreCase(name)) continue;
            Cookie cookie = (Cookie)entry.getValue();
            String id = this.cookieHttpSessionIdGenerator.sessionIdFromCookie(cookie);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("path {}, session id: {}", (Object)id, (Object)message.getPath());
            }
            resolvedIds.add(id);
        }
        return resolvedIds;
    }

    @Override
    public void encodeId(HttpRequest<?> request, MutableHttpResponse<?> response, Session session) {
        Cookie cookie;
        HttpSessionConfiguration configuration = this.getConfiguration();
        if (session.isExpired()) {
            cookie = Cookie.of((String)configuration.getCookieName(), (String)"").maxAge(0L);
        } else {
            String cookieValue = this.cookieHttpSessionIdGenerator.cookieValueFromSession(session);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("path {}, cookie value {}", (Object)request.getPath(), (Object)cookieValue);
            }
            cookie = Cookie.of((String)configuration.getCookieName(), (String)cookieValue);
            if (configuration.isRememberMe()) {
                cookie.maxAge(Integer.MAX_VALUE);
            } else {
                configuration.getCookieMaxAge().ifPresent(maxAge -> cookie.maxAge(maxAge.get(ChronoUnit.SECONDS)));
            }
        }
        cookie.httpOnly(true).secure(configuration.isCookieSecure().orElse(request.isSecure()).booleanValue());
        configuration.getCookiePath().ifPresent(arg_0 -> ((Cookie)cookie).path(arg_0));
        configuration.getDomainName().ifPresent(arg_0 -> ((Cookie)cookie).domain(arg_0));
        configuration.getCookieSameSite().ifPresent(arg_0 -> ((Cookie)cookie).sameSite(arg_0));
        response.cookie(cookie);
    }

    public HttpSessionConfiguration getConfiguration() {
        return this.configuration;
    }
}

