/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.session.http;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.http.cookie.SameSite;
import io.micronaut.session.SessionConfiguration;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Optional;

@ConfigurationProperties(value="http")
public class HttpSessionConfiguration
extends SessionConfiguration
implements CookieConfiguration {
    public static final String DEFAULT_COOKIEPATH = "/";
    public static final String DEFAULT_COOKIENAME = "SESSION";
    public static final boolean DEFAULT_REMEMBERME = false;
    public static final boolean DEFAULT_BASE64ENCODE = true;
    private boolean rememberMe = false;
    private boolean base64Encode = true;
    private Duration cookieMaxAge;
    private Boolean cookieSecure;
    private SameSite sameSite;
    private String cookiePath = "/";
    private String domainName;
    private String cookieName = "SESSION";
    private String prefix;
    private String[] headerNames = new String[]{"Authorization-Info", "X-Auth-Token"};

    public boolean isBase64Encode() {
        return this.base64Encode;
    }

    public void setBase64Encode(boolean base64Encode) {
        this.base64Encode = base64Encode;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public Optional<String> getPrefix() {
        return Optional.ofNullable(this.prefix);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String[] getHeaderNames() {
        return this.headerNames;
    }

    public void setHeaderNames(String[] headerNames) {
        this.headerNames = headerNames;
    }

    public Optional<String> getCookiePath() {
        return Optional.ofNullable(this.cookiePath);
    }

    public Optional<Boolean> isCookieHttpOnly() {
        return Optional.empty();
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public Optional<String> getDomainName() {
        return Optional.ofNullable(this.domainName);
    }

    public Optional<String> getCookieDomain() {
        return Optional.ofNullable(this.domainName);
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setCookieDomain(String cookieDomain) {
        this.domainName = cookieDomain;
    }

    public Optional<TemporalAmount> getCookieMaxAge() {
        return Optional.ofNullable(this.cookieMaxAge);
    }

    public void setCookieMaxAge(Duration cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }

    public Optional<Boolean> isCookieSecure() {
        return Optional.ofNullable(this.cookieSecure);
    }

    public void setCookieSecure(Boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }

    public Optional<SameSite> getCookieSameSite() {
        return Optional.ofNullable(this.sameSite);
    }

    public void setCookieSameSite(SameSite sameSite) {
        this.sameSite = sameSite;
    }
}

