/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.writer;

import io.micronaut.aop.HotSwappableInterceptedProxy;
import io.micronaut.aop.Intercepted;
import io.micronaut.aop.InterceptedProxy;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.Introduced;
import io.micronaut.aop.chain.InterceptorChain;
import io.micronaut.aop.chain.MethodInterceptorChain;
import io.micronaut.asm.AnnotationVisitor;
import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.Label;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.asm.commons.Method;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.ProxyBeanDefinition;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.writer.AbstractClassFileWriter;
import io.micronaut.inject.writer.BeanDefinitionWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.ExecutableMethodWriter;
import io.micronaut.inject.writer.ProxyingBeanDefinitionVisitor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;

public class AopProxyWriter
extends AbstractClassFileWriter
implements ProxyingBeanDefinitionVisitor {
    public static final int HASHCODE = 31;
    public static final int MAX_LOCALS = 3;
    public static final Method METHOD_GET_PROXY_TARGET = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(ExecutionHandleLocator.class, (String)"getProxyTargetMethod", (Class[])new Class[]{Class.class, String.class, Class[].class}));
    public static final Method METHOD_GET_PROXY_TARGET_BEAN = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(BeanLocator.class, (String)"getProxyTargetBean", (Class[])new Class[]{Class.class, Qualifier.class}));
    public static final io.micronaut.asm.Type FIELD_TYPE_INTERCEPTORS = io.micronaut.asm.Type.getType(Interceptor[][].class);
    public static final io.micronaut.asm.Type TYPE_INTERCEPTOR_CHAIN = io.micronaut.asm.Type.getType(InterceptorChain.class);
    public static final io.micronaut.asm.Type TYPE_METHOD_INTERCEPTOR_CHAIN = io.micronaut.asm.Type.getType(MethodInterceptorChain.class);
    public static final String FIELD_TARGET = "$target";
    public static final String FIELD_READ_WRITE_LOCK = "$target_rwl";
    public static final io.micronaut.asm.Type TYPE_READ_WRITE_LOCK = io.micronaut.asm.Type.getType(ReentrantReadWriteLock.class);
    public static final String FIELD_READ_LOCK = "$target_rl";
    public static final String FIELD_WRITE_LOCK = "$target_wl";
    public static final io.micronaut.asm.Type TYPE_LOCK = io.micronaut.asm.Type.getType(Lock.class);
    public static final io.micronaut.asm.Type TYPE_BEAN_LOCATOR = io.micronaut.asm.Type.getType(BeanLocator.class);
    public static final String METHOD_RESOLVE_TARGET = "$resolveTarget";
    private static final Method METHOD_PROXY_TARGET_TYPE = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(ProxyBeanDefinition.class, (String)"getTargetDefinitionType", (Class[])new Class[0]));
    private static final Method METHOD_PROXY_TARGET_CLASS = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(ProxyBeanDefinition.class, (String)"getTargetType", (Class[])new Class[0]));
    private static final java.lang.reflect.Method RESOLVE_INTRODUCTION_INTERCEPTORS_METHOD = ReflectionUtils.getRequiredInternalMethod(InterceptorChain.class, (String)"resolveIntroductionInterceptors", (Class[])new Class[]{BeanContext.class, ExecutableMethod.class, Interceptor[].class});
    private static final java.lang.reflect.Method RESOLVE_AROUND_INTERCEPTORS_METHOD = ReflectionUtils.getRequiredInternalMethod(InterceptorChain.class, (String)"resolveAroundInterceptors", (Class[])new Class[]{BeanContext.class, ExecutableMethod.class, Interceptor[].class});
    private static final Constructor CONSTRUCTOR_METHOD_INTERCEPTOR_CHAIN = (Constructor)ReflectionUtils.findConstructor(MethodInterceptorChain.class, (Class[])new Class[]{Interceptor[].class, Object.class, ExecutableMethod.class, Object[].class}).orElseThrow(() -> new IllegalStateException("new MethodInterceptorChain(..) constructor not found. Incompatible version of Micronaut?"));
    private static final String FIELD_INTERCEPTORS = "$interceptors";
    private static final String FIELD_BEAN_LOCATOR = "$beanLocator";
    private static final String FIELD_BEAN_QUALIFIER = "$beanQualifier";
    private static final String FIELD_PROXY_METHODS = "$proxyMethods";
    private static final io.micronaut.asm.Type FIELD_TYPE_PROXY_METHODS = io.micronaut.asm.Type.getType(ExecutableMethod[].class);
    private static final io.micronaut.asm.Type EXECUTABLE_METHOD_TYPE = io.micronaut.asm.Type.getType(ExecutableMethod.class);
    private static final io.micronaut.asm.Type INTERCEPTOR_ARRAY_TYPE = io.micronaut.asm.Type.getType(Interceptor[].class);
    private final String packageName;
    private final String targetClassShortName;
    private final ClassWriter classWriter;
    private final String targetClassFullName;
    private final String proxyFullName;
    private final BeanDefinitionWriter proxyBeanDefinitionWriter;
    private final String proxyInternalName;
    private final Set<Object> interceptorTypes;
    private final Set<Object> interfaceTypes;
    private final io.micronaut.asm.Type proxyType;
    private final boolean hotswap;
    private final boolean lazy;
    private final boolean isInterface;
    private final BeanDefinitionWriter parentWriter;
    private final boolean isIntroduction;
    private final boolean implementInterface;
    private boolean isProxyTarget;
    private MethodVisitor constructorWriter;
    private List<ExecutableMethodWriter> proxiedMethods = new ArrayList<ExecutableMethodWriter>();
    private Set<MethodRef> proxiedMethodsRefSet = new HashSet<MethodRef>();
    private List<MethodRef> proxyTargetMethods = new ArrayList<MethodRef>();
    private int proxyMethodCount = 0;
    private GeneratorAdapter constructorGenerator;
    private int interceptorArgumentIndex;
    private int beanContextArgumentIndex = -1;
    private Map<String, Object> constructorArgumentTypes;
    private Map<String, AnnotationMetadata> constructArgumentMetadata;
    private Map<String, Map<String, Object>> constructorGenericTypes;
    private Map<String, Object> constructorNewArgumentTypes;
    private List<Runnable> deferredInjectionPoints = new ArrayList<Runnable>();
    private AnnotationMetadata constructorAnnotationMedata;
    private boolean constructorRequriesReflection;

    public AopProxyWriter(BeanDefinitionWriter parent, Object ... interceptorTypes) {
        this(parent, (OptionalValues<Boolean>)OptionalValues.empty(), interceptorTypes);
    }

    public AopProxyWriter(BeanDefinitionWriter parent, OptionalValues<Boolean> settings, Object ... interceptorTypes) {
        this.isIntroduction = false;
        this.implementInterface = true;
        this.parentWriter = parent;
        this.isProxyTarget = settings.get(Interceptor.PROXY_TARGET).orElse(false) != false || parent.isInterface();
        this.hotswap = this.isProxyTarget && settings.get(Interceptor.HOTSWAP).orElse(false) != false;
        this.lazy = this.isProxyTarget && settings.get(Interceptor.LAZY).orElse(false) != false;
        this.isInterface = parent.isInterface();
        this.packageName = parent.getPackageName();
        this.targetClassShortName = parent.getBeanSimpleName();
        this.targetClassFullName = this.packageName + '.' + this.targetClassShortName;
        this.classWriter = new ClassWriter(3);
        this.proxyFullName = parent.getBeanDefinitionName() + "$Intercepted";
        String proxyShortName = NameUtils.getSimpleName((String)this.proxyFullName);
        this.proxyInternalName = AopProxyWriter.getInternalName((String)this.proxyFullName);
        this.proxyType = AopProxyWriter.getTypeReference((Object)this.proxyFullName);
        this.interceptorTypes = new HashSet<Object>(Arrays.asList(interceptorTypes));
        this.interfaceTypes = Collections.emptySet();
        this.proxyBeanDefinitionWriter = new BeanDefinitionWriter(NameUtils.getPackageName((String)this.proxyFullName), proxyShortName, this.isInterface, parent.getAnnotationMetadata());
        this.startClass((ClassVisitor)this.classWriter, AopProxyWriter.getInternalName((String)this.proxyFullName), AopProxyWriter.getTypeReference((Object)this.targetClassFullName));
    }

    public AopProxyWriter(String packageName, String className, boolean isInterface, AnnotationMetadata annotationMetadata, Object[] interfaceTypes, Object ... interceptorTypes) {
        this(packageName, className, isInterface, true, annotationMetadata, interfaceTypes, interceptorTypes);
    }

    public AopProxyWriter(String packageName, String className, boolean isInterface, boolean implementInterface, AnnotationMetadata annotationMetadata, Object[] interfaceTypes, Object ... interceptorTypes) {
        this.isIntroduction = true;
        this.implementInterface = implementInterface;
        if (!implementInterface && ArrayUtils.isEmpty((Object[])interfaceTypes)) {
            throw new IllegalArgumentException("if argument implementInterface is false at least one interface should be provided to the 'interfaceTypes' argument");
        }
        this.packageName = packageName;
        this.isInterface = isInterface;
        this.hotswap = false;
        this.lazy = false;
        this.targetClassShortName = className;
        this.targetClassFullName = packageName + '.' + this.targetClassShortName;
        this.parentWriter = null;
        this.proxyFullName = this.targetClassFullName + "$Intercepted";
        this.proxyInternalName = AopProxyWriter.getInternalName((String)this.proxyFullName);
        this.proxyType = AopProxyWriter.getTypeReference((Object)this.proxyFullName);
        this.interceptorTypes = new HashSet<Object>(Arrays.asList(interceptorTypes));
        this.interfaceTypes = interfaceTypes != null ? new HashSet<Object>(Arrays.asList(interfaceTypes)) : Collections.emptySet();
        this.classWriter = new ClassWriter(3);
        String proxyShortName = NameUtils.getSimpleName((String)this.proxyFullName);
        this.proxyBeanDefinitionWriter = new BeanDefinitionWriter(NameUtils.getPackageName((String)this.proxyFullName), proxyShortName, isInterface, annotationMetadata);
        this.startClass((ClassVisitor)this.classWriter, this.proxyInternalName, AopProxyWriter.getTypeReference((Object)this.targetClassFullName));
    }

    protected void startClass(ClassVisitor classWriter, String className, io.micronaut.asm.Type superType) {
        String[] interfaces = this.getImplementedInterfaceInternalNames();
        classWriter.visit(52, 1, className, null, !this.isInterface ? superType.getInternalName() : null, interfaces);
        classWriter.visitField(18, FIELD_INTERCEPTORS, FIELD_TYPE_INTERCEPTORS.getDescriptor(), null, null);
        classWriter.visitField(18, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS.getDescriptor(), null, null);
    }

    private String[] getImplementedInterfaceInternalNames() {
        return (String[])this.interfaceTypes.stream().map(o -> AopProxyWriter.getTypeReference((Object)o).getInternalName()).toArray(String[]::new);
    }

    public void visitBeanDefinitionConstructor(AnnotationMetadata annotationMetadata, boolean requiresReflection) {
        this.visitBeanDefinitionConstructor(annotationMetadata, requiresReflection, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    public boolean isSingleton() {
        return this.proxyBeanDefinitionWriter.isSingleton();
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void visitBeanDefinitionInterface(Class<? extends BeanDefinition> interfaceType) {
        this.proxyBeanDefinitionWriter.visitBeanDefinitionInterface(interfaceType);
    }

    public String getBeanTypeName() {
        return this.proxyBeanDefinitionWriter.getBeanTypeName();
    }

    public io.micronaut.asm.Type getProvidedType() {
        return this.proxyBeanDefinitionWriter.getProvidedType();
    }

    public void setValidated(boolean validated) {
        this.proxyBeanDefinitionWriter.setValidated(validated);
    }

    public boolean isValidated() {
        return this.proxyBeanDefinitionWriter.isValidated();
    }

    public String getBeanDefinitionName() {
        return this.proxyBeanDefinitionWriter.getBeanDefinitionName();
    }

    public void visitBeanDefinitionConstructor(AnnotationMetadata annotationMetadata, boolean requiresReflection, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes) {
        this.constructorAnnotationMedata = annotationMetadata;
        this.constructorRequriesReflection = requiresReflection;
        this.constructorArgumentTypes = argumentTypes;
        this.constructArgumentMetadata = argumentAnnotationMetadata;
        this.constructorGenericTypes = genericTypes;
        this.constructorNewArgumentTypes = new LinkedHashMap<String, Object>(argumentTypes);
        this.beanContextArgumentIndex = argumentTypes.size();
        this.constructorNewArgumentTypes.put("beanContext", BeanContext.class);
        this.interceptorArgumentIndex = this.constructorNewArgumentTypes.size();
        this.constructorNewArgumentTypes.put("interceptors", Interceptor[].class);
    }

    public void visitAroundMethod(Object declaringType, Object returnType, Object genericReturnType, Map<String, Object> returnTypeGenericTypes, String methodName, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes, AnnotationMetadata annotationMetadata) {
        this.visitExecutableMethod(declaringType, returnType, genericReturnType, returnTypeGenericTypes, methodName, argumentTypes, argumentAnnotationMetadata, genericTypes, annotationMetadata);
        final ArrayList<Object> argumentTypeList = new ArrayList<Object>(argumentTypes.values());
        int argumentCount = argumentTypes.size();
        io.micronaut.asm.Type returnTypeObject = AopProxyWriter.getTypeReference((Object)returnType);
        boolean isPrimitive = AopProxyWriter.isPrimitive((Object)returnType);
        final boolean isVoidReturn = isPrimitive && returnTypeObject.equals((Object)io.micronaut.asm.Type.VOID_TYPE);
        io.micronaut.asm.Type declaringTypeReference = AopProxyWriter.getTypeReference((Object)declaringType);
        MethodRef methodKey = new MethodRef(methodName, argumentTypeList, returnTypeObject);
        if (this.isProxyTarget) {
            if (!this.proxyTargetMethods.contains(methodKey)) {
                int index = this.proxyMethodCount++;
                this.proxyTargetMethods.add(methodKey);
                this.buildMethodOverride(returnType, methodName, index, argumentTypeList, argumentCount, isVoidReturn);
            }
        } else if (!this.proxiedMethodsRefSet.contains(methodKey)) {
            int index = this.proxyMethodCount++;
            String methodProxyShortName = "$$proxy" + index;
            final String bridgeName = "$$access" + index;
            String methodExecutorClassName = this.proxyFullName + methodProxyShortName;
            ArrayList<Object> bridgeArguments = new ArrayList<Object>();
            bridgeArguments.add(this.proxyFullName);
            bridgeArguments.addAll(argumentTypeList);
            final String bridgeDesc = AopProxyWriter.getMethodDescriptor((Object)returnType, bridgeArguments);
            ExecutableMethodWriter executableMethodWriter = new ExecutableMethodWriter(this.proxyFullName, methodExecutorClassName, methodProxyShortName, this.isInterface, annotationMetadata){

                protected void buildInvokeMethod(io.micronaut.asm.Type declaringTypeObject, String methodName, Object returnType, Collection<Object> argumentTypes, GeneratorAdapter invokeMethodVisitor) {
                    invokeMethodVisitor.loadThis();
                    invokeMethodVisitor.getField(this.methodType, "$parent", AopProxyWriter.this.proxyType);
                    for (int i = 0; i < argumentTypeList.size(); ++i) {
                        invokeMethodVisitor.loadArg(1);
                        invokeMethodVisitor.push(i);
                        invokeMethodVisitor.visitInsn(50);
                        AopProxyWriter.pushCastToType((MethodVisitor)invokeMethodVisitor, argumentTypeList.get(i));
                    }
                    invokeMethodVisitor.visitMethodInsn(184, AopProxyWriter.this.proxyInternalName, bridgeName, bridgeDesc, false);
                    if (isVoidReturn) {
                        invokeMethodVisitor.visitInsn(1);
                    } else {
                        AopProxyWriter.pushBoxPrimitiveIfNecessary((Object)returnType, (MethodVisitor)invokeMethodVisitor);
                    }
                    invokeMethodVisitor.visitInsn(176);
                    invokeMethodVisitor.visitMaxs(13, 1);
                    invokeMethodVisitor.visitEnd();
                }
            };
            executableMethodWriter.makeInner(this.proxyInternalName, this.classWriter);
            executableMethodWriter.visitMethod(declaringType, returnType, genericReturnType, returnTypeGenericTypes, methodName, argumentTypes, argumentAnnotationMetadata, genericTypes);
            this.proxiedMethods.add(executableMethodWriter);
            this.proxiedMethodsRefSet.add(methodKey);
            String overrideDescriptor = this.buildMethodOverride(returnType, methodName, index, argumentTypeList, argumentCount, isVoidReturn);
            MethodVisitor bridgeWriter = this.classWriter.visitMethod(4104, bridgeName, bridgeDesc, null, null);
            GeneratorAdapter bridgeGenerator = new GeneratorAdapter(bridgeWriter, 4104, bridgeName, bridgeDesc);
            for (int i = 0; i < bridgeArguments.size(); ++i) {
                bridgeGenerator.loadArg(i);
            }
            bridgeWriter.visitMethodInsn(183, declaringTypeReference.getInternalName(), methodName, overrideDescriptor, false);
            AopProxyWriter.pushReturnValue((MethodVisitor)bridgeWriter, (Object)returnType);
            bridgeWriter.visitMaxs(13, 1);
            bridgeWriter.visitEnd();
        }
    }

    private String buildMethodOverride(Object returnType, String methodName, int index, List<Object> argumentTypeList, int argumentCount, boolean isVoidReturn) {
        String desc = AopProxyWriter.getMethodDescriptor((Object)returnType, argumentTypeList);
        MethodVisitor overridden = this.classWriter.visitMethod(1, methodName, desc, null, null);
        GeneratorAdapter overriddenMethodGenerator = new GeneratorAdapter(overridden, 1, methodName, desc);
        overriddenMethodGenerator.loadThis();
        overriddenMethodGenerator.getField(this.proxyType, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS);
        overriddenMethodGenerator.push(index);
        overriddenMethodGenerator.visitInsn(50);
        int methodProxyVar = overriddenMethodGenerator.newLocal(EXECUTABLE_METHOD_TYPE);
        overriddenMethodGenerator.storeLocal(methodProxyVar);
        overriddenMethodGenerator.loadThis();
        overriddenMethodGenerator.getField(this.proxyType, FIELD_INTERCEPTORS, FIELD_TYPE_INTERCEPTORS);
        overriddenMethodGenerator.push(index);
        overriddenMethodGenerator.visitInsn(50);
        int interceptorsLocalVar = overriddenMethodGenerator.newLocal(INTERCEPTOR_ARRAY_TYPE);
        overriddenMethodGenerator.storeLocal(interceptorsLocalVar);
        overriddenMethodGenerator.newInstance(TYPE_METHOD_INTERCEPTOR_CHAIN);
        overriddenMethodGenerator.dup();
        overriddenMethodGenerator.loadLocal(interceptorsLocalVar);
        overriddenMethodGenerator.loadThis();
        if (this.isProxyTarget) {
            if (this.hotswap || this.lazy) {
                overriddenMethodGenerator.invokeInterface(io.micronaut.asm.Type.getType(InterceptedProxy.class), Method.getMethod((String)"java.lang.Object interceptedTarget()"));
            } else {
                overriddenMethodGenerator.getField(this.proxyType, FIELD_TARGET, AopProxyWriter.getTypeReference((Object)this.targetClassFullName));
            }
        }
        overriddenMethodGenerator.loadLocal(methodProxyVar);
        overriddenMethodGenerator.push(argumentCount);
        overriddenMethodGenerator.newArray(io.micronaut.asm.Type.getType(Object.class));
        for (int i = 0; i < argumentCount; ++i) {
            overriddenMethodGenerator.dup();
            Object argType = argumentTypeList.get(i);
            overriddenMethodGenerator.push(i);
            overriddenMethodGenerator.loadArg(i);
            AopProxyWriter.pushBoxPrimitiveIfNecessary((Object)argType, (MethodVisitor)overriddenMethodGenerator);
            overriddenMethodGenerator.visitInsn(83);
        }
        overriddenMethodGenerator.invokeConstructor(TYPE_METHOD_INTERCEPTOR_CHAIN, Method.getMethod((Constructor)CONSTRUCTOR_METHOD_INTERCEPTOR_CHAIN));
        int chainVar = overriddenMethodGenerator.newLocal(TYPE_METHOD_INTERCEPTOR_CHAIN);
        overriddenMethodGenerator.storeLocal(chainVar);
        overriddenMethodGenerator.loadLocal(chainVar);
        overriddenMethodGenerator.visitMethodInsn(182, TYPE_INTERCEPTOR_CHAIN.getInternalName(), "proceed", AopProxyWriter.getMethodDescriptor((String)Object.class.getName(), (String[])new String[0]), false);
        if (isVoidReturn) {
            this.returnVoid(overriddenMethodGenerator);
        } else {
            AopProxyWriter.pushCastToType((MethodVisitor)overriddenMethodGenerator, (Object)returnType);
            AopProxyWriter.pushReturnValue((MethodVisitor)overriddenMethodGenerator, (Object)returnType);
        }
        overriddenMethodGenerator.visitMaxs(13, chainVar);
        overriddenMethodGenerator.visitEnd();
        return desc;
    }

    public void visitBeanDefinitionEnd() {
        Object[] adviceInterfaces;
        if (this.constructorArgumentTypes == null) {
            throw new IllegalStateException("The method visitBeanDefinitionConstructor(..) should be called at least once");
        }
        final io.micronaut.asm.Type[] interceptorTypes = this.getObjectTypes(this.interceptorTypes);
        this.constructArgumentMetadata = new LinkedHashMap<String, AnnotationMetadata>(this.constructArgumentMetadata);
        this.constructArgumentMetadata.put("interceptors", (AnnotationMetadata)new DefaultAnnotationMetadata(){
            {
                this.addDeclaredAnnotation(Type.class.getName(), Collections.singletonMap("value", Arrays.stream(interceptorTypes).map(io.micronaut.asm.Type::getClassName).toArray()));
            }
        });
        String constructorDescriptor = AopProxyWriter.getConstructorDescriptor(this.constructorNewArgumentTypes.values());
        ClassWriter proxyClassWriter = this.classWriter;
        this.constructorWriter = proxyClassWriter.visitMethod(1, "<init>", constructorDescriptor, null, null);
        AnnotationVisitor interceptorTypeAnn = this.constructorWriter.visitParameterAnnotation(this.interceptorArgumentIndex, io.micronaut.asm.Type.getDescriptor(Type.class), true).visitArray("value");
        for (io.micronaut.asm.Type interceptorType : interceptorTypes) {
            interceptorTypeAnn.visit(null, (Object)interceptorType);
        }
        interceptorTypeAnn.visitEnd();
        GeneratorAdapter proxyConstructorGenerator = this.constructorGenerator = new GeneratorAdapter(this.constructorWriter, 1, "<init>", constructorDescriptor);
        proxyConstructorGenerator.loadThis();
        if (this.isInterface) {
            proxyConstructorGenerator.invokeConstructor(TYPE_OBJECT, METHOD_DEFAULT_CONSTRUCTOR);
        } else {
            Collection<Object> existingArguments = this.constructorArgumentTypes.values();
            for (int i = 0; i < existingArguments.size(); ++i) {
                proxyConstructorGenerator.loadArg(i);
            }
            String superConstructorDescriptor = AopProxyWriter.getConstructorDescriptor(existingArguments);
            proxyConstructorGenerator.invokeConstructor(AopProxyWriter.getTypeReference((Object)this.targetClassFullName), new Method("<init>", superConstructorDescriptor));
        }
        this.proxyBeanDefinitionWriter.visitBeanDefinitionConstructor(this.constructorAnnotationMedata, this.constructorRequriesReflection, this.constructorNewArgumentTypes, this.constructArgumentMetadata, this.constructorGenericTypes);
        GeneratorAdapter targetDefinitionGenerator = null;
        GeneratorAdapter targetTypeGenerator = null;
        if (this.parentWriter != null) {
            this.proxyBeanDefinitionWriter.visitBeanDefinitionInterface(ProxyBeanDefinition.class);
            ClassVisitor pcw = this.proxyBeanDefinitionWriter.getClassWriter();
            targetDefinitionGenerator = new GeneratorAdapter(pcw.visitMethod(1, METHOD_PROXY_TARGET_TYPE.getName(), METHOD_PROXY_TARGET_TYPE.getDescriptor(), null, null), 1, METHOD_PROXY_TARGET_TYPE.getName(), METHOD_PROXY_TARGET_TYPE.getDescriptor());
            targetDefinitionGenerator.loadThis();
            targetDefinitionGenerator.push(AopProxyWriter.getTypeReference((Object)this.parentWriter.getBeanDefinitionName()));
            targetDefinitionGenerator.returnValue();
            targetTypeGenerator = new GeneratorAdapter(pcw.visitMethod(1, METHOD_PROXY_TARGET_CLASS.getName(), METHOD_PROXY_TARGET_CLASS.getDescriptor(), null, null), 1, METHOD_PROXY_TARGET_CLASS.getName(), METHOD_PROXY_TARGET_CLASS.getDescriptor());
            targetTypeGenerator.loadThis();
            targetTypeGenerator.push(AopProxyWriter.getTypeReference((Object)this.parentWriter.getBeanTypeName()));
            targetTypeGenerator.returnValue();
        }
        Class interceptedInterface = this.isIntroduction ? Introduced.class : Intercepted.class;
        io.micronaut.asm.Type targetType = AopProxyWriter.getTypeReference((Object)this.targetClassFullName);
        if (this.isProxyTarget) {
            proxyClassWriter.visitField(18, FIELD_BEAN_LOCATOR, TYPE_BEAN_LOCATOR.getDescriptor(), null, null);
            proxyClassWriter.visitField(2, FIELD_BEAN_QUALIFIER, io.micronaut.asm.Type.getType(Qualifier.class).getDescriptor(), null, null);
            this.writeWithQualifierMethod(proxyClassWriter);
            if (this.lazy) {
                interceptedInterface = InterceptedProxy.class;
            } else {
                interceptedInterface = this.hotswap ? HotSwappableInterceptedProxy.class : InterceptedProxy.class;
                int modifiers = this.hotswap ? 2 : 18;
                proxyClassWriter.visitField(modifiers, FIELD_TARGET, targetType.getDescriptor(), null, null);
                if (this.hotswap) {
                    proxyClassWriter.visitField(18, FIELD_READ_WRITE_LOCK, TYPE_READ_WRITE_LOCK.getDescriptor(), null, null);
                    proxyConstructorGenerator.loadThis();
                    proxyConstructorGenerator.newInstance(TYPE_READ_WRITE_LOCK);
                    proxyConstructorGenerator.dup();
                    proxyConstructorGenerator.invokeConstructor(TYPE_READ_WRITE_LOCK, METHOD_DEFAULT_CONSTRUCTOR);
                    proxyConstructorGenerator.putField(this.proxyType, FIELD_READ_WRITE_LOCK, TYPE_READ_WRITE_LOCK);
                    proxyClassWriter.visitField(18, FIELD_READ_LOCK, TYPE_LOCK.getDescriptor(), null, null);
                    proxyConstructorGenerator.loadThis();
                    proxyConstructorGenerator.loadThis();
                    proxyConstructorGenerator.getField(this.proxyType, FIELD_READ_WRITE_LOCK, TYPE_READ_WRITE_LOCK);
                    proxyConstructorGenerator.invokeInterface(io.micronaut.asm.Type.getType(ReadWriteLock.class), Method.getMethod((String)(Lock.class.getName() + " readLock()")));
                    proxyConstructorGenerator.putField(this.proxyType, FIELD_READ_LOCK, TYPE_LOCK);
                    proxyClassWriter.visitField(18, FIELD_WRITE_LOCK, io.micronaut.asm.Type.getDescriptor(Lock.class), null, null);
                    proxyConstructorGenerator.loadThis();
                    proxyConstructorGenerator.loadThis();
                    proxyConstructorGenerator.getField(this.proxyType, FIELD_READ_WRITE_LOCK, TYPE_READ_WRITE_LOCK);
                    proxyConstructorGenerator.invokeInterface(io.micronaut.asm.Type.getType(ReadWriteLock.class), Method.getMethod((String)(Lock.class.getName() + " writeLock()")));
                    proxyConstructorGenerator.putField(this.proxyType, FIELD_WRITE_LOCK, TYPE_LOCK);
                }
            }
            proxyConstructorGenerator.loadThis();
            proxyConstructorGenerator.loadArg(this.beanContextArgumentIndex);
            proxyConstructorGenerator.putField(this.proxyType, FIELD_BEAN_LOCATOR, TYPE_BEAN_LOCATOR);
            Method resolveTargetMethodDesc = this.writeResolveTargetMethod(proxyClassWriter, targetType);
            if (!this.lazy) {
                proxyConstructorGenerator.loadThis();
                proxyConstructorGenerator.loadThis();
                proxyConstructorGenerator.invokeVirtual(this.proxyType, resolveTargetMethodDesc);
                proxyConstructorGenerator.putField(this.proxyType, FIELD_TARGET, targetType);
            }
            this.writeInterceptedTargetMethod(proxyClassWriter, targetType, resolveTargetMethodDesc);
            if (this.hotswap && !this.lazy) {
                this.writeSwapMethod(proxyClassWriter, targetType);
            }
        }
        Object[] interfaces = this.getImplementedInterfaceInternalNames();
        if (this.isInterface && this.implementInterface) {
            adviceInterfaces = new String[]{AopProxyWriter.getInternalName((String)this.targetClassFullName), io.micronaut.asm.Type.getInternalName(interceptedInterface)};
            interfaces = (String[])ArrayUtils.concat((Object[])interfaces, (Object[])adviceInterfaces);
        } else {
            adviceInterfaces = new String[]{io.micronaut.asm.Type.getInternalName(interceptedInterface)};
            interfaces = (String[])ArrayUtils.concat((Object[])interfaces, (Object[])adviceInterfaces);
        }
        proxyClassWriter.visit(52, 1, this.proxyInternalName, null, this.isInterface ? TYPE_OBJECT.getInternalName() : AopProxyWriter.getTypeReference((Object)this.targetClassFullName).getInternalName(), (String[])interfaces);
        proxyConstructorGenerator.loadThis();
        proxyConstructorGenerator.push(this.proxyMethodCount);
        proxyConstructorGenerator.newArray(EXECUTABLE_METHOD_TYPE);
        proxyConstructorGenerator.putField(this.proxyType, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS);
        proxyConstructorGenerator.loadThis();
        proxyConstructorGenerator.push(this.proxyMethodCount);
        proxyConstructorGenerator.newArray(INTERCEPTOR_ARRAY_TYPE);
        proxyConstructorGenerator.putField(this.proxyType, FIELD_INTERCEPTORS, FIELD_TYPE_INTERCEPTORS);
        if (this.isProxyTarget) {
            if (this.proxyTargetMethods.size() == this.proxyMethodCount) {
                Iterator<MethodRef> iterator = this.proxyTargetMethods.iterator();
                for (int i = 0; i < this.proxyMethodCount; ++i) {
                    MethodRef methodRef = iterator.next();
                    proxyConstructorGenerator.loadThis();
                    proxyConstructorGenerator.getField(this.proxyType, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS);
                    proxyConstructorGenerator.push(i);
                    proxyConstructorGenerator.loadArg(this.beanContextArgumentIndex);
                    proxyConstructorGenerator.push(targetType);
                    AopProxyWriter.pushMethodNameAndTypesArguments((GeneratorAdapter)proxyConstructorGenerator, (String)methodRef.name, methodRef.argumentTypes);
                    proxyConstructorGenerator.invokeInterface(io.micronaut.asm.Type.getType(ExecutionHandleLocator.class), METHOD_GET_PROXY_TARGET);
                    proxyConstructorGenerator.visitInsn(83);
                    this.pushResolveInterceptorsCall(proxyConstructorGenerator, i);
                }
            }
        } else {
            for (int i = 0; i < this.proxyMethodCount; ++i) {
                ExecutableMethodWriter executableMethodWriter = this.proxiedMethods.get(i);
                proxyConstructorGenerator.loadThis();
                proxyConstructorGenerator.getField(this.proxyType, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS);
                proxyConstructorGenerator.push(i);
                io.micronaut.asm.Type methodType = io.micronaut.asm.Type.getObjectType((String)executableMethodWriter.getInternalName());
                proxyConstructorGenerator.newInstance(methodType);
                proxyConstructorGenerator.dup();
                proxyConstructorGenerator.loadThis();
                proxyConstructorGenerator.invokeConstructor(methodType, new Method("<init>", AopProxyWriter.getConstructorDescriptor((Object[])new Object[]{this.proxyFullName})));
                proxyConstructorGenerator.visitInsn(83);
                this.pushResolveInterceptorsCall(proxyConstructorGenerator, i);
            }
        }
        for (Runnable fieldInjectionPoint : this.deferredInjectionPoints) {
            fieldInjectionPoint.run();
        }
        this.constructorWriter.visitInsn(177);
        this.constructorWriter.visitMaxs(13, 1);
        this.constructorWriter.visitEnd();
        this.proxyBeanDefinitionWriter.visitBeanDefinitionEnd();
        if (targetDefinitionGenerator != null) {
            targetDefinitionGenerator.visitMaxs(1, 1);
            targetDefinitionGenerator.visitEnd();
        }
        if (targetTypeGenerator != null) {
            targetTypeGenerator.visitMaxs(1, 1);
            targetTypeGenerator.visitEnd();
        }
        proxyClassWriter.visitEnd();
    }

    public void writeTo(File compilationDir) throws IOException {
        this.accept(this.newClassWriterOutputVisitor(compilationDir));
    }

    public void accept(ClassWriterOutputVisitor visitor) throws IOException {
        this.proxyBeanDefinitionWriter.accept(visitor);
        try (OutputStream out = visitor.visitClass(this.proxyFullName);){
            out.write(this.classWriter.toByteArray());
            for (ExecutableMethodWriter method : this.proxiedMethods) {
                method.accept(visitor);
            }
        }
    }

    public void visitSuperBeanDefinition(String name) {
        this.proxyBeanDefinitionWriter.visitSuperBeanDefinition(name);
    }

    public void visitSuperBeanDefinitionFactory(String beanName) {
        this.proxyBeanDefinitionWriter.visitSuperBeanDefinitionFactory(beanName);
    }

    public void visitSetterValue(Object declaringType, AnnotationMetadata annotationMetadata, boolean requiresReflection, Object fieldType, String fieldName, String setterName, Map<String, Object> genericTypes, boolean isOptional) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitSetterValue(declaringType, annotationMetadata, requiresReflection, fieldType, fieldName, setterName, genericTypes, isOptional));
    }

    public void visitSetterValue(Object declaringType, AnnotationMetadata setterMetadata, boolean requiresReflection, Object valueType, String setterName, Map<String, Object> genericTypes, AnnotationMetadata setterArgumentMetadata, boolean isOptional) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitSetterValue(declaringType, setterMetadata, requiresReflection, valueType, setterName, genericTypes, setterArgumentMetadata, isOptional));
    }

    public void visitPostConstructMethod(Object declaringType, boolean requiresReflection, Object returnType, String methodName, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes, AnnotationMetadata annotationMetadata) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitPostConstructMethod(declaringType, requiresReflection, returnType, methodName, argumentTypes, argumentAnnotationMetadata, genericTypes, annotationMetadata));
    }

    public void visitPreDestroyMethod(Object declaringType, boolean requiresReflection, Object returnType, String methodName, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes, AnnotationMetadata annotationMetadata) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitPreDestroyMethod(declaringType, requiresReflection, returnType, methodName, argumentTypes, argumentAnnotationMetadata, genericTypes, annotationMetadata));
    }

    public void visitMethodInjectionPoint(Object declaringType, boolean requiresReflection, Object returnType, String methodName, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes, AnnotationMetadata annotationMetadata) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitMethodInjectionPoint(declaringType, requiresReflection, returnType, methodName, argumentTypes, argumentAnnotationMetadata, genericTypes, annotationMetadata));
    }

    public ExecutableMethodWriter visitExecutableMethod(Object declaringType, Object returnType, Object genericReturnType, Map<String, Object> returnTypeGenericTypes, String methodName, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes, AnnotationMetadata annotationMetadata) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitExecutableMethod(declaringType, returnType, genericReturnType, returnTypeGenericTypes, methodName, argumentTypes, argumentAnnotationMetadata, genericTypes, annotationMetadata));
        return null;
    }

    public void visitFieldInjectionPoint(Object declaringType, Object fieldType, String fieldName, boolean requiresReflection, AnnotationMetadata annotationMetadata, @Nullable Map<String, Object> typeArguments) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitFieldInjectionPoint(declaringType, fieldType, fieldName, requiresReflection, annotationMetadata, typeArguments));
    }

    public void visitFieldValue(Object declaringType, Object fieldType, String fieldName, boolean requiresReflection, AnnotationMetadata annotationMetadata, @Nullable Map<String, Object> typeArguments, boolean isOptional) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitFieldValue(declaringType, fieldType, fieldName, requiresReflection, annotationMetadata, typeArguments, isOptional));
    }

    public String getPackageName() {
        return this.proxyBeanDefinitionWriter.getPackageName();
    }

    public String getBeanSimpleName() {
        return this.proxyBeanDefinitionWriter.getBeanSimpleName();
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.proxyBeanDefinitionWriter.getAnnotationMetadata();
    }

    public void visitConfigBuilderField(Object type, String field, AnnotationMetadata annotationMetadata, ConfigurationMetadataBuilder metadataBuilder) {
        this.proxyBeanDefinitionWriter.visitConfigBuilderField(type, field, annotationMetadata, metadataBuilder);
    }

    public void visitConfigBuilderMethod(Object type, String methodName, AnnotationMetadata annotationMetadata, ConfigurationMetadataBuilder metadataBuilder) {
        this.proxyBeanDefinitionWriter.visitConfigBuilderMethod(type, methodName, annotationMetadata, metadataBuilder);
    }

    public void visitConfigBuilderMethod(String prefix, String configurationPrefix, Object returnType, String methodName, Object paramType, Map<String, Object> generics) {
        this.proxyBeanDefinitionWriter.visitConfigBuilderMethod(prefix, configurationPrefix, returnType, methodName, paramType, generics);
    }

    public void visitConfigBuilderDurationMethod(String prefix, String configurationPrefix, Object returnType, String methodName) {
        this.proxyBeanDefinitionWriter.visitConfigBuilderDurationMethod(prefix, configurationPrefix, returnType, methodName);
    }

    public void visitConfigBuilderEnd() {
        this.proxyBeanDefinitionWriter.visitConfigBuilderEnd();
    }

    public void setRequiresMethodProcessing(boolean shouldPreProcess) {
        this.proxyBeanDefinitionWriter.setRequiresMethodProcessing(shouldPreProcess);
    }

    public void visitTypeArguments(Map<String, Map<String, Object>> typeArguments) {
        this.proxyBeanDefinitionWriter.visitTypeArguments(typeArguments);
    }

    public boolean requiresMethodProcessing() {
        return this.proxyBeanDefinitionWriter.requiresMethodProcessing();
    }

    public String getProxiedTypeName() {
        return this.targetClassFullName;
    }

    public String getProxiedBeanDefinitionName() {
        return this.parentWriter != null ? this.parentWriter.getBeanDefinitionName() : null;
    }

    public void visitInterceptorTypes(Object ... interceptorTypes) {
        if (interceptorTypes != null) {
            this.interceptorTypes.addAll(Arrays.asList(interceptorTypes));
        }
    }

    private void readUnlock(GeneratorAdapter interceptedTargetVisitor) {
        this.invokeMethodOnLock(interceptedTargetVisitor, FIELD_READ_LOCK, Method.getMethod((String)"void unlock()"));
    }

    private void readLock(GeneratorAdapter interceptedTargetVisitor) {
        this.invokeMethodOnLock(interceptedTargetVisitor, FIELD_READ_LOCK, Method.getMethod((String)"void lock()"));
    }

    private void writeUnlock(GeneratorAdapter interceptedTargetVisitor) {
        this.invokeMethodOnLock(interceptedTargetVisitor, FIELD_WRITE_LOCK, Method.getMethod((String)"void unlock()"));
    }

    private void writeLock(GeneratorAdapter interceptedTargetVisitor) {
        this.invokeMethodOnLock(interceptedTargetVisitor, FIELD_WRITE_LOCK, Method.getMethod((String)"void lock()"));
    }

    private void invokeMethodOnLock(GeneratorAdapter interceptedTargetVisitor, String field, Method method) {
        interceptedTargetVisitor.loadThis();
        interceptedTargetVisitor.getField(this.proxyType, field, TYPE_LOCK);
        interceptedTargetVisitor.invokeInterface(TYPE_LOCK, method);
    }

    private Method writeResolveTargetMethod(ClassWriter proxyClassWriter, io.micronaut.asm.Type targetType) {
        Method resolveTargetMethodDesc = Method.getMethod((String)(this.targetClassFullName + " " + METHOD_RESOLVE_TARGET + "()"));
        GeneratorAdapter resolveTargetMethod = new GeneratorAdapter(proxyClassWriter.visitMethod(2, resolveTargetMethodDesc.getName(), resolveTargetMethodDesc.getDescriptor(), null, null), 2, METHOD_RESOLVE_TARGET, resolveTargetMethodDesc.getDescriptor());
        resolveTargetMethod.loadThis();
        resolveTargetMethod.getField(this.proxyType, FIELD_BEAN_LOCATOR, TYPE_BEAN_LOCATOR);
        resolveTargetMethod.push(targetType);
        resolveTargetMethod.loadThis();
        resolveTargetMethod.getField(this.proxyType, FIELD_BEAN_QUALIFIER, io.micronaut.asm.Type.getType(Qualifier.class));
        resolveTargetMethod.invokeInterface(TYPE_BEAN_LOCATOR, METHOD_GET_PROXY_TARGET_BEAN);
        AopProxyWriter.pushCastToType((MethodVisitor)resolveTargetMethod, (Object)this.targetClassFullName);
        resolveTargetMethod.returnValue();
        resolveTargetMethod.visitMaxs(1, 1);
        return resolveTargetMethodDesc;
    }

    private void writeWithQualifierMethod(ClassWriter proxyClassWriter) {
        GeneratorAdapter withQualifierMethod = this.startPublicMethod(proxyClassWriter, "$withBeanQualifier", Void.TYPE.getName(), new String[]{Qualifier.class.getName()});
        withQualifierMethod.loadThis();
        withQualifierMethod.loadArg(0);
        withQualifierMethod.putField(this.proxyType, FIELD_BEAN_QUALIFIER, io.micronaut.asm.Type.getType(Qualifier.class));
        withQualifierMethod.visitInsn(177);
        withQualifierMethod.visitEnd();
        withQualifierMethod.visitMaxs(1, 1);
    }

    private void writeSwapMethod(ClassWriter proxyClassWriter, io.micronaut.asm.Type targetType) {
        GeneratorAdapter swapGenerator = this.startPublicMethod(proxyClassWriter, "swap", targetType.getClassName(), new String[]{targetType.getClassName()});
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        swapGenerator.visitTryCatchBlock(l0, l1, l2, null);
        this.writeLock(swapGenerator);
        swapGenerator.visitLabel(l0);
        swapGenerator.loadThis();
        swapGenerator.getField(this.proxyType, FIELD_TARGET, targetType);
        int localRef = swapGenerator.newLocal(targetType);
        swapGenerator.storeLocal(localRef);
        swapGenerator.loadThis();
        swapGenerator.visitVarInsn(25, 1);
        swapGenerator.putField(this.proxyType, FIELD_TARGET, targetType);
        swapGenerator.visitLabel(l1);
        this.writeUnlock(swapGenerator);
        swapGenerator.loadLocal(localRef);
        swapGenerator.returnValue();
        swapGenerator.visitLabel(l2);
        int var = swapGenerator.newLocal(targetType);
        swapGenerator.storeLocal(var);
        this.writeUnlock(swapGenerator);
        swapGenerator.loadLocal(var);
        swapGenerator.throwException();
        swapGenerator.visitMaxs(2, 3);
        swapGenerator.visitEnd();
    }

    private void writeInterceptedTargetMethod(ClassWriter proxyClassWriter, io.micronaut.asm.Type targetType, Method resolveTargetMethodDesc) {
        GeneratorAdapter interceptedTargetVisitor = this.startPublicMethod(proxyClassWriter, "interceptedTarget", Object.class.getName(), new String[0]);
        if (this.lazy) {
            interceptedTargetVisitor.loadThis();
            interceptedTargetVisitor.invokeVirtual(this.proxyType, resolveTargetMethodDesc);
            interceptedTargetVisitor.returnValue();
        } else {
            int localRef = -1;
            Label l1 = null;
            Label l2 = null;
            if (this.hotswap) {
                Label l0 = new Label();
                l1 = new Label();
                l2 = new Label();
                interceptedTargetVisitor.visitTryCatchBlock(l0, l1, l2, null);
                this.readLock(interceptedTargetVisitor);
                interceptedTargetVisitor.visitLabel(l0);
            }
            interceptedTargetVisitor.loadThis();
            interceptedTargetVisitor.getField(this.proxyType, FIELD_TARGET, targetType);
            if (this.hotswap) {
                localRef = interceptedTargetVisitor.newLocal(targetType);
                interceptedTargetVisitor.storeLocal(localRef);
                interceptedTargetVisitor.visitLabel(l1);
                this.readUnlock(interceptedTargetVisitor);
                interceptedTargetVisitor.loadLocal(localRef);
            }
            interceptedTargetVisitor.returnValue();
            if (localRef > -1) {
                interceptedTargetVisitor.visitLabel(l2);
                int var = interceptedTargetVisitor.newLocal(targetType);
                interceptedTargetVisitor.storeLocal(var);
                this.readUnlock(interceptedTargetVisitor);
                interceptedTargetVisitor.loadLocal(var);
                interceptedTargetVisitor.throwException();
            }
        }
        interceptedTargetVisitor.visitMaxs(1, 2);
        interceptedTargetVisitor.visitEnd();
    }

    private void pushResolveInterceptorsCall(GeneratorAdapter proxyConstructorGenerator, int i) {
        proxyConstructorGenerator.loadThis();
        proxyConstructorGenerator.getField(this.proxyType, FIELD_INTERCEPTORS, FIELD_TYPE_INTERCEPTORS);
        proxyConstructorGenerator.push(i);
        proxyConstructorGenerator.loadArg(this.beanContextArgumentIndex);
        proxyConstructorGenerator.loadThis();
        proxyConstructorGenerator.getField(this.proxyType, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS);
        proxyConstructorGenerator.push(i);
        proxyConstructorGenerator.visitInsn(50);
        proxyConstructorGenerator.loadArg(this.interceptorArgumentIndex);
        if (this.isIntroduction) {
            proxyConstructorGenerator.invokeStatic(TYPE_INTERCEPTOR_CHAIN, Method.getMethod((java.lang.reflect.Method)RESOLVE_INTRODUCTION_INTERCEPTORS_METHOD));
        } else {
            proxyConstructorGenerator.invokeStatic(TYPE_INTERCEPTOR_CHAIN, Method.getMethod((java.lang.reflect.Method)RESOLVE_AROUND_INTERCEPTORS_METHOD));
        }
        proxyConstructorGenerator.visitInsn(83);
    }

    private class MethodRef {
        protected final String name;
        protected final List<Object> argumentTypes;
        protected final io.micronaut.asm.Type returnType;

        public MethodRef(String name, List<Object> argumentTypes, io.micronaut.asm.Type returnType) {
            this.name = name;
            this.argumentTypes = argumentTypes;
            this.returnType = returnType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodRef methodRef = (MethodRef)o;
            return Objects.equals(this.name, methodRef.name) && Objects.equals(this.argumentTypes, methodRef.argumentTypes) && Objects.equals(this.returnType, methodRef.returnType);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.argumentTypes, this.returnType);
        }
    }
}

