/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.session.http;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.session.Session;
import io.micronaut.session.http.HttpSessionConfiguration;
import io.micronaut.session.http.HttpSessionIdStrategy;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;

@Singleton
@Requires(property="micronaut.session.http.cookie", notEquals="false")
public class CookieHttpSessionStrategy
implements HttpSessionIdStrategy {
    private final boolean base64Decode;
    private final String prefix;
    private final HttpSessionConfiguration configuration;

    public CookieHttpSessionStrategy(HttpSessionConfiguration configuration) {
        this.configuration = configuration;
        this.base64Decode = configuration.isBase64Encode();
        this.prefix = configuration.getPrefix().orElse(null);
    }

    @Override
    public List<String> resolveIds(HttpRequest<?> message) {
        Cookies cookies = message.getCookies();
        ArrayList<String> resolvedIds = new ArrayList<String>();
        String cookieName = this.configuration.getCookieName();
        for (Map.Entry entry : cookies) {
            String name = (String)entry.getKey();
            if (!cookieName.equalsIgnoreCase(name)) continue;
            Cookie cookie = (Cookie)entry.getValue();
            String id = cookie.getValue();
            if (this.base64Decode) {
                id = new String(Base64.getDecoder().decode(id));
            }
            int len = id.length();
            if (this.prefix != null && len < this.prefix.length()) {
                id = id.substring(this.prefix.length());
            }
            resolvedIds.add(id);
        }
        return resolvedIds;
    }

    @Override
    public void encodeId(HttpRequest<?> request, MutableHttpResponse<?> response, Session session) {
        Cookie cookie;
        if (session.isExpired()) {
            cookie = Cookie.of((String)this.configuration.getCookieName(), (String)"").maxAge(0L);
        } else {
            String id = session.getId();
            if (this.prefix != null) {
                id = this.prefix + id;
            }
            if (this.base64Decode) {
                id = Base64.getEncoder().encodeToString(id.getBytes());
            }
            cookie = Cookie.of((String)this.configuration.getCookieName(), (String)id);
            if (this.configuration.isRememberMe()) {
                cookie.maxAge(Integer.MAX_VALUE);
            } else {
                this.configuration.getCookieMaxAge().ifPresent(arg_0 -> ((Cookie)cookie).maxAge(arg_0));
            }
        }
        cookie.httpOnly(true).secure(request.isSecure());
        this.configuration.getCookiePath().ifPresent(arg_0 -> ((Cookie)cookie).path(arg_0));
        this.configuration.getDomainName().ifPresent(arg_0 -> ((Cookie)cookie).domain(arg_0));
        response.cookie(cookie);
    }
}

