/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.json.tree;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.json.tree.JsonArray;
import io.micronaut.json.tree.JsonBoolean;
import io.micronaut.json.tree.JsonNull;
import io.micronaut.json.tree.JsonNumber;
import io.micronaut.json.tree.JsonObject;
import io.micronaut.json.tree.JsonString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class JsonNode {
    JsonNode() {
    }

    public static @NonNull JsonNode from(Object value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        if (value instanceof String) {
            String s = (String)value;
            return JsonNode.createStringNode(s);
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            return JsonNode.createNumberNodeImpl(n);
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return JsonNode.createBooleanNode(b);
        }
        if (value instanceof List) {
            List list = (List)value;
            return JsonNode.createArrayNode(list.stream().map(JsonNode::from).toList());
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            LinkedHashMap newMap = CollectionUtils.newLinkedHashMap((int)map.size());
            for (Map.Entry e : map.entrySet()) {
                Object key = e.getKey();
                if (key instanceof String) {
                    String s = (String)key;
                    newMap.put(s, JsonNode.from(e.getValue()));
                    continue;
                }
                throw new IllegalStateException("Expected a String as a key in the map!");
            }
            return JsonNode.createObjectNode(newMap);
        }
        throw new IllegalStateException("Unrecognized value: " + String.valueOf(value));
    }

    public static @NonNull JsonNode nullNode() {
        return JsonNull.INSTANCE;
    }

    public static @NonNull JsonNode createArrayNode(@NonNull List<JsonNode> nodes) {
        Objects.requireNonNull(nodes, "nodes");
        return new JsonArray(nodes);
    }

    public static @NonNull JsonNode createObjectNode(Map<String, JsonNode> nodes) {
        Objects.requireNonNull(nodes, "nodes");
        return new JsonObject(nodes);
    }

    public static @NonNull JsonNode createBooleanNode(boolean value) {
        return JsonBoolean.valueOf(value);
    }

    public static @NonNull JsonNode createStringNode(@NonNull String value) {
        Objects.requireNonNull(value, "value");
        return new JsonString(value);
    }

    @Internal
    public static JsonNode createNumberNodeImpl(Number value) {
        Objects.requireNonNull(value, "value");
        return new JsonNumber(value);
    }

    public static @NonNull JsonNode createNumberNode(int value) {
        return JsonNode.createNumberNodeImpl(value);
    }

    public static @NonNull JsonNode createNumberNode(long value) {
        return JsonNode.createNumberNodeImpl(value);
    }

    public static @NonNull JsonNode createNumberNode(@NonNull BigDecimal value) {
        return JsonNode.createNumberNodeImpl(value);
    }

    public static @NonNull JsonNode createNumberNode(float value) {
        return JsonNode.createNumberNodeImpl(Float.valueOf(value));
    }

    public static @NonNull JsonNode createNumberNode(double value) {
        return JsonNode.createNumberNodeImpl(value);
    }

    public static @NonNull JsonNode createNumberNode(@NonNull BigInteger value) {
        return JsonNode.createNumberNodeImpl(value);
    }

    public abstract @Nullable Object getValue();

    public boolean isNumber() {
        return false;
    }

    public @NonNull Number getNumberValue() {
        throw new IllegalStateException("Not a number");
    }

    public final int getIntValue() {
        return this.getNumberValue().intValue();
    }

    public final long getLongValue() {
        return this.getNumberValue().longValue();
    }

    public final float getFloatValue() {
        return this.getNumberValue().floatValue();
    }

    public final double getDoubleValue() {
        return this.getNumberValue().doubleValue();
    }

    public final @NonNull BigInteger getBigIntegerValue() {
        Number numberValue = this.getNumberValue();
        if (numberValue instanceof BigInteger) {
            BigInteger integer = (BigInteger)numberValue;
            return integer;
        }
        if (numberValue instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)numberValue;
            return decimal.toBigInteger();
        }
        return BigInteger.valueOf(numberValue.longValue());
    }

    public final @NonNull BigDecimal getBigDecimalValue() {
        Number numberValue = this.getNumberValue();
        if (numberValue instanceof BigInteger) {
            BigInteger integer = (BigInteger)numberValue;
            return new BigDecimal(integer);
        }
        if (numberValue instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)numberValue;
            return decimal;
        }
        if (numberValue instanceof Long) {
            return BigDecimal.valueOf(numberValue.longValue());
        }
        return BigDecimal.valueOf(numberValue.doubleValue());
    }

    public boolean isString() {
        return false;
    }

    public @NonNull String getStringValue() {
        throw new IllegalStateException("Not a string");
    }

    public @NonNull String coerceStringValue() {
        throw new IllegalStateException("Not a scalar value");
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean getBooleanValue() {
        throw new IllegalStateException("Not a boolean");
    }

    public boolean isNull() {
        return false;
    }

    public abstract int size();

    public abstract @NonNull Iterable<JsonNode> values();

    public abstract @NonNull Iterable<Map.Entry<String, JsonNode>> entries();

    public boolean isValueNode() {
        return false;
    }

    public boolean isContainerNode() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public abstract @Nullable JsonNode get(@NonNull String var1);

    public abstract @Nullable JsonNode get(int var1);
}

