/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.json.convert;

import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.BeanPropertyBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.JsonSyntaxException;
import io.micronaut.json.convert.JsonNodeConvertibleValues;
import io.micronaut.json.convert.LazyJsonNode;
import io.micronaut.json.tree.JsonNode;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.NonNull;

@Prototype
public final class JsonConverterRegistrar
implements TypeConverterRegistrar {
    private final BeanProvider<JsonMapper> objectCodecProvider;
    private JsonMapper objectCodec;
    private final ConversionService conversionService;
    private final BeanProvider<BeanPropertyBinder> beanPropertyBinder;

    @Inject
    public JsonConverterRegistrar(BeanProvider<JsonMapper> objectCodec, ConversionService conversionService, BeanProvider<BeanPropertyBinder> beanPropertyBinder) {
        this.objectCodecProvider = objectCodec;
        this.conversionService = conversionService;
        this.beanPropertyBinder = beanPropertyBinder;
    }

    private JsonMapper objectCodec() {
        JsonMapper objectCodec = this.objectCodec;
        if (objectCodec == null) {
            this.objectCodec = objectCodec = (JsonMapper)this.objectCodecProvider.get();
        }
        return objectCodec;
    }

    public void register(MutableConversionService conversionService) {
        conversionService.addConverter(JsonNode.class, ConvertibleValues.class, this.objectNodeToConvertibleValuesConverter());
        conversionService.addConverter(LazyJsonNode.class, ConvertibleValues.class, this.unparsedNodeToConvertibleValuesConverter());
        conversionService.addConverter(JsonNode.class, Object.class, this.jsonNodeToObjectConverter());
        conversionService.addConverter(JsonNode.class, String.class, this.jsonNodeToStringConverter());
        conversionService.addConverter(LazyJsonNode.class, Object.class, this.unparsedJsonNodeToObjectConverter());
        conversionService.addConverter(LazyJsonNode.class, String.class, this.unparsedJsonNodeToStringConverter());
        conversionService.addConverter(JsonNode.class, Object[].class, this.jsonNodeToObjectConverter());
        conversionService.addConverter(LazyJsonNode.class, Object[].class, this.unparsedJsonNodeToObjectConverter());
        conversionService.addConverter(Map.class, Object.class, this.mapToObjectConverter());
        conversionService.addConverter(Object.class, JsonNode.class, this.objectToJsonNodeConverter());
    }

    private TypeConverter<JsonNode, ConvertibleValues> objectNodeToConvertibleValuesConverter() {
        return (object, targetType, context) -> {
            if (object.isObject()) {
                return Optional.of(new JsonNodeConvertibleValues((JsonNode)object, this.conversionService));
            }
            return Optional.empty();
        };
    }

    private TypeConverter<LazyJsonNode, ConvertibleValues> unparsedNodeToConvertibleValuesConverter() {
        return (node, targetType, context) -> {
            try {
                if (!node.isObject()) {
                    return Optional.empty();
                }
            }
            catch (JsonSyntaxException e) {
                node.tryRelease();
                context.reject((Exception)e);
                return Optional.empty();
            }
            try {
                Optional e = Optional.of(new JsonNodeConvertibleValues(node.toJsonNode(this.objectCodec()), this.conversionService));
                return e;
            }
            catch (IOException e) {
                context.reject((Exception)e);
                Optional optional = Optional.empty();
                return optional;
            }
            finally {
                node.tryRelease();
            }
        };
    }

    private TypeConverter<Map, Object> mapToObjectConverter() {
        return (map, targetType, context) -> {
            ArgumentConversionContext argumentConversionContext;
            ArgumentConversionContext conversionContext = context instanceof ArgumentConversionContext ? (argumentConversionContext = (ArgumentConversionContext)context) : ConversionContext.of((Class)targetType);
            ArgumentBinder binder = (ArgumentBinder)this.beanPropertyBinder.get();
            ArgumentBinder.BindingResult result = binder.bind(conversionContext, this.correctKeys((Map<?, ?>)map));
            return result.getValue();
        };
    }

    private Map<?, ?> correctKeys(Map<?, ?> map) {
        LinkedHashMap mapWithExtraProps = CollectionUtils.newLinkedHashMap((int)map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = this.correctKeys(entry.getValue());
            mapWithExtraProps.put(NameUtils.decapitalize((String)NameUtils.dehyphenate((String)key.toString())), value);
        }
        return mapWithExtraProps;
    }

    private List<?> correctKeys(List<?> list) {
        ArrayList<Object> newList = new ArrayList<Object>(list.size());
        for (Object o : list) {
            newList.add(this.correctKeys(o));
        }
        return newList;
    }

    private Object correctKeys(Object o) {
        if (o instanceof List) {
            List list = (List)o;
            return this.correctKeys(list);
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            return this.correctKeys(map);
        }
        return o;
    }

    private TypeConverter<Object, JsonNode> objectToJsonNodeConverter() {
        return (object, targetType, context) -> {
            try {
                return Optional.of(this.objectCodec().writeValueToTree(object));
            }
            catch (IOException | IllegalArgumentException e) {
                context.reject(e);
                return Optional.empty();
            }
        };
    }

    private static <K> @NonNull Argument<K> argument(Class<K> targetType, ConversionContext context) {
        ArgumentConversionContext argumentConversionContext;
        Argument argument;
        if (context instanceof ArgumentConversionContext && targetType == (argument = (argumentConversionContext = (ArgumentConversionContext)context).getArgument()).getType()) {
            return argument;
        }
        return Argument.of(targetType);
    }

    private TypeConverter<JsonNode, Object> jsonNodeToObjectConverter() {
        return (node, targetType, context) -> {
            try {
                if (CharSequence.class.isAssignableFrom(targetType) && node.isObject()) {
                    return Optional.of(new String(this.objectCodec().writeValueAsBytes(node), StandardCharsets.UTF_8));
                }
                return Optional.ofNullable(this.objectCodec().readValueFromTree((JsonNode)node, JsonConverterRegistrar.argument(targetType, context)));
            }
            catch (IOException e) {
                context.reject((Exception)e);
                return Optional.empty();
            }
        };
    }

    private TypeConverter<JsonNode, String> jsonNodeToStringConverter() {
        return (node, targetType, context) -> {
            try {
                if (node.isString()) {
                    return Optional.of(node.getStringValue());
                }
                if (node.isObject()) {
                    return Optional.of(new String(this.objectCodec().writeValueAsBytes(node), StandardCharsets.UTF_8));
                }
                return Optional.ofNullable((String)this.objectCodec().readValueFromTree((JsonNode)node, JsonConverterRegistrar.argument(targetType, context)));
            }
            catch (IOException e) {
                context.reject((Exception)e);
                return Optional.empty();
            }
        };
    }

    private TypeConverter<LazyJsonNode, Object> unparsedJsonNodeToObjectConverter() {
        return (node, targetType, context) -> {
            try {
                JsonMapper mapper = this.objectCodec();
                if (CharSequence.class.isAssignableFrom(targetType) && node.isObject()) {
                    byte[] sanitized = mapper.writeValueAsBytes(node.toJsonNode(mapper));
                    Optional<String> optional = Optional.of(new String(sanitized, StandardCharsets.UTF_8));
                    return optional;
                }
                Optional optional = Optional.ofNullable(node.parse(mapper, JsonConverterRegistrar.argument(targetType, context)));
                return optional;
            }
            catch (IOException e) {
                context.reject((Exception)e);
                Optional optional = Optional.empty();
                return optional;
            }
            finally {
                node.tryRelease();
            }
        };
    }

    private TypeConverter<LazyJsonNode, String> unparsedJsonNodeToStringConverter() {
        return (node, targetType, context) -> {
            try {
                JsonMapper mapper = this.objectCodec();
                if (node.isObject()) {
                    byte[] sanitized = mapper.writeValueAsBytes(node.toJsonNode(mapper));
                    Optional<String> optional = Optional.of(new String(sanitized, StandardCharsets.UTF_8));
                    return optional;
                }
                Optional<String> optional = Optional.ofNullable((String)node.parse(mapper, JsonConverterRegistrar.argument(targetType, context)));
                return optional;
            }
            catch (IOException e) {
                context.reject((Exception)e);
                Optional optional = Optional.empty();
                return optional;
            }
            finally {
                node.tryRelease();
            }
        };
    }
}

