/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.json.codec;

import io.micronaut.context.BeanProvider;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecConfiguration;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.json.JsonFeatures;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.runtime.ApplicationConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Deprecated(since="4.7")
public abstract class MapperMediaTypeCodec
implements MediaTypeCodec {
    public static final String REGULAR_JSON_MEDIA_TYPE_CODEC_NAME = "json";
    protected final ApplicationConfiguration applicationConfiguration;
    protected final List<MediaType> additionalTypes;
    protected final CodecConfiguration codecConfiguration;
    protected final MediaType mediaType;
    private final BeanProvider<JsonMapper> mapperProvider;
    private volatile JsonMapper mapper;

    public MapperMediaTypeCodec(BeanProvider<JsonMapper> mapperProvider, ApplicationConfiguration applicationConfiguration, CodecConfiguration codecConfiguration, MediaType mediaType) {
        this(mapperProvider, applicationConfiguration, codecConfiguration, mediaType, null);
    }

    public MapperMediaTypeCodec(BeanProvider<JsonMapper> mapperProvider, ApplicationConfiguration applicationConfiguration, CodecConfiguration codecConfiguration, MediaType mediaType, @Nullable List<MediaType> additionalTypes) {
        this.mapperProvider = mapperProvider;
        this.applicationConfiguration = applicationConfiguration;
        this.codecConfiguration = codecConfiguration;
        this.mediaType = mediaType;
        HashSet<MediaType> mediaTypes = new HashSet<MediaType>();
        if (codecConfiguration != null) {
            mediaTypes.addAll(codecConfiguration.getAdditionalTypes());
        }
        if (additionalTypes != null) {
            mediaTypes.addAll(additionalTypes);
        }
        this.additionalTypes = new ArrayList<MediaType>(mediaTypes);
    }

    public MapperMediaTypeCodec(JsonMapper mapper, ApplicationConfiguration applicationConfiguration, CodecConfiguration codecConfiguration, MediaType mediaType) {
        this((BeanProvider<JsonMapper>)((BeanProvider)() -> mapper), applicationConfiguration, codecConfiguration, mediaType);
        ArgumentUtils.requireNonNull((String)"objectMapper", (Object)mapper);
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonMapper getJsonMapper() {
        JsonMapper mapper = this.mapper;
        if (mapper == null) {
            MapperMediaTypeCodec mapperMediaTypeCodec = this;
            synchronized (mapperMediaTypeCodec) {
                mapper = this.mapper;
                if (mapper == null) {
                    this.mapper = mapper = (JsonMapper)this.mapperProvider.get();
                }
            }
        }
        return mapper;
    }

    public MapperMediaTypeCodec cloneWithFeatures(JsonFeatures features) {
        return this.cloneWithMapper(this.getJsonMapper().cloneWithFeatures(features));
    }

    public final MapperMediaTypeCodec cloneWithViewClass(Class<?> viewClass) {
        return this.cloneWithMapper(this.getJsonMapper().cloneWithViewClass(viewClass));
    }

    protected abstract MapperMediaTypeCodec cloneWithMapper(JsonMapper var1);

    public Collection<MediaType> getMediaTypes() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(this.mediaType);
        mediaTypes.addAll(this.additionalTypes);
        return mediaTypes;
    }

    public boolean supportsType(Class<?> type) {
        return !CharSequence.class.isAssignableFrom(type);
    }

    public <T> T decode(Argument<T> type, InputStream inputStream) throws CodecException {
        try {
            return this.getJsonMapper().readValue(inputStream, type);
        }
        catch (IOException e) {
            throw new CodecException("Error decoding JSON stream for type [" + type.getName() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> T decode(Argument<T> type, JsonNode node) throws CodecException {
        try {
            JsonMapper om = this.getJsonMapper();
            return om.readValueFromTree(node, type);
        }
        catch (IOException e) {
            throw new CodecException("Error decoding JSON stream for type [" + type.getName() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> T decode(Argument<T> type, ByteBuffer<?> buffer) throws CodecException {
        try {
            if (CharSequence.class.isAssignableFrom(type.getType())) {
                return (T)buffer.toString(this.applicationConfiguration.getDefaultCharset());
            }
            return this.getJsonMapper().readValue(buffer, type);
        }
        catch (IOException e) {
            throw new CodecException("Error decoding stream for type [" + String.valueOf(type.getType()) + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> T decode(Argument<T> type, byte[] bytes) throws CodecException {
        try {
            if (CharSequence.class.isAssignableFrom(type.getType())) {
                return (T)new String(bytes, this.applicationConfiguration.getDefaultCharset());
            }
            return this.getJsonMapper().readValue(bytes, type);
        }
        catch (IOException e) {
            throw new CodecException("Error decoding stream for type [" + String.valueOf(type.getType()) + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> T decode(Argument<T> type, String data) throws CodecException {
        try {
            return this.getJsonMapper().readValue(data, type);
        }
        catch (IOException e) {
            throw new CodecException("Error decoding JSON stream for type [" + type.getName() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> void encode(T object, OutputStream outputStream) throws CodecException {
        try {
            this.getJsonMapper().writeValue(outputStream, object);
        }
        catch (IOException e) {
            throw new CodecException("Error encoding object [" + String.valueOf(object) + "] to JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> void encode(@NonNull Argument<T> type, @NonNull T object, @NonNull OutputStream outputStream) throws CodecException {
        try {
            this.getJsonMapper().writeValue(outputStream, type, object);
        }
        catch (IOException e) {
            throw new CodecException("Error encoding object [" + String.valueOf(object) + "] to JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> byte[] encode(T object) throws CodecException {
        try {
            if (object instanceof byte[]) {
                byte[] bytes = (byte[])object;
                return bytes;
            }
            return this.getJsonMapper().writeValueAsBytes(object);
        }
        catch (IOException e) {
            throw new CodecException("Error encoding object [" + String.valueOf(object) + "] to JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> byte[] encode(@NonNull Argument<T> type, T object) throws CodecException {
        try {
            if (object instanceof byte[]) {
                byte[] bytes = (byte[])object;
                return bytes;
            }
            return this.getJsonMapper().writeValueAsBytes(type, object);
        }
        catch (IOException e) {
            throw new CodecException("Error encoding object [" + String.valueOf(object) + "] to JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T, B> ByteBuffer<B> encode(T object, ByteBufferFactory<?, B> allocator) throws CodecException {
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return allocator.copiedBuffer(bytes);
        }
        ByteBuffer buffer = allocator.buffer();
        try {
            OutputStream outputStream = buffer.toOutputStream();
            this.encode(object, outputStream);
        }
        catch (Throwable t) {
            if (buffer instanceof ReferenceCounted) {
                ReferenceCounted counted = (ReferenceCounted)buffer;
                counted.release();
            }
            throw t;
        }
        return buffer;
    }

    public <T, B> @NonNull ByteBuffer<B> encode(@NonNull Argument<T> type, T object, @NonNull ByteBufferFactory<?, B> allocator) throws CodecException {
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return allocator.copiedBuffer(bytes);
        }
        ByteBuffer buffer = allocator.buffer();
        try {
            OutputStream outputStream = buffer.toOutputStream();
            this.encode(type, object, outputStream);
            return buffer;
        }
        catch (Throwable t) {
            if (buffer instanceof ReferenceCounted) {
                ReferenceCounted counted = (ReferenceCounted)buffer;
                counted.release();
            }
            throw t;
        }
    }
}

