/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.json.codec;

import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecConfiguration;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.codec.JsonMediaTypeCodec;
import io.micronaut.json.codec.MapperMediaTypeCodec;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;

@Singleton
@BootstrapContextCompatible
@Deprecated(forRemoval=true, since="4.7")
public class JsonStreamMediaTypeCodec
extends JsonMediaTypeCodec {
    public static final String CONFIGURATION_QUALIFIER = "json-stream";
    private final List<MediaType> streamAdditionalTypes;

    public JsonStreamMediaTypeCodec(JsonMapper jsonMapper, ApplicationConfiguration applicationConfiguration, @Named(value="json-stream") @Nullable CodecConfiguration codecConfiguration) {
        super(jsonMapper, applicationConfiguration, null);
        this.streamAdditionalTypes = codecConfiguration != null ? codecConfiguration.getAdditionalTypes() : Collections.emptyList();
    }

    @Inject
    public JsonStreamMediaTypeCodec(BeanProvider<JsonMapper> jsonCodec, ApplicationConfiguration applicationConfiguration, @Named(value="json-stream") @Nullable CodecConfiguration codecConfiguration) {
        super(jsonCodec, applicationConfiguration, null);
        this.streamAdditionalTypes = codecConfiguration != null ? codecConfiguration.getAdditionalTypes() : Collections.emptyList();
    }

    @Override
    public Collection<MediaType> getMediaTypes() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(MediaType.APPLICATION_JSON_STREAM_TYPE);
        mediaTypes.addAll(this.streamAdditionalTypes);
        return mediaTypes;
    }

    @Override
    protected MapperMediaTypeCodec cloneWithMapper(JsonMapper mapper) {
        return new JsonStreamMediaTypeCodec(mapper, this.applicationConfiguration, this.codecConfiguration);
    }
}

