/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AbstractInjectAnnotationProcessor;
import io.micronaut.annotation.processing.JavaElementAnnotationMetadataFactory;
import io.micronaut.annotation.processing.LoadedVisitor;
import io.micronaut.annotation.processing.PostponeToNextRoundException;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaElementFactory;
import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.visitor.VisitorUtils;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.version.VersionUtils;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.EnumConstantElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.ElementPostponedToNextRoundException;
import io.micronaut.inject.visitor.TypeElementQuery;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.AbstractBeanDefinitionBuilder;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@SupportedOptions(value={"micronaut.processing.incremental", "micronaut.processing.annotations", "micronaut.processing.project.dir", "micronaut.processing.group", "micronaut.processing.module"})
public class TypeElementVisitorProcessor
extends AbstractInjectAnnotationProcessor {
    private static final Set<String> VISITOR_WARNINGS;
    private static final Set<String> SUPPORTED_ANNOTATION_NAMES;
    private List<LoadedVisitor> loadedVisitors;
    private Collection<? extends TypeElementVisitor<?, ?>> typeElementVisitors;

    static Set<String> getVisitedAnnotationNames() {
        return SUPPORTED_ANNOTATION_NAMES;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Collection<TypeElementVisitor<?, ?>> typeElementVisitors = this.findTypeElementVisitors();
        processingEnv.getOptions().entrySet().stream().filter(entry -> entry.getKey() != null && ((String)entry.getKey()).startsWith("micronaut")).forEach(entry -> System.setProperty((String)entry.getKey(), entry.getValue() == null ? "" : (String)entry.getValue()));
        this.loadedVisitors = new ArrayList<LoadedVisitor>(typeElementVisitors.size());
        for (TypeElementVisitor<?, ?> visitor : typeElementVisitors) {
            TypeElementVisitor.VisitorKind visitorKind = visitor.getVisitorKind();
            TypeElementVisitor.VisitorKind incrementalProcessorKind = this.getIncrementalProcessorKind();
            if (incrementalProcessorKind != visitorKind) continue;
            try {
                this.loadedVisitors.add(new LoadedVisitor(visitor, processingEnv));
            }
            catch (NoClassDefFoundError | TypeNotPresentException throwable) {}
        }
        OrderUtil.reverseSort(this.loadedVisitors);
        for (LoadedVisitor loadedVisitor : this.loadedVisitors) {
            try {
                loadedVisitor.getVisitor().start((VisitorContext)this.javaVisitorContext);
            }
            catch (Throwable e) {
                this.error("Error initializing type visitor [%s]: %s", loadedVisitor.getVisitor(), e.getMessage());
            }
        }
    }

    protected boolean hasVisitors() {
        for (TypeElementVisitor<?, ?> typeElementVisitor : this.findTypeElementVisitors()) {
            if (typeElementVisitor.getVisitorKind() != this.getVisitorKind()) continue;
            return true;
        }
        return false;
    }

    protected List<LoadedVisitor> getLoadedVisitors() {
        return this.loadedVisitors;
    }

    protected TypeElementVisitor.VisitorKind getIncrementalProcessorKind() {
        String type = this.getIncrementalProcessorType();
        if (type.equals("org.gradle.annotation.processing.aggregating")) {
            return TypeElementVisitor.VisitorKind.AGGREGATING;
        }
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        if (this.loadedVisitors.isEmpty()) {
            return Collections.emptySet();
        }
        return super.getSupportedAnnotationTypes();
    }

    @Override
    public Set<String> getSupportedOptions() {
        Stream baseOption = super.getSupportedOptions().stream();
        Collection<TypeElementVisitor<?, ?>> typeElementVisitors = this.findTypeElementVisitors();
        Stream visitorsOptions = typeElementVisitors.stream().map(TypeElementVisitor::getSupportedOptions).flatMap(Collection::stream);
        Stream visitorsAnnotationsOptions = typeElementVisitors.stream().filter(tev -> tev.getClass().isAnnotationPresent(SupportedOptions.class)).map(TypeElementVisitor::getClass).map(cls -> cls.getAnnotation(SupportedOptions.class)).flatMap(supportedOptions -> Arrays.stream(supportedOptions.value()));
        return Stream.of(baseOption, visitorsAnnotationsOptions, visitorsOptions).flatMap(BaseStream::sequential).collect(Collectors.toSet());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        List<AbstractBeanDefinitionBuilder> beanDefinitionBuilders;
        if (!this.loadedVisitors.isEmpty() && !this.processingGeneratedAnnotation(annotations)) {
            TypeElement groovyObjectTypeElement = this.elementUtils.getTypeElement("groovy.lang.GroovyObject");
            TypeMirror groovyObjectType = groovyObjectTypeElement != null ? groovyObjectTypeElement.asType() : null;
            Predicate<TypeElement> notGroovyObject = typeElement -> groovyObjectType == null || !this.typeUtils.isAssignable(typeElement.asType(), groovyObjectType);
            LinkedHashSet elements = new LinkedHashSet();
            for (TypeElement typeElement2 : annotations) {
                this.modelUtils.resolveTypeElements(roundEnv.getElementsAnnotatedWith(typeElement2)).filter(notGroovyObject).forEach(elements::add);
            }
            this.modelUtils.resolveTypeElements(roundEnv.getRootElements()).filter(notGroovyObject).forEach(elements::add);
            for (TypeElement typeElement3 : this.postponedTypes.values()) {
                if (!(typeElement3 instanceof Element)) continue;
                Element element = typeElement3;
                AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata cachedAnnotationMetadata = this.javaVisitorContext.getAnnotationMetadataBuilder().lookupOrBuildForType(element);
                if (cachedAnnotationMetadata.wasCleared()) continue;
                AbstractAnnotationMetadataBuilder.clearMutated((Object)typeElement3);
                cachedAnnotationMetadata = this.javaVisitorContext.getAnnotationMetadataBuilder().lookupOrBuildForType(element);
                this.javaVisitorContext.getNativeElementsHelper().cleanupForClass(typeElement3);
                cachedAnnotationMetadata.markCleared();
            }
            this.postponedTypes.keySet().stream().map(this.elementUtils::getTypeElement).filter(Objects::nonNull).forEach(elements::add);
            this.postponedTypes.clear();
            if (!elements.isEmpty()) {
                JavaElementFactory elementFactory = this.javaVisitorContext.getElementFactory();
                JavaElementAnnotationMetadataFactory javaElementAnnotationMetadataFactory = this.javaVisitorContext.getElementAnnotationMetadataFactory();
                List javaClassElements = elements.stream().map(typeElement -> elementFactory.newSourceClassElement((TypeElement)typeElement, (ElementAnnotationMetadataFactory)elementAnnotationMetadataFactory)).collect(Collectors.toCollection(() -> new ArrayList(elements.size())));
                ArrayList extraClasses = new ArrayList();
                for (JavaClassElement javaClassElement : new ArrayList(javaClassElements)) {
                    try {
                        extraClasses.addAll(VisitorUtils.collectImportedElements((ClassElement)javaClassElement, (VisitorContext)this.javaVisitorContext));
                        javaClassElements.addAll(extraClasses);
                    }
                    catch (PostponeToNextRoundException e) {
                        javaClassElements.remove((Object)javaClassElement);
                        this.postponeElement(javaClassElement, e.getNativeErrorElement(), e);
                    }
                    catch (ElementPostponedToNextRoundException e) {
                        javaClassElements.remove((Object)javaClassElement);
                        Element element = PostponeToNextRoundException.resolvedFailedElement(e.getOriginatingElement());
                        this.postponeElement(javaClassElement, element, e);
                    }
                }
                for (LoadedVisitor loadedVisitor : this.loadedVisitors) {
                    for (JavaClassElement javaClassElement : javaClassElements) {
                        try {
                            if (!loadedVisitor.matchesClass((AnnotationMetadata)javaClassElement)) continue;
                            this.visitClass(loadedVisitor, javaClassElement);
                        }
                        catch (ProcessingException e) {
                            JavaNativeElement originatingElement = (JavaNativeElement)e.getOriginatingElement();
                            if (originatingElement == null) {
                                originatingElement = javaClassElement.getNativeType();
                            }
                            this.error(originatingElement.element(), e.getMessage(), new Object[0]);
                        }
                        catch (PostponeToNextRoundException e) {
                            this.postponeElement(javaClassElement, e.getNativeErrorElement(), e);
                        }
                        catch (ElementPostponedToNextRoundException e) {
                            Element element = PostponeToNextRoundException.resolvedFailedElement(e.getOriginatingElement());
                            this.postponeElement(javaClassElement, element, e);
                        }
                    }
                }
            }
            for (LoadedVisitor loadedVisitor : this.loadedVisitors) {
                try {
                    loadedVisitor.getVisitor().finish((VisitorContext)this.javaVisitorContext);
                }
                catch (Throwable e) {
                    StringWriter stackTraceWriter = new StringWriter();
                    e.printStackTrace(new PrintWriter(stackTraceWriter));
                    this.error("Error finalizing type visitor [%s]: %s\n%s", loadedVisitor.getVisitor(), e.getMessage(), stackTraceWriter);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(beanDefinitionBuilders = this.javaVisitorContext.getBeanElementBuilders())) {
            try {
                AbstractBeanDefinitionBuilder.writeBeanDefinitionBuilders((ClassWriterOutputVisitor)this.classWriterOutputVisitor, beanDefinitionBuilders);
            }
            catch (IOException e) {
                String message = e.getMessage();
                this.error("Unexpected error: %s", message != null ? message : e.getClass().getSimpleName());
            }
        }
        if (roundEnv.processingOver()) {
            this.javaVisitorContext.finish();
        }
        return false;
    }

    private <T extends Throwable> void postponeElement(JavaClassElement javaClassElement, Element originalElement, T e) throws T {
        if (originalElement == null) {
            throw e;
        }
        this.postponedTypes.put(javaClassElement.getCanonicalName(), originalElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitClass(LoadedVisitor visitor, JavaClassElement classElement) {
        TypeElementQuery query = visitor.getVisitor().query();
        try {
            this.javaVisitorContext.setVisitUnresolvedInterfaces(query.visitsUnresolvedInterfaces());
            visitor.getVisitor().visitClass((ClassElement)classElement, (VisitorContext)this.javaVisitorContext);
            if (query.includesConstructors()) {
                for (ConstructorElement constructorElement : classElement.getSourceEnclosedElements(ElementQuery.CONSTRUCTORS)) {
                    this.visitConstructor(visitor, constructorElement);
                }
            }
            boolean includesFields = query.includesFields() || query.includesEnumConstants();
            boolean includesMethods = query.includesMethods();
            List<Object> elements = includesMethods && includesFields ? classElement.getSourceEnclosedElements(ElementQuery.ALL_FIELD_AND_METHODS) : (includesMethods ? classElement.getSourceEnclosedElements(ElementQuery.ALL_METHODS) : (includesFields ? classElement.getSourceEnclosedElements(ElementQuery.ALL_FIELDS) : List.of()));
            for (MemberElement memberElement : elements) {
                if (memberElement instanceof EnumConstantElement) {
                    EnumConstantElement enumConstantElement = (EnumConstantElement)memberElement;
                    if (!query.includesEnumConstants()) continue;
                    this.visitEnumConstant(visitor, enumConstantElement);
                    continue;
                }
                if (memberElement instanceof FieldElement) {
                    FieldElement fieldElement = (FieldElement)memberElement;
                    if (!query.includesFields()) continue;
                    this.visitField(visitor, fieldElement);
                    continue;
                }
                if (memberElement instanceof MethodElement) {
                    MethodElement methodElement = (MethodElement)memberElement;
                    if (!includesMethods) continue;
                    this.visitMethod(visitor, methodElement);
                    continue;
                }
                throw new IllegalStateException("Unknown element: " + String.valueOf(memberElement));
            }
        }
        finally {
            this.javaVisitorContext.setVisitUnresolvedInterfaces(false);
        }
    }

    private void visitConstructor(LoadedVisitor visitor, ConstructorElement constructorElement) {
        if (visitor.matchesElement((AnnotationMetadata)constructorElement)) {
            visitor.getVisitor().visitConstructor(constructorElement, (VisitorContext)this.javaVisitorContext);
        }
    }

    private void visitMethod(LoadedVisitor visitor, MethodElement methodElement) {
        if (visitor.matchesElement((AnnotationMetadata)methodElement)) {
            visitor.getVisitor().visitMethod(methodElement, (VisitorContext)this.javaVisitorContext);
        }
    }

    private void visitEnumConstant(LoadedVisitor visitor, EnumConstantElement enumConstantElement) {
        if (visitor.matchesElement((AnnotationMetadata)enumConstantElement)) {
            visitor.getVisitor().visitEnumConstant(enumConstantElement, (VisitorContext)this.javaVisitorContext);
        }
    }

    private void visitField(LoadedVisitor visitor, FieldElement fieldElement) {
        if (visitor.matchesElement((AnnotationMetadata)fieldElement)) {
            visitor.getVisitor().visitField(fieldElement, (VisitorContext)this.javaVisitorContext);
        }
    }

    @NonNull
    protected synchronized Collection<? extends TypeElementVisitor<?, ?>> findTypeElementVisitors() {
        if (this.typeElementVisitors == null) {
            for (String visitorWarning : VISITOR_WARNINGS) {
                this.warning(visitorWarning, new Object[0]);
            }
            this.typeElementVisitors = TypeElementVisitorProcessor.findCoreTypeElementVisitors(null);
        }
        return this.typeElementVisitors;
    }

    @NonNull
    private static Collection<? extends TypeElementVisitor<?, ?>> findCoreTypeElementVisitors(@Nullable Set<String> warnings) {
        return SoftServiceLoader.load(TypeElementVisitor.class, (ClassLoader)TypeElementVisitorProcessor.class.getClassLoader()).disableFork().collectAll(visitor -> {
            String version;
            Requires.Sdk sdk;
            if (!visitor.isEnabled()) {
                return false;
            }
            Requires requires = visitor.getClass().getAnnotation(Requires.class);
            if (requires != null && (sdk = requires.sdk()) == Requires.Sdk.MICRONAUT && StringUtils.isNotEmpty((CharSequence)(version = requires.version())) && !VersionUtils.isAtLeastMicronautVersion((String)version)) {
                try {
                    if (warnings != null) {
                        warnings.add("TypeElementVisitor [" + visitor.getClass().getName() + "] will be ignored because Micronaut version [" + VersionUtils.MICRONAUT_VERSION + "] must be at least " + version);
                    }
                    return false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return true;
        }).stream().filter(Objects::nonNull).map(e -> e).collect(Collectors.toMap(Object::getClass, v -> v, (a, b) -> a)).values();
    }

    static {
        HashSet<String> warnings = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        for (TypeElementVisitor<?, ?> typeElementVisitor : TypeElementVisitorProcessor.findCoreTypeElementVisitors(warnings)) {
            Set supportedAnnotationNames;
            try {
                supportedAnnotationNames = typeElementVisitor.getSupportedAnnotationNames();
            }
            catch (Throwable e) {
                continue;
            }
            if (supportedAnnotationNames.equals(Collections.singleton("*"))) continue;
            names.addAll(supportedAnnotationNames);
        }
        SUPPORTED_ANNOTATION_NAMES = names;
        VISITOR_WARNINGS = warnings.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(warnings);
    }
}

