/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.util;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpMessage;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.util.HttpHeadersUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Optional;

public class HttpUtil {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    public static boolean isFormData(HttpRequest<?> request) {
        Optional<MediaType> opt = request.getContentType();
        if (opt.isPresent()) {
            MediaType contentType = opt.get();
            return contentType.equals(MediaType.APPLICATION_FORM_URLENCODED_TYPE) || contentType.equals(MediaType.MULTIPART_FORM_DATA_TYPE);
        }
        return false;
    }

    public static Optional<Charset> resolveCharset(@NonNull HttpMessage<?> request) {
        try {
            String charset;
            MediaType contentType = request.getContentType().orElse(null);
            if (contentType != null && (charset = contentType.getParametersMap().get("charset")) != null) {
                try {
                    return Optional.of(Charset.forName(charset));
                }
                catch (Exception e) {
                    return Optional.of(Charset.defaultCharset());
                }
            }
        }
        catch (UnsupportedCharsetException e) {
            return Optional.empty();
        }
        return request.getHeaders().findAcceptCharset();
    }

    @NonNull
    public static Charset getCharset(@NonNull HttpMessage<?> request) {
        MediaType contentType = request.getContentType().orElse(null);
        return HttpHeadersUtil.parseCharacterEncoding(contentType, request.getHeaders() != null ? request.getHeaders().findAcceptCharset().orElse(DEFAULT_CHARSET) : DEFAULT_CHARSET);
    }
}

