/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.reactive.execution;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlow;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

@Internal
final class FlowAsMono<T>
extends Mono<T>
implements Fuseable {
    final ExecutionFlow<? extends T> flow;

    FlowAsMono(ExecutionFlow<? extends T> flow) {
        this.flow = flow;
    }

    public void subscribe(CoreSubscriber<? super T> actual) {
        ImperativeExecutionFlow complete = this.flow.tryComplete();
        if (complete != null) {
            if (complete.getError() != null) {
                Operators.error(actual, (Throwable)complete.getError());
            } else if (complete.getValue() != null) {
                actual.onSubscribe(Operators.scalarSubscription(actual, (Object)complete.getValue()));
            } else {
                actual.onSubscribe(Operators.emptySubscription());
            }
        } else {
            new SubscriptionImpl(actual).callOnSubscribe();
        }
    }

    private final class SubscriptionImpl
    implements Fuseable.QueueSubscription<T> {
        private static final AtomicIntegerFieldUpdater<SubscriptionImpl> STATE = AtomicIntegerFieldUpdater.newUpdater(SubscriptionImpl.class, "state");
        private static final int STATE_WAITING = 0;
        private static final int STATE_SUBSCRIBING = 1;
        private static final int STATE_DONE = 2;
        private final CoreSubscriber<? super T> actual;
        private volatile int state;
        private boolean requested;
        private T result;
        private Throwable error;

        SubscriptionImpl(CoreSubscriber<? super T> actual) {
            this.actual = actual;
        }

        void callOnSubscribe() {
            this.state = 1;
            this.actual.onSubscribe((Subscription)this);
            if (STATE.getAndSet(this, 0) == 2) {
                this.forward(this.result, this.error);
            }
        }

        public void request(long n) {
            if (!this.requested) {
                this.requested = true;
                FlowAsMono.this.flow.onComplete((v, e) -> {
                    this.result = v;
                    this.error = e;
                    if (STATE.getAndSet(this, 2) == 0) {
                        this.forward((Object)v, (Throwable)e);
                    }
                });
            }
        }

        private void forward(T v, Throwable e) {
            if (v != null) {
                this.actual.onNext(v);
            }
            if (this.error == null) {
                this.actual.onComplete();
            } else {
                this.actual.onError(e);
            }
        }

        public void cancel() {
            this.requested = true;
            FlowAsMono.this.flow.cancel();
        }

        public int requestFusion(int requestedMode) {
            return 0;
        }

        public T poll() {
            throw SubscriptionImpl.noFusion();
        }

        public int size() {
            throw SubscriptionImpl.noFusion();
        }

        public boolean isEmpty() {
            throw SubscriptionImpl.noFusion();
        }

        public void clear() {
            throw SubscriptionImpl.noFusion();
        }

        private static UnsupportedOperationException noFusion() {
            return new UnsupportedOperationException("fusion not supported");
        }
    }
}

