/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

public enum HttpMethod implements CharSequence
{
    OPTIONS(false, true),
    GET(false, false),
    HEAD(false, false),
    POST(true, true),
    PUT(true, true),
    DELETE(false, true),
    TRACE(false, false),
    CONNECT(false, false),
    PATCH(true, true),
    CUSTOM(false, true);

    private final boolean requiresRequestBody;
    private final boolean permitsRequestBody;

    private HttpMethod(boolean requiresRequestBody, boolean permitsRequestBody) {
        this.requiresRequestBody = requiresRequestBody;
        this.permitsRequestBody = permitsRequestBody;
    }

    @Override
    public int length() {
        return this.name().length();
    }

    @Override
    public char charAt(int index) {
        return this.name().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.name().subSequence(start, end);
    }

    public boolean requiresRequestBody() {
        return this.requiresRequestBody;
    }

    public boolean permitsRequestBody() {
        return this.permitsRequestBody;
    }

    public boolean permitsResponseBody() {
        return this.permitsRequestBody;
    }

    public static boolean requiresRequestBody(HttpMethod method) {
        return method != null && (method.equals(POST) || method.equals(PUT) || method.equals(PATCH));
    }

    public static boolean permitsRequestBody(HttpMethod method) {
        return method != null && (HttpMethod.requiresRequestBody(method) || method.equals(OPTIONS) || method.equals(DELETE) || method.equals(CUSTOM));
    }

    public static HttpMethod parse(String httpMethodName) {
        HttpMethod httpMethod = HttpMethod.parseString(httpMethodName);
        if (httpMethod != null) {
            return httpMethod;
        }
        httpMethod = HttpMethod.parseString(httpMethodName = httpMethodName.toUpperCase());
        if (httpMethod != null) {
            return httpMethod;
        }
        return CUSTOM;
    }

    private static HttpMethod parseString(String httpMethodName) {
        switch (httpMethodName) {
            case "OPTIONS": 
            case "options": {
                return OPTIONS;
            }
            case "GET": 
            case "get": {
                return GET;
            }
            case "HEAD": 
            case "head": {
                return HEAD;
            }
            case "POST": 
            case "post": {
                return POST;
            }
            case "PUT": 
            case "put": {
                return PUT;
            }
            case "DELETE": 
            case "delete": {
                return DELETE;
            }
            case "TRACE": 
            case "trace": {
                return TRACE;
            }
            case "CONNECT": 
            case "connect": {
                return CONNECT;
            }
            case "PATCH": 
            case "patch": {
                return PATCH;
            }
        }
        return null;
    }
}

