/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.uri;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.uri.DefaultUriMatchInfo;
import io.micronaut.http.uri.UriMatchInfo;
import io.micronaut.http.uri.UriMatchVariable;
import io.micronaut.http.uri.UriMatcher;
import io.micronaut.http.uri.UriTemplateExpander;
import io.micronaut.http.uri.UriTemplateParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Internal
public final class UriTemplateMatcher
implements UriMatcher,
Comparable<UriTemplateMatcher> {
    private final String templateString;
    private final List<UriTemplateParser.Part> parts;
    private final List<UriMatchVariable> variables;
    private final Segment[] segments;
    private final boolean isRoot;
    private UriMatchInfo rootMatchInfo;
    private UriMatchInfo exactMatchInfo;

    public UriTemplateMatcher(String templateString) {
        this(templateString, UriTemplateParser.parse(templateString));
    }

    private UriTemplateMatcher(String templateString, List<UriTemplateParser.Part> parts) {
        this.templateString = templateString;
        this.parts = parts;
        ArrayList<UriMatchVariable> variables = new ArrayList<UriMatchVariable>();
        this.segments = UriTemplateMatcher.provideMatchSegments(parts, variables);
        this.isRoot = this.segments.length == 0 || this.segments.length == 1 && this.segments[0].type == SegmentType.LITERAL && this.isRoot(this.segments[0].value);
        this.variables = Collections.unmodifiableList(variables);
    }

    private static Segment[] provideMatchSegments(List<UriTemplateParser.Part> parts, List<UriMatchVariable> variables) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        ArrayList<String> regexpVariables = new ArrayList<String>();
        StringBuilder regexp = null;
        for (int i = 0; i < parts.size(); ++i) {
            UriTemplateParser.Part part = parts.get(i);
            if (part instanceof UriTemplateParser.Literal) {
                UriTemplateParser.Literal literal = (UriTemplateParser.Literal)part;
                if (regexp == null) {
                    segments.add(new Segment(SegmentType.LITERAL, literal.text(), null, null));
                    continue;
                }
                regexp.append(Pattern.quote(literal.text()));
                continue;
            }
            if (!(part instanceof UriTemplateParser.Expression)) continue;
            UriTemplateParser.Expression expression = (UriTemplateParser.Expression)part;
            if (regexp == null && UriTemplateMatcher.allowPathSegment(expression, parts, i)) {
                for (UriTemplateParser.Variable variable : expression.variables()) {
                    variables.add(new UriMatchVariable(variable.name(), variable.explode() ? (char)'*' : '0', expression.type().getOperator()));
                    segments.add(new Segment(SegmentType.PATH, variable.name(), null, null));
                }
                continue;
            }
            if (regexp == null) {
                regexp = new StringBuilder();
            }
            for (UriTemplateParser.Variable variable : expression.variables()) {
                variables.add(new UriMatchVariable(variable.name(), variable.explode() ? (char)'*' : '0', expression.type().getOperator()));
                UriTemplateMatcher.appendRegexp(regexp, expression.type(), variable, regexpVariables);
            }
        }
        if (regexp != null) {
            segments.add(new Segment(SegmentType.REGEXP, null, Pattern.compile(regexp.toString()), (String[])regexpVariables.toArray(String[]::new)));
        }
        return (Segment[])segments.toArray(Segment[]::new);
    }

    private static boolean allowPathSegment(UriTemplateParser.Expression expression, List<UriTemplateParser.Part> parts, int index) {
        UriTemplateParser.Literal literal;
        if (expression.type() != UriTemplateParser.ExpressionType.NONE) {
            return false;
        }
        if (!expression.variables().stream().allMatch(v -> v.modifier() == null)) {
            return false;
        }
        if (parts.size() == index + 1) {
            return true;
        }
        UriTemplateParser.Part part = parts.get(index + 1);
        return part instanceof UriTemplateParser.Literal && (literal = (UriTemplateParser.Literal)part).text().startsWith("/");
    }

    private static void appendRegexp(StringBuilder regexpBuilder, UriTemplateParser.ExpressionType type, UriTemplateParser.Variable variable, List<String> variables) {
        switch (type) {
            case PATH_STYLE_PARAMETER_EXPANSION: 
            case FORM_STYLE_PARAMETER_EXPANSION: 
            case FORM_STYLE_QUERY_CONTINUATION: 
            case FRAGMENT_EXPANSION: {
                return;
            }
        }
        Integer limit = null;
        String pattern = null;
        String modifier = variable.modifier();
        if (StringUtils.isNotEmpty((CharSequence)modifier)) {
            try {
                limit = Integer.parseInt(modifier);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (limit == null) {
                pattern = modifier;
            }
        }
        String operatorPrefix = "";
        String operatorQuantifier = "";
        Object variableQuantifier = "+?)";
        Object variablePattern = null;
        if (pattern != null) {
            char firstChar = pattern.charAt(0);
            if (firstChar == '?') {
                operatorQuantifier = "";
            } else {
                int patternLength = pattern.length();
                char lastChar = pattern.charAt(patternLength - 1);
                if (lastChar == '*' || patternLength > 1 && lastChar == '?' && (pattern.charAt(patternLength - 2) == '*' || pattern.charAt(patternLength - 2) == '+')) {
                    operatorQuantifier = "?";
                }
                String s = firstChar == '^' ? pattern.substring(1) : pattern;
                char operator = type.getOperator();
                if (operator == '/' || operator == '.') {
                    variablePattern = "(" + s + ")";
                } else {
                    operatorPrefix = "(";
                    variablePattern = s + ")";
                }
                variableQuantifier = "";
            }
        } else if (limit != null) {
            variableQuantifier = "{1," + limit + "})";
        }
        variables.add(variable.name());
        boolean operatorAppended = false;
        switch (type) {
            case LABEL_EXPANSION: 
            case PATH_SEGMENT_EXPANSION: {
                regexpBuilder.append('(').append(operatorPrefix).append('\\').append(type.getOperator()).append(operatorQuantifier);
                operatorAppended = true;
            }
            case RESERVED_EXPANSION: 
            case NONE: {
                if (!operatorAppended) {
                    regexpBuilder.append('(').append(operatorPrefix);
                }
                if (variablePattern == null) {
                    variablePattern = type == UriTemplateParser.ExpressionType.RESERVED_EXPANSION ? "([\\S]" : "([^/?#(!{)&;+]";
                }
                regexpBuilder.append((String)variablePattern).append((String)variableQuantifier).append(')');
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported regexp expression type: " + String.valueOf((Object)type));
            }
        }
        if (type == UriTemplateParser.ExpressionType.PATH_SEGMENT_EXPANSION || pattern != null && pattern.equals("?")) {
            regexpBuilder.append('?');
        }
    }

    public Optional<UriMatchInfo> match(String uri) {
        return Optional.ofNullable(this.tryMatch(uri));
    }

    @Nullable
    public UriMatchInfo tryMatch(@NonNull String uri) {
        int length = uri.length();
        if (length > 1 && uri.charAt(length - 1) == '/') {
            uri = uri.substring(0, length - 1);
        }
        if (this.isRoot && this.isRoot(uri)) {
            if (this.rootMatchInfo == null) {
                this.rootMatchInfo = new DefaultUriMatchInfo(uri, Collections.emptyMap(), this.variables);
            }
            return this.rootMatchInfo;
        }
        int parameterIndex = uri.indexOf(63);
        if (parameterIndex > -1 && (length = (uri = uri.substring(0, parameterIndex)).length()) > 1 && uri.charAt(length - 1) == '/') {
            uri = uri.substring(0, length - 1);
        }
        if (this.variables.isEmpty()) {
            if (uri.equals(this.templateString)) {
                if (this.exactMatchInfo == null) {
                    this.exactMatchInfo = new DefaultUriMatchInfo(uri, Collections.emptyMap(), this.variables);
                }
                return this.exactMatchInfo;
            }
            return null;
        }
        LinkedHashMap variableMap = CollectionUtils.newLinkedHashMap((int)this.variables.size());
        if (this.match(uri, variableMap)) {
            return new DefaultUriMatchInfo(uri, variableMap, this.variables);
        }
        return null;
    }

    private boolean match(String uri, Map<String, Object> variableMap) {
        block5: for (int i = 0; i < this.segments.length; ++i) {
            Segment segment = this.segments[i];
            switch (segment.type) {
                case LITERAL: {
                    if (uri.startsWith(segment.value)) {
                        uri = uri.substring(segment.value.length());
                        continue block5;
                    }
                    return false;
                }
                case PATH: {
                    boolean requiresSlash = i + 1 != this.segments.length;
                    int index = UriTemplateMatcher.readText(uri, requiresSlash);
                    if (index > 0) {
                        String path = uri.substring(0, index);
                        variableMap.put(segment.value, path);
                        uri = uri.substring(index);
                        continue block5;
                    }
                    return false;
                }
                case REGEXP: {
                    Matcher matcher = segment.pattern.matcher(uri);
                    if (matcher.matches()) {
                        int groupInx = 2;
                        for (String matchingVariable : segment.regexpVariables) {
                            String group = matcher.group(groupInx);
                            variableMap.put(matchingVariable, group);
                            groupInx += 2;
                        }
                        return true;
                    }
                    return false;
                }
                default: {
                    throw new IllegalStateException("Unsupported segment type: " + String.valueOf((Object)segment.type));
                }
            }
        }
        return uri.isEmpty();
    }

    private static int readText(String input, boolean requiresSlash) {
        int length = input.length();
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            if (requiresSlash && c == '/') {
                return i;
            }
            if (!UriTemplateMatcher.rejectCharacter(c, input, i)) continue;
            return -1;
        }
        return length;
    }

    private static boolean rejectCharacter(char c, String input, int i) {
        switch (c) {
            case '&': 
            case '+': 
            case '/': 
            case ';': 
            case '?': 
            case '{': 
            case '}': {
                return true;
            }
            case '#': {
                if (i + 1 >= input.length() || (c = input.charAt(i + 1)) == '{') break;
                return true;
            }
        }
        return false;
    }

    public UriTemplateMatcher nest(CharSequence uriTemplate) {
        List<UriTemplateParser.Part> newParts = UriTemplateParser.parse(uriTemplate.toString());
        return new UriTemplateMatcher(this.templateString + String.valueOf(uriTemplate), UriTemplateParser.concat(this.parts, newParts));
    }

    public String toPathString() {
        final StringBuilder builder = new StringBuilder();
        UriTemplateMatcher.visitParts(this.parts, new UriTemplateParser.PartVisitor(){

            @Override
            public void visitLiteral(String literal) {
                builder.append(literal);
            }

            @Override
            public void visitExpression(UriTemplateParser.ExpressionType type, List<UriTemplateParser.Variable> variables) {
                builder.append('{');
                if (type != UriTemplateParser.ExpressionType.NONE) {
                    builder.append(type.getOperator());
                }
                Iterator<UriTemplateParser.Variable> iterator = variables.iterator();
                while (iterator.hasNext()) {
                    UriTemplateParser.Variable variable = iterator.next();
                    builder.append(variable.name());
                    if (variable.explode()) {
                        builder.append('*');
                    }
                    if (variable.modifier() != null) {
                        builder.append(':');
                        builder.append(variable.modifier());
                    }
                    if (!iterator.hasNext()) continue;
                    builder.append(',');
                }
                builder.append('}');
            }
        });
        return builder.toString();
    }

    public String expand(Map<String, Object> parameters) {
        UriTemplateExpander uriTemplateExpander = new UriTemplateExpander(parameters);
        UriTemplateMatcher.visitParts(this.parts, uriTemplateExpander);
        return uriTemplateExpander.toString();
    }

    @Override
    public int compareTo(UriTemplateMatcher o) {
        if (this == o) {
            return 0;
        }
        PathEvaluator thisEvaluator = new PathEvaluator();
        PathEvaluator thatEvaluator = new PathEvaluator();
        UriTemplateMatcher.visitParts(this.parts, thisEvaluator);
        UriTemplateMatcher.visitParts(o.parts, thatEvaluator);
        int rawCompare = Integer.compare(thatEvaluator.rawLength, thisEvaluator.rawLength);
        if (rawCompare == 0) {
            return Integer.compare(thisEvaluator.variableCount, thatEvaluator.variableCount);
        }
        return rawCompare;
    }

    public String toString() {
        return this.toPathString();
    }

    private static void visitParts(List<UriTemplateParser.Part> parts, UriTemplateParser.PartVisitor visitor) {
        for (UriTemplateParser.Part part : parts) {
            part.visit(visitor);
        }
    }

    private boolean isRoot(String uri) {
        int length = uri.length();
        return length == 0 || length == 1 && uri.charAt(0) == '/';
    }

    public static UriTemplateMatcher of(String uri) {
        return new UriTemplateMatcher(uri);
    }

    private record Segment(SegmentType type, String value, Pattern pattern, String[] regexpVariables) {
    }

    private static enum SegmentType {
        LITERAL,
        PATH,
        REGEXP;

    }

    private static final class PathEvaluator
    implements UriTemplateParser.PartVisitor {
        int variableCount = 0;
        int rawLength = 0;

        private PathEvaluator() {
        }

        @Override
        public void visitLiteral(String literal) {
            this.rawLength += literal.length();
        }

        @Override
        public void visitExpression(UriTemplateParser.ExpressionType type, List<UriTemplateParser.Variable> variables) {
            if (!type.isQueryPart()) {
                this.variableCount += variables.size();
            }
        }
    }
}

