/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.routes.rules;

import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.validation.routes.RouteValidationResult;
import io.micronaut.validation.routes.rules.RouteValidationRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class RequestBeanParameterRule
implements RouteValidationRule {
    @Override
    public RouteValidationResult validate(List<UriMatchTemplate> templates, ParameterElement[] parameters, MethodElement method) {
        return new RouteValidationResult((String[])Arrays.stream(parameters).filter(p -> p.hasAnnotation("io.micronaut.http.annotation.RequestBean")).flatMap(p -> this.validate((ParameterElement)p).stream()).toArray(String[]::new));
    }

    private List<String> validate(ParameterElement parameterElement) {
        ArrayList<String> errors = new ArrayList<String>();
        List beanProperties = parameterElement.getType().getBeanProperties();
        Optional primaryConstructor = parameterElement.getType().getPrimaryConstructor();
        if (primaryConstructor.isPresent() && ((MethodElement)primaryConstructor.get()).getParameters().length > 0) {
            List<ParameterElement> constructorParameters = Arrays.asList(((MethodElement)primaryConstructor.get()).getParameters());
            if (!parameterElement.getType().isRecord()) {
                constructorParameters.stream().filter(p -> p.hasStereotype(Bindable.class)).forEach(p -> errors.add("Parameter of Primary Constructor (or @Creator Method) [" + p.getName() + "] for type [" + parameterElement.getType().getName() + "] has one of @Bindable annotations. This is not supported.\nNote1: Primary constructor is a constructor that have parameters or is annotated with @Creator.\nNote2: In case you have multiple @Creator constructors, first is used as primary constructor."));
            }
            beanProperties.stream().filter(PropertyElement::isReadOnly).filter(p -> constructorParameters.stream().noneMatch(constructorProperty -> constructorProperty.getName().equals(p.getName()))).forEach(p -> errors.add("Primary Constructor or @Creator Method for Bindable property [" + p.getName() + "] for type [" + parameterElement.getType().getName() + "] found, but there is no constructor/method parameter with name equal to [" + p.getName() + "].\nAdd parameter with name [" + p.getName() + "] to your @Creator.\nNote1: Primary constructor is a constructor that have parameters or is annotated with @Creator.\nNote2: In case you have multiple @Creator constructors, first is used as primary constructor."));
        } else {
            beanProperties.stream().filter(PropertyElement::isReadOnly).forEach(p -> errors.add("Bindable property [" + p.getName() + "] for type [" + parameterElement.getType().getName() + "] is Read only and cannot be set during initialization.\nAdd property setter or add @Creator constructor/method."));
        }
        return errors;
    }
}

