/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ErrorExceptionHandler<T extends Throwable>
implements ExceptionHandler<T, HttpResponse<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorExceptionHandler.class);
    protected final ErrorResponseProcessor<?> responseProcessor;

    protected ErrorExceptionHandler(ErrorResponseProcessor<?> responseProcessor) {
        this.responseProcessor = responseProcessor;
    }

    @Override
    public HttpResponse<?> handle(HttpRequest request, T exception) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} (Bad Request): {}", (Object)request, (Object)((Throwable)exception).getMessage());
        }
        return this.responseProcessor.processResponse(ErrorContext.builder(request).cause((Throwable)exception).error(this.error(exception)).build(), HttpResponse.badRequest());
    }

    protected abstract @NonNull Error error(T var1);
}

