/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.cors;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ImmutableArgumentConversionContext;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ResponseFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.http.filter.ConditionalFilter;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.annotation.PreMatching;
import io.micronaut.http.server.cors.CorsOriginConfiguration;
import io.micronaut.http.server.cors.CorsUtil;
import io.micronaut.http.server.cors.CrossOriginUtil;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.UriRouteMatch;
import jakarta.inject.Inject;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerFilter(value={"/**"})
public class CorsFilter
implements Ordered,
ConditionalFilter {
    public static final int CORS_FILTER_ORDER = ServerFilterPhase.METRICS.after();
    private static final Logger LOG = LoggerFactory.getLogger(CorsFilter.class);
    private static final ArgumentConversionContext<HttpMethod> CONVERSION_CONTEXT_HTTP_METHOD = ImmutableArgumentConversionContext.of(HttpMethod.class);
    protected final HttpServerConfiguration.CorsConfiguration corsConfiguration;
    private final @Nullable HttpHostResolver httpHostResolver;
    private final Router router;

    @Deprecated(since="4.7", forRemoval=true)
    public CorsFilter(HttpServerConfiguration.CorsConfiguration corsConfiguration, @Nullable HttpHostResolver httpHostResolver) {
        this.corsConfiguration = corsConfiguration;
        this.httpHostResolver = httpHostResolver;
        this.router = null;
    }

    @Inject
    public CorsFilter(HttpServerConfiguration.CorsConfiguration corsConfiguration, @Nullable HttpHostResolver httpHostResolver, Router router) {
        this.corsConfiguration = corsConfiguration;
        this.httpHostResolver = httpHostResolver;
        this.router = router;
    }

    public boolean isEnabled(HttpRequest<?> request) {
        String origin = request.getOrigin().orElse(null);
        if (origin == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Http Header Origin not present. Proceeding with the request.");
            }
            return false;
        }
        return true;
    }

    @PreMatching
    @RequestFilter
    @Internal
    public final @Nullable HttpResponse<?> filterPreFlightRequest(HttpRequest<?> request) {
        CorsOriginConfiguration corsOriginConfiguration;
        if (this.isEnabled(request) && CorsUtil.isPreflightRequest(request) && (corsOriginConfiguration = (CorsOriginConfiguration)this.getAnyConfiguration(request).orElse(null)) != null) {
            return this.handlePreflightRequest(request, corsOriginConfiguration);
        }
        return null;
    }

    @RequestFilter
    @Internal
    public final @Nullable HttpResponse<?> filterRequest(HttpRequest<?> request) {
        String origin = request.getOrigin().orElse(null);
        if (origin == null) {
            LOG.trace("Http Header {} not present. Proceeding with the request.", (Object)"Origin");
            return null;
        }
        CorsOriginConfiguration corsOriginConfiguration = this.getConfiguration(request).orElse(null);
        if (corsOriginConfiguration != null) {
            if (this.validateMethodToMatch(request, corsOriginConfiguration).isEmpty()) {
                return CorsFilter.forbidden();
            }
            if (this.shouldDenyToPreventDriveByLocalhostAttack(corsOriginConfiguration, request)) {
                LOG.trace("The resolved configuration allows any origin. To prevent drive-by-localhost attacks the request is forbidden");
                return CorsFilter.forbidden();
            }
            return null;
        }
        if (this.shouldDenyToPreventDriveByLocalhostAttack(origin, request)) {
            LOG.trace("The request specifies an origin different than localhost. To prevent drive-by-localhost attacks the request is forbidden");
            return CorsFilter.forbidden();
        }
        LOG.trace("CORS configuration not found for {} origin", (Object)origin);
        return null;
    }

    @ResponseFilter
    @Internal
    public final void filterResponse(HttpRequest<?> request, MutableHttpResponse<?> response) {
        CorsOriginConfiguration corsOriginConfiguration = this.getConfiguration(request).orElse(null);
        if (corsOriginConfiguration != null) {
            if (CorsUtil.isPreflightRequest(request)) {
                this.decorateResponseWithHeadersForPreflightRequest(request, response, corsOriginConfiguration);
            }
            this.decorateResponseWithHeaders(request, response, corsOriginConfiguration);
        }
    }

    protected boolean shouldDenyToPreventDriveByLocalhostAttack(@NonNull CorsOriginConfiguration corsOriginConfiguration, @NonNull HttpRequest<?> request) {
        if (this.corsConfiguration.isLocalhostPassThrough()) {
            return false;
        }
        if (this.httpHostResolver == null) {
            return false;
        }
        String origin = request.getOrigin().orElse(null);
        if (origin == null) {
            return false;
        }
        if (this.isOriginLocal(origin)) {
            return false;
        }
        String host = this.httpHostResolver.resolve(request);
        return corsOriginConfiguration.getAllowedOriginsRegex().isEmpty() && CorsFilter.isAny(corsOriginConfiguration.getAllowedOrigins()) && this.isHostLocal(host);
    }

    protected boolean shouldDenyToPreventDriveByLocalhostAttack(@NonNull String origin, @NonNull HttpRequest<?> request) {
        if (this.corsConfiguration.isLocalhostPassThrough()) {
            return false;
        }
        if (this.httpHostResolver == null) {
            return false;
        }
        String host = this.httpHostResolver.resolve(request);
        return !this.isOriginLocal(origin) && this.isHostLocal(host);
    }

    private boolean isHostLocal(@NonNull String hostString) {
        if (hostString.isEmpty()) {
            return false;
        }
        char initialChar = hostString.charAt(0);
        if (initialChar != 'h' && initialChar != 'w') {
            return false;
        }
        return hostString.startsWith("http://localhost") || hostString.startsWith("https://localhost") || hostString.startsWith("http://127.") || hostString.startsWith("https://127.") || hostString.startsWith("ws://localhost") || hostString.startsWith("wss://localhost") || hostString.startsWith("ws://127.") || hostString.startsWith("wss://127.");
    }

    private boolean isOriginLocal(@NonNull String hostString) {
        try {
            URI uri = URI.create(hostString);
            String host = uri.getHost();
            return "localhost".equals(host) || "127.0.0.1".equals(host);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public int getOrder() {
        return CORS_FILTER_ORDER;
    }

    private @NonNull Optional<HttpMethod> validateMethodToMatch(@NonNull HttpRequest<?> request, @NonNull CorsOriginConfiguration config) {
        HttpMethod methodToMatch = this.methodToMatch(request);
        if (!this.methodAllowed(config, methodToMatch)) {
            return Optional.empty();
        }
        return Optional.of(methodToMatch);
    }

    protected void setAllowCredentials(CorsOriginConfiguration config, MutableHttpResponse<?> response) {
        if (config.isAllowCredentials()) {
            response.header((CharSequence)"Access-Control-Allow-Credentials", (CharSequence)"true");
        }
    }

    protected void setAllowPrivateNetwork(CorsOriginConfiguration config, MutableHttpResponse<?> response) {
        if (config.isAllowPrivateNetwork()) {
            response.header((CharSequence)"Access-Control-Allow-Private-Network", (CharSequence)"true");
        }
    }

    protected void setExposeHeaders(List<String> exposedHeaders, MutableHttpResponse<?> response) {
        if (this.corsConfiguration.isSingleHeader()) {
            String headerValue = String.join((CharSequence)",", exposedHeaders);
            if (StringUtils.isNotEmpty((CharSequence)headerValue)) {
                response.header((CharSequence)"Access-Control-Expose-Headers", (CharSequence)headerValue);
            }
        } else {
            exposedHeaders.forEach(header -> response.header((CharSequence)"Access-Control-Expose-Headers", (CharSequence)header));
        }
    }

    protected void setVary(MutableHttpResponse<?> response) {
        response.header((CharSequence)"Vary", (CharSequence)"Origin");
    }

    protected void setOrigin(@Nullable String origin, @NonNull MutableHttpResponse<?> response) {
        if (origin != null) {
            response.header((CharSequence)"Access-Control-Allow-Origin", (CharSequence)origin);
        }
    }

    protected void setAllowMethods(HttpMethod method, MutableHttpResponse<?> response) {
        response.header((CharSequence)"Access-Control-Allow-Methods", (CharSequence)method);
    }

    protected void setAllowHeaders(List<?> optionalAllowHeaders, MutableHttpResponse<?> response) {
        List allowHeaders = optionalAllowHeaders.stream().map(Object::toString).collect(Collectors.toList());
        if (this.corsConfiguration.isSingleHeader()) {
            String headerValue = String.join((CharSequence)",", allowHeaders);
            if (StringUtils.isNotEmpty((CharSequence)headerValue)) {
                response.header((CharSequence)"Access-Control-Allow-Headers", (CharSequence)headerValue);
            }
        } else {
            allowHeaders.stream().map(StringUtils::trimLeadingWhitespace).forEach(header -> response.header((CharSequence)"Access-Control-Allow-Headers", (CharSequence)header));
        }
    }

    protected void setMaxAge(long maxAge, MutableHttpResponse<?> response) {
        if (maxAge > -1L) {
            response.header((CharSequence)"Access-Control-Max-Age", (CharSequence)Long.toString(maxAge));
        }
    }

    private @NonNull Optional<CorsOriginConfiguration> getConfiguration(@NonNull HttpRequest<?> request) {
        String requestOrigin = request.getOrigin().orElse(null);
        if (requestOrigin == null) {
            return Optional.empty();
        }
        Optional<CorsOriginConfiguration> originConfiguration = CrossOriginUtil.getCorsOriginConfigurationForRequest(request);
        if (originConfiguration.isPresent() && CorsFilter.matchesOrigin(originConfiguration.get(), requestOrigin)) {
            return originConfiguration;
        }
        if (!this.corsConfiguration.isEnabled()) {
            return Optional.empty();
        }
        return this.corsConfiguration.getConfigurations().values().stream().filter(config -> CorsFilter.matchesOrigin(config, requestOrigin)).findFirst();
    }

    private @NonNull Optional<CorsOriginConfiguration> getAnyConfiguration(@NonNull HttpRequest<?> request) {
        String requestOrigin = request.getOrigin().orElse(null);
        if (requestOrigin == null) {
            return Optional.empty();
        }
        for (UriRouteMatch routeMatch : this.router.findAny(request)) {
            Optional<CorsOriginConfiguration> corsOriginConfiguration = CrossOriginUtil.getCorsOriginConfiguration((AnnotationMetadata)routeMatch);
            if (!corsOriginConfiguration.isPresent() || !CorsFilter.matchesOrigin(corsOriginConfiguration.get(), requestOrigin)) continue;
            return corsOriginConfiguration;
        }
        if (!this.corsConfiguration.isEnabled()) {
            return Optional.empty();
        }
        return this.corsConfiguration.getConfigurations().values().stream().filter(config -> CorsFilter.matchesOrigin(config, requestOrigin)).findFirst();
    }

    private static boolean matchesOrigin(@NonNull CorsOriginConfiguration config, String requestOrigin) {
        if (config.getAllowedOriginsRegex().map(regex -> CorsFilter.matchesOrigin(regex, requestOrigin)).orElse(false).booleanValue()) {
            return true;
        }
        List<String> allowedOrigins = config.getAllowedOrigins();
        return !allowedOrigins.isEmpty() && (config.getAllowedOriginsRegex().isEmpty() && CorsFilter.isAny(allowedOrigins) || allowedOrigins.stream().anyMatch(origin -> origin.equals(requestOrigin)));
    }

    private static boolean matchesOrigin(@NonNull String originRegex, @NonNull String requestOrigin) {
        Pattern p = Pattern.compile(originRegex);
        Matcher m = p.matcher(requestOrigin);
        return m.matches();
    }

    private static boolean isAny(List<String> values) {
        return values == CorsOriginConfiguration.ANY;
    }

    private static boolean isAnyMethod(List<HttpMethod> allowedMethods) {
        return allowedMethods == CorsOriginConfiguration.ANY_METHOD;
    }

    private boolean methodAllowed(@NonNull CorsOriginConfiguration config, @NonNull HttpMethod methodToMatch) {
        List<HttpMethod> allowedMethods = config.getAllowedMethods();
        return CorsFilter.isAnyMethod(allowedMethods) || allowedMethods.stream().anyMatch(method -> method.equals((Object)methodToMatch));
    }

    private @NonNull HttpMethod methodToMatch(@NonNull HttpRequest<?> request) {
        HttpMethod requestMethod = request.getMethod();
        return CorsUtil.isPreflightRequest(request) ? request.getHeaders().getFirst((CharSequence)"Access-Control-Request-Method", CONVERSION_CONTEXT_HTTP_METHOD).orElse(requestMethod) : requestMethod;
    }

    private boolean hasAllowedHeaders(@NonNull HttpRequest<?> request, @NonNull CorsOriginConfiguration config) {
        Optional accessControlHeaders = request.getHeaders().get((CharSequence)"Access-Control-Request-Headers", ConversionContext.LIST_OF_STRING);
        List<String> allowedHeaders = config.getAllowedHeaders();
        return CorsFilter.isAny(allowedHeaders) || accessControlHeaders.isPresent() && ((List)accessControlHeaders.get()).stream().allMatch(header -> allowedHeaders.stream().anyMatch(allowedHeader -> allowedHeader.equalsIgnoreCase(header.trim())));
    }

    private static @NonNull MutableHttpResponse<Object> forbidden() {
        return HttpResponse.status((HttpStatus)HttpStatus.FORBIDDEN);
    }

    private void decorateResponseWithHeadersForPreflightRequest(@NonNull HttpRequest<?> request, @NonNull MutableHttpResponse<?> response, @NonNull CorsOriginConfiguration config) {
        HttpHeaders headers = request.getHeaders();
        headers.getFirst((CharSequence)"Access-Control-Request-Method", CONVERSION_CONTEXT_HTTP_METHOD).ifPresent(methods -> this.setAllowMethods((HttpMethod)methods, response));
        headers.get((CharSequence)"Access-Control-Request-Headers", ConversionContext.LIST_OF_STRING).ifPresent(val -> this.setAllowHeaders((List<?>)val, response));
        headers.getFirst((CharSequence)"Access-Control-Request-Private-Network", ConversionContext.BOOLEAN).ifPresent(value -> this.setAllowPrivateNetwork(config, response));
        this.setMaxAge(config.getMaxAge(), response);
    }

    private void decorateResponseWithHeaders(@NonNull HttpRequest<?> request, @NonNull MutableHttpResponse<?> response, @NonNull CorsOriginConfiguration config) {
        this.setOrigin(request.getOrigin().orElse(null), response);
        this.setVary(response);
        this.setExposeHeaders(config.getExposedHeaders(), response);
        this.setAllowCredentials(config, response);
    }

    private @NonNull MutableHttpResponse<?> handlePreflightRequest(@NonNull HttpRequest<?> request, @NonNull CorsOriginConfiguration corsOriginConfiguration) {
        boolean isValid = this.validatePreflightRequest(request, corsOriginConfiguration);
        if (!isValid) {
            return HttpResponse.status((HttpStatus)HttpStatus.FORBIDDEN);
        }
        MutableHttpResponse resp = HttpResponse.status((HttpStatus)HttpStatus.OK);
        this.decorateResponseWithHeadersForPreflightRequest(request, resp, corsOriginConfiguration);
        this.decorateResponseWithHeaders(request, resp, corsOriginConfiguration);
        return resp;
    }

    private @Nullable boolean validatePreflightRequest(@NonNull HttpRequest<?> request, @NonNull CorsOriginConfiguration config) {
        boolean accessControlRequestPrivateNetwork;
        Optional<HttpMethod> methodToMatchOptional = this.validateMethodToMatch(request, config);
        if (methodToMatchOptional.isEmpty()) {
            return false;
        }
        HttpMethod methodToMatch = methodToMatchOptional.get();
        if (!CorsUtil.isPreflightRequest(request)) {
            return false;
        }
        List<HttpMethod> availableHttpMethods = this.router.findAny(request).stream().map(UriRouteMatch::getHttpMethod).toList();
        if (availableHttpMethods.stream().noneMatch(method -> method.equals((Object)methodToMatch))) {
            return false;
        }
        if (!this.hasAllowedHeaders(request, config)) {
            return false;
        }
        return !request.getHeaders().contains("Access-Control-Request-Private-Network") || !(accessControlRequestPrivateNetwork = ((Boolean)request.getHeaders().get((CharSequence)"Access-Control-Request-Private-Network", Boolean.class, (Object)Boolean.FALSE)).booleanValue()) || config.isAllowPrivateNetwork();
    }
}

