/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.ByteBodyHttpResponseWrapper;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.ResponseBodyWriter;
import io.micronaut.http.body.stream.InputStreamByteBody;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.body.AbstractFileBodyWriter;
import io.micronaut.http.server.types.files.StreamedFile;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jspecify.annotations.NonNull;

@Singleton
@Internal
public final class StreamFileBodyWriter
extends AbstractFileBodyWriter
implements ResponseBodyWriter<StreamedFile> {
    private final ExecutorService ioExecutor;

    StreamFileBodyWriter(HttpServerConfiguration.FileTypeHandlerConfiguration configuration, @Named(value="blocking") ExecutorService ioExecutor) {
        super(configuration);
        this.ioExecutor = ioExecutor;
    }

    public ByteBodyHttpResponse<?> write(@NonNull ByteBodyFactory bodyFactory, HttpRequest<?> request, MutableHttpResponse<StreamedFile> outgoingResponse, Argument<StreamedFile> type, MediaType mediaType, StreamedFile object) throws CodecException {
        if (this.handleIfModifiedAndHeaders(request, outgoingResponse, object, outgoingResponse)) {
            return this.notModified(bodyFactory, outgoingResponse);
        }
        return ByteBodyHttpResponseWrapper.wrap(outgoingResponse, (CloseableByteBody)this.writePiece(bodyFactory, request, (HttpResponse<?>)outgoingResponse, type, mediaType, object));
    }

    public CloseableByteBody writePiece(@NonNull ByteBodyFactory bodyFactory, @NonNull HttpRequest<?> request, @NonNull HttpResponse<?> response, @NonNull Argument<StreamedFile> type, @NonNull MediaType mediaType, StreamedFile object) {
        long length = object.getLength();
        InputStream inputStream = object.getInputStream();
        return InputStreamByteBody.create((InputStream)inputStream, (OptionalLong)(length > -1L ? OptionalLong.of(length) : OptionalLong.empty()), (Executor)this.ioExecutor, (ByteBodyFactory)bodyFactory);
    }

    public void writeTo(Argument<StreamedFile> type, MediaType mediaType, StreamedFile object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        throw new UnsupportedOperationException("Can only be used in a Netty context");
    }
}

