/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.converters;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.netty.channel.converters.ChannelOptionFactory;
import io.micronaut.http.server.netty.multipart.NettyPartData;
import io.micronaut.http.simple.SimpleHttpHeaders;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Optional;

@Prototype
@Internal
public final class NettyConverters
implements TypeConverterRegistrar {
    private final ConversionService conversionService;
    private final BeanProvider<MediaTypeCodecRegistry> decoderRegistryProvider;
    private final BeanProvider<MessageBodyHandlerRegistry> messageBodyHandlerRegistries;
    private final BeanProvider<ChannelOptionFactory> channelOptionFactory;

    public NettyConverters(ConversionService conversionService, BeanProvider<MediaTypeCodecRegistry> decoderRegistryProvider, BeanProvider<MessageBodyHandlerRegistry> messageBodyHandlerRegistries, BeanProvider<ChannelOptionFactory> channelOptionFactory) {
        this.conversionService = conversionService;
        this.decoderRegistryProvider = decoderRegistryProvider;
        this.messageBodyHandlerRegistries = messageBodyHandlerRegistries;
        this.channelOptionFactory = channelOptionFactory;
    }

    public void register(MutableConversionService conversionService) {
        conversionService.addConverter(CharSequence.class, ChannelOption.class, (object, targetType, context) -> {
            String str = object.toString();
            String name = NameUtils.underscoreSeparate((String)str).toUpperCase(Locale.ENGLISH);
            return Optional.of(((ChannelOptionFactory)this.channelOptionFactory.get()).channelOption(name));
        });
        conversionService.addConverter(ByteBuf.class, Object.class, (object, targetType, context) -> conversionService.convert((Object)object.toString(context.getCharset()), targetType, context));
        conversionService.addConverter(FileUpload.class, Object.class, (object, targetType, context) -> {
            try {
                Argument argument;
                if (!object.isCompleted()) {
                    return Optional.empty();
                }
                if (context instanceof ArgumentConversionContext) {
                    ArgumentConversionContext argumentConversionContext = (ArgumentConversionContext)context;
                    argument = argumentConversionContext.getArgument();
                } else {
                    argument = Argument.of((Class)targetType);
                }
                Argument argument2 = argument;
                String contentType = object.getContentType();
                ByteBuf byteBuf = object.getByteBuf();
                MediaType mediaType = StringUtils.isEmpty((CharSequence)contentType) ? null : MediaType.of((String)contentType);
                MediaTypeCodec codec = ((MediaTypeCodecRegistry)this.decoderRegistryProvider.get()).findCodec(mediaType).orElse(null);
                if (codec != null) {
                    return Optional.of(codec.decode(argument2, (InputStream)new ByteBufInputStream(byteBuf)));
                }
                MessageBodyReader messageBodyReader = ((MessageBodyHandlerRegistry)this.messageBodyHandlerRegistries.get()).findReader(argument2, mediaType).orElse(null);
                if (messageBodyReader != null) {
                    return Optional.of(messageBodyReader.read(argument2, mediaType, (Headers)new SimpleHttpHeaders(), NettyByteBufferFactory.DEFAULT.wrap(byteBuf)));
                }
                return conversionService.convert((Object)byteBuf, targetType, context);
            }
            catch (Exception e) {
                context.reject(e);
                return Optional.empty();
            }
        });
        conversionService.addConverter(NettyPartData.class, Object.class, (object, targetType, context) -> {
            Optional optional;
            if (targetType.isAssignableFrom(ByteBuffer.class)) {
                return Optional.of(object.getByteBuffer());
            }
            if (targetType.isAssignableFrom(InputStream.class)) {
                return Optional.of(object.getInputStream());
            }
            ByteBuf byteBuf = object.getByteBuf();
            try {
                optional = this.conversionService.convert((Object)byteBuf, targetType, context);
            }
            catch (Throwable throwable) {
                try {
                    byteBuf.release();
                    throw throwable;
                }
                catch (IOException e) {
                    context.reject((Exception)e);
                    return Optional.empty();
                }
            }
            byteBuf.release();
            return optional;
        });
        conversionService.addConverter(Attribute.class, Object.class, (object, targetType, context) -> {
            try {
                String value = object.getValue();
                if (targetType.isInstance(value)) {
                    return Optional.of(value);
                }
                return this.conversionService.convert((Object)value, targetType, context);
            }
            catch (IOException e) {
                context.reject((Exception)e);
                return Optional.empty();
            }
        });
        conversionService.addConverter(String.class, ChannelOption.class, s -> ((ChannelOptionFactory)this.channelOptionFactory.get()).channelOption(NameUtils.environmentName((String)s)));
    }

    public static <T> Optional<T> refCountAwareConvert(ConversionService service, ReferenceCounted input, ArgumentConversionContext<T> context) {
        Optional converted = service.convert((Object)input, context);
        NettyConverters.postProcess(input, converted);
        return converted;
    }

    public static <T> void postProcess(ReferenceCounted input, Optional<T> converted) {
        if (converted.isPresent()) {
            boolean targetRefCounted;
            input.touch();
            T item = converted.get();
            boolean bl = targetRefCounted = item instanceof ReferenceCounted || item instanceof io.micronaut.core.io.buffer.ReferenceCounted;
            if (!targetRefCounted) {
                input.release();
            }
        } else {
            input.release();
        }
    }
}

