/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.Named;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.body.stream.BodySizeLimits;
import io.micronaut.http.server.netty.HttpToHttpsRedirectHandler;
import io.micronaut.http.server.netty.NettyEmbeddedServices;
import io.micronaut.http.server.netty.NettyHttpServer;
import io.micronaut.http.server.netty.NettyServerCustomizer;
import io.micronaut.http.server.netty.QuicTokenHandlerImpl;
import io.micronaut.http.server.netty.RoutingInBoundHandler;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.handler.Http2ServerHandler;
import io.micronaut.http.server.netty.handler.PipeliningServerHandler;
import io.micronaut.http.server.netty.handler.RequestHandler;
import io.micronaut.http.server.netty.handler.accesslog.Http2AccessLogManager;
import io.micronaut.http.server.netty.handler.accesslog.HttpAccessLogHandler;
import io.micronaut.http.server.netty.websocket.NettyServerWebSocketUpgradeHandler;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.runtime.graceful.GracefulShutdownCapable;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.handler.codec.http3.DefaultHttp3GoAwayFrame;
import io.netty.handler.codec.http3.Http3;
import io.netty.handler.codec.http3.Http3FrameToHttpObjectCodec;
import io.netty.handler.codec.http3.Http3ServerConnectionHandler;
import io.netty.handler.codec.quic.QuicChannel;
import io.netty.handler.codec.quic.QuicServerCodecBuilder;
import io.netty.handler.codec.quic.QuicSslContext;
import io.netty.handler.codec.quic.QuicSslEngine;
import io.netty.handler.codec.quic.QuicStreamChannel;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.pcap.PcapWriteHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AsciiString;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpPipelineBuilder
implements Closeable {
    static final Supplier<AttributeKey<StreamPipeline>> STREAM_PIPELINE_ATTRIBUTE = SupplierUtil.memoized(() -> AttributeKey.newInstance((String)"stream-pipeline"));
    static final Supplier<AttributeKey<Supplier<SSLSession>>> SSL_SESSION_ATTRIBUTE = SupplierUtil.memoized(() -> AttributeKey.newInstance((String)"ssl-session"));
    private static final Logger LOG = LoggerFactory.getLogger(HttpPipelineBuilder.class);
    private final NettyHttpServer server;
    private final NettyEmbeddedServices embeddedServices;
    private final ServerSslConfiguration sslConfiguration;
    private final RoutingInBoundHandler routingInBoundHandler;
    private final HttpHostResolver hostResolver;
    private final LoggingHandler loggingHandler;
    private final SslContext sslContext;
    private final QuicSslContext quicSslContext;
    private final HttpAccessLogHandler accessLogHandler;
    private final Http2AccessLogManager.Factory accessLogManagerFactory;
    private final NettyServerCustomizer serverCustomizer;
    private final boolean quic;

    HttpPipelineBuilder(NettyHttpServer server, NettyEmbeddedServices embeddedServices, ServerSslConfiguration sslConfiguration, RoutingInBoundHandler routingInBoundHandler, HttpHostResolver hostResolver, NettyServerCustomizer serverCustomizer, boolean quic) {
        this.server = server;
        this.embeddedServices = embeddedServices;
        this.sslConfiguration = sslConfiguration;
        this.routingInBoundHandler = routingInBoundHandler;
        this.hostResolver = hostResolver;
        this.serverCustomizer = serverCustomizer;
        this.quic = quic;
        Optional<LogLevel> logLevel = server.getServerConfiguration().getLogLevel();
        this.loggingHandler = logLevel.map(level -> new LoggingHandler(NettyHttpServer.class, level)).orElse(null);
        this.sslContext = embeddedServices.getServerSslBuilder() != null && !quic ? (SslContext)embeddedServices.getServerSslBuilder().build().orElse(null) : null;
        this.quicSslContext = quic ? (QuicSslContext)embeddedServices.getServerSslBuilder().buildQuic().orElse(null) : null;
        NettyHttpServerConfiguration.AccessLogger accessLogger = server.getServerConfiguration().getAccessLogger();
        if (accessLogger != null && accessLogger.isEnabled()) {
            String loggerName = accessLogger.getLoggerName();
            Predicate<String> uriInclusion = NettyHttpServer.inclusionPredicate(accessLogger);
            this.accessLogHandler = new HttpAccessLogHandler(loggerName, accessLogger.getLogFormat(), uriInclusion);
            this.accessLogManagerFactory = new Http2AccessLogManager.Factory(loggerName == null || loggerName.isEmpty() ? null : LoggerFactory.getLogger((String)loggerName), accessLogger.getLogFormat(), uriInclusion);
            routingInBoundHandler.supportLoggingHandler = true;
        } else {
            this.accessLogHandler = null;
            this.accessLogManagerFactory = null;
        }
    }

    boolean supportsSsl() {
        return this.sslContext != null || this.quicSslContext != null;
    }

    @Override
    public void close() {
        ReferenceCountUtil.release((Object)this.sslContext);
    }

    private RequestHandler makeRequestHandler(Optional<NettyServerWebSocketUpgradeHandler> webSocketUpgradeHandler, boolean ssl) {
        RequestHandler requestHandler = this.routingInBoundHandler;
        if (webSocketUpgradeHandler.isPresent()) {
            webSocketUpgradeHandler.get().setNext(this.routingInBoundHandler);
            requestHandler = webSocketUpgradeHandler.get();
        }
        if (this.server.getServerConfiguration().isDualProtocol() && this.server.getServerConfiguration().isHttpToHttpsRedirect() && !ssl) {
            requestHandler = new HttpToHttpsRedirectHandler(this.routingInBoundHandler.conversionService, this.server.getServerConfiguration(), this.sslConfiguration, this.hostResolver);
        }
        return requestHandler;
    }

    private BodySizeLimits bodySizeLimits() {
        return new BodySizeLimits(this.server.getServerConfiguration().getMaxRequestSize(), this.server.getServerConfiguration().getMaxRequestBufferSize());
    }

    private static final class Http3GracefulShutdown
    extends Http23GracefulShutdownBase {
        private final AtomicLong maxStreamId;

        public Http3GracefulShutdown(ChannelHandlerContext ctx, AtomicLong maxStreamId) {
            super(ctx);
            this.maxStreamId = maxStreamId;
        }

        @Override
        protected int numberOfActiveStreams() {
            return -1;
        }

        @Override
        protected ChannelFuture goAway() {
            QuicStreamChannel controlStream = Http3.getLocalControlStream((Channel)this.ctx.channel());
            if (controlStream == null) {
                return this.ctx.close();
            }
            return controlStream.writeAndFlush((Object)new DefaultHttp3GoAwayFrame(this.maxStreamId.get() + 4L));
        }
    }

    private static final class Http2GracefulShutdown
    extends Http23GracefulShutdownBase {
        private final Http2ConnectionHandler connectionHandler;

        public Http2GracefulShutdown(ChannelHandlerContext ctx, Http2ConnectionHandler connectionHandler) {
            super(ctx);
            this.connectionHandler = connectionHandler;
        }

        @Override
        protected int numberOfActiveStreams() {
            return this.connectionHandler.connection().numActiveStreams();
        }

        @Override
        protected ChannelFuture goAway() {
            return this.connectionHandler.goAway(this.ctx, this.connectionHandler.connection().remote().lastStreamCreated(), Http2Error.NO_ERROR.code(), Unpooled.EMPTY_BUFFER, this.ctx.newPromise());
        }
    }

    private static abstract class Http23GracefulShutdownBase
    implements GracefulShutdownCapable {
        final ChannelHandlerContext ctx;

        Http23GracefulShutdownBase(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public OptionalLong reportActiveTasks() {
            return OptionalLong.of(1L);
        }

        public CompletionStage<?> shutdownGracefully() {
            if (this.ctx.executor().inEventLoop()) {
                this.shutdownGracefully0();
            } else {
                this.ctx.executor().execute(this::shutdownGracefully0);
            }
            return NettyHttpServer.toCompletionStage(this.ctx.channel().closeFuture());
        }

        private void shutdownGracefully0() {
            this.goAway().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess()) {
                    this.ctx.close();
                }
            }));
            this.ctx.flush();
        }

        protected abstract int numberOfActiveStreams();

        protected abstract ChannelFuture goAway();
    }

    final class StreamPipeline {
        HttpVersion httpVersion = HttpVersion.HTTP_1_1;
        private final Channel channel;
        private final ChannelPipeline pipeline;
        @Nullable
        private final SslHandlerHolder sslHandler;
        private final NettyServerCustomizer streamCustomizer;

        private StreamPipeline(@Nullable Channel channel, SslHandlerHolder sslHandler, NettyServerCustomizer streamCustomizer) {
            this.channel = channel;
            this.pipeline = channel.pipeline();
            this.sslHandler = sslHandler;
            this.streamCustomizer = streamCustomizer;
        }

        void initializeChildPipelineForPushPromise(Channel childChannel) {
            StreamPipeline promisePipeline = new StreamPipeline(childChannel, this.sslHandler, this.streamCustomizer.specializeForChannel(childChannel, NettyServerCustomizer.ChannelRole.PUSH_PROMISE_STREAM));
            promisePipeline.insertHttp2FrameHandlers();
            promisePipeline.streamCustomizer.onStreamPipelineBuilt();
        }

        private void insertHttp2FrameHandlers() {
            this.pipeline.addLast("http-decoder", (ChannelHandler)new Http2StreamFrameToHttpObjectCodec(true, HttpPipelineBuilder.this.server.getServerConfiguration().isValidateHeaders()));
            this.insertHttp2DownstreamHandlers();
        }

        private void insertHttp3FrameHandlers() {
            this.pipeline.addLast("http-decoder", (ChannelHandler)new Http3FrameToHttpObjectCodec(true, HttpPipelineBuilder.this.server.getServerConfiguration().isValidateHeaders()));
            this.insertHttp2DownstreamHandlers();
        }

        private void insertHttp2DownstreamHandlers() {
            this.httpVersion = HttpVersion.HTTP_2_0;
            this.pipeline.addLast("flow-control-handler", (ChannelHandler)new FlowControlHandler());
            if (HttpPipelineBuilder.this.accessLogHandler != null) {
                this.pipeline.addLast("http-access-logger", (ChannelHandler)HttpPipelineBuilder.this.accessLogHandler);
            }
            this.registerMicronautChannelHandlers();
            this.insertMicronautHandlers();
        }

        private GracefulShutdownCapable insertMicronautHandlers() {
            Optional<NettyServerWebSocketUpgradeHandler> webSocketUpgradeHandler;
            this.channel.attr(STREAM_PIPELINE_ATTRIBUTE.get()).set((Object)this);
            if (this.sslHandler != null) {
                this.channel.attr(SSL_SESSION_ATTRIBUTE.get()).set(this.sslHandler.findSslSession());
            }
            if ((webSocketUpgradeHandler = HttpPipelineBuilder.this.embeddedServices.getWebSocketUpgradeHandler(HttpPipelineBuilder.this.server)).isPresent()) {
                this.pipeline.addLast("WebSocketServerCompressionHandler", (ChannelHandler)new WebSocketServerCompressionHandler());
            }
            if (HttpPipelineBuilder.this.server.getServerConfiguration().getServerType() != NettyHttpServerConfiguration.HttpServerType.STREAMED) {
                this.pipeline.addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator((int)HttpPipelineBuilder.this.server.getServerConfiguration().getMaxRequestSize(), HttpPipelineBuilder.this.server.getServerConfiguration().isCloseOnExpectationFailed()));
            }
            RequestHandler requestHandler = HttpPipelineBuilder.this.makeRequestHandler(webSocketUpgradeHandler, this.sslHandler != null);
            PipeliningServerHandler pipeliningServerHandler = new PipeliningServerHandler(requestHandler);
            pipeliningServerHandler.setCompressionStrategy(HttpPipelineBuilder.this.embeddedServices.getHttpCompressionStrategy());
            pipeliningServerHandler.setBodySizeLimits(HttpPipelineBuilder.this.bodySizeLimits());
            this.pipeline.addLast("micronaut-inbound-handler", (ChannelHandler)pipeliningServerHandler);
            return pipeliningServerHandler;
        }

        void afterHttp2ServerHandlerSetUp() {
            this.httpVersion = HttpVersion.HTTP_2_0;
            this.channel.attr(STREAM_PIPELINE_ATTRIBUTE.get()).set((Object)this);
            if (this.sslHandler != null) {
                this.channel.attr(SSL_SESSION_ATTRIBUTE.get()).set(this.sslHandler.findSslSession());
            }
        }

        private GracefulShutdownCapable insertHttp1DownstreamHandlers() {
            this.httpVersion = HttpVersion.HTTP_1_1;
            if (HttpPipelineBuilder.this.accessLogHandler != null) {
                this.pipeline.addLast("http-access-logger", (ChannelHandler)HttpPipelineBuilder.this.accessLogHandler);
            }
            this.registerMicronautChannelHandlers();
            return this.insertMicronautHandlers();
        }

        private void registerMicronautChannelHandlers() {
            int i = 0;
            for (ChannelOutboundHandler outboundHandlerAdapter : HttpPipelineBuilder.this.embeddedServices.getOutboundHandlers()) {
                Object name;
                if (outboundHandlerAdapter instanceof Named) {
                    Named named = (Named)outboundHandlerAdapter;
                    name = named.getName();
                } else {
                    name = "micronaut-inbound-handler-outbound-" + ++i;
                }
                this.pipeline.addLast((String)name, (ChannelHandler)outboundHandlerAdapter);
            }
        }
    }

    final class ConnectionPipeline
    implements GracefulShutdownCapable {
        final Channel channel;
        private final ChannelPipeline pipeline;
        @Nullable
        private final SslHandlerHolder sslHandler;
        private final NettyServerCustomizer connectionCustomizer;
        private volatile GracefulShutdownCapable specificGracefulShutdown;

        ConnectionPipeline(Channel channel, boolean https) {
            this.channel = channel;
            this.pipeline = channel.pipeline();
            this.sslHandler = https ? new SslHandlerHolder() : null;
            this.connectionCustomizer = HttpPipelineBuilder.this.serverCustomizer.specializeForChannel(channel, NettyServerCustomizer.ChannelRole.CONNECTION);
        }

        void insertPcapLoggingHandler(Channel ch, String qualifier) {
            String pattern = HttpPipelineBuilder.this.server.getServerConfiguration().getPcapLoggingPathPattern();
            if (pattern == null) {
                return;
            }
            String path = pattern;
            path = path.replace("{qualifier}", qualifier);
            if (ch.localAddress() != null) {
                path = path.replace("{localAddress}", this.resolveIfNecessary(ch.localAddress()));
            }
            if (ch.remoteAddress() != null) {
                path = path.replace("{remoteAddress}", this.resolveIfNecessary(ch.remoteAddress()));
            }
            if (HttpPipelineBuilder.this.quic && ch instanceof QuicStreamChannel) {
                QuicStreamChannel qsc = (QuicStreamChannel)ch;
                path = path.replace("{localAddress}", this.resolveIfNecessary(qsc.parent().localSocketAddress()));
                path = path.replace("{remoteAddress}", this.resolveIfNecessary(qsc.parent().remoteSocketAddress()));
            }
            path = path.replace("{random}", Long.toHexString(ThreadLocalRandom.current().nextLong()));
            path = path.replace("{timestamp}", Instant.now().toString());
            path = path.replace(':', '_');
            LOG.warn("Logging *full* request data, as configured. This will contain sensitive information! Path: '{}'", (Object)path);
            try {
                PcapWriteHandler.Builder builder = PcapWriteHandler.builder();
                if (HttpPipelineBuilder.this.quic && ch instanceof QuicStreamChannel) {
                    QuicStreamChannel qsc = (QuicStreamChannel)ch;
                    builder.forceTcpChannel((InetSocketAddress)qsc.parent().localSocketAddress(), (InetSocketAddress)qsc.parent().remoteSocketAddress(), true);
                }
                ch.pipeline().addLast(new ChannelHandler[]{builder.build((OutputStream)new FileOutputStream(path))});
            }
            catch (FileNotFoundException e) {
                LOG.warn("Failed to create target pcap at '{}', not logging.", (Object)path, (Object)e);
            }
        }

        private String resolveIfNecessary(SocketAddress address) {
            if (address instanceof InetSocketAddress) {
                InetSocketAddress socketAddress = (InetSocketAddress)address;
                if (socketAddress.isUnresolved() && (socketAddress = new InetSocketAddress(socketAddress.getHostString(), socketAddress.getPort())).isUnresolved()) {
                    return "unresolved";
                }
                return socketAddress.getAddress().getHostAddress() + ":" + socketAddress.getPort();
            }
            String s = address.toString();
            if (s.contains("/")) {
                return "weird";
            }
            return s;
        }

        void initChannel() {
            this.insertOuterTcpHandlers();
            if (HttpPipelineBuilder.this.server.getServerConfiguration().getHttpVersion() != HttpVersion.HTTP_2_0) {
                this.configureForHttp1();
            } else if (this.sslHandler != null) {
                this.configureForAlpn();
            } else {
                this.configureForH2cSupport();
            }
        }

        void initHttp3Channel() {
            this.insertPcapLoggingHandler(this.channel, "udp-encapsulated");
            final ConcurrentHashMap.KeySetView activeChannels = ConcurrentHashMap.newKeySet();
            final AtomicBoolean shuttingDown = new AtomicBoolean(false);
            this.pipeline.addLast(new ChannelHandler[]{((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)Http3.newQuicServerCodecBuilder().sslEngineProvider(QuicFactory.quicEngineFactory(this.sslHandler))).initialMaxData((long)HttpPipelineBuilder.this.server.getServerConfiguration().getHttp3().getInitialMaxData())).initialMaxStreamDataBidirectionalLocal((long)HttpPipelineBuilder.this.server.getServerConfiguration().getHttp3().getInitialMaxStreamDataBidirectionalLocal())).initialMaxStreamDataBidirectionalRemote((long)HttpPipelineBuilder.this.server.getServerConfiguration().getHttp3().getInitialMaxStreamDataBidirectionalRemote())).initialMaxStreamsBidirectional((long)HttpPipelineBuilder.this.server.getServerConfiguration().getHttp3().getInitialMaxStreamsBidirectional())).tokenHandler(QuicTokenHandlerImpl.create(this.channel.alloc())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(@NonNull Channel ch) throws Exception {
                    if (shuttingDown.get()) {
                        ch.close();
                        return;
                    }
                    final AtomicLong maxStreamId = new AtomicLong();
                    ConnectionPipeline.this.insertPcapLoggingHandler(ch, "quic-decapsulated");
                    Http3ServerConnectionHandler connectionHandler = new Http3ServerConnectionHandler((ChannelHandler)new ChannelInitializer<QuicStreamChannel>(){

                        protected void initChannel(@NonNull QuicStreamChannel ch) throws Exception {
                            long m;
                            while ((m = maxStreamId.get()) < ch.streamId() && !maxStreamId.compareAndSet(m, ch.streamId())) {
                            }
                            ch.config().setAutoRead(false);
                            StreamPipeline streamPipeline = new StreamPipeline((Channel)ch, ConnectionPipeline.this.sslHandler, ConnectionPipeline.this.connectionCustomizer.specializeForChannel((Channel)ch, NettyServerCustomizer.ChannelRole.REQUEST_STREAM));
                            streamPipeline.insertHttp3FrameHandlers();
                            streamPipeline.streamCustomizer.onStreamPipelineBuilt();
                        }
                    }, (ChannelHandler)new ChannelInitializer<QuicStreamChannel>(){

                        protected void initChannel(@NonNull QuicStreamChannel ch) throws Exception {
                        }
                    }, null, null, true);
                    ch.pipeline().addLast(new ChannelHandler[]{connectionHandler});
                    Http3GracefulShutdown gracefulShutdown = new Http3GracefulShutdown(ch.pipeline().lastContext(), maxStreamId);
                    activeChannels.add(gracefulShutdown);
                    ch.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> activeChannels.remove(gracefulShutdown)));
                }
            }).build()});
            this.specificGracefulShutdown = new GracefulShutdownCapable(){

                @NonNull
                public CompletionStage<?> shutdownGracefully() {
                    shuttingDown.set(true);
                    return GracefulShutdownCapable.shutdownAll(activeChannels.stream());
                }

                public OptionalLong reportActiveTasks() {
                    return GracefulShutdownCapable.combineActiveTasks((Iterable)activeChannels);
                }
            };
        }

        void insertOuterTcpHandlers() {
            this.insertPcapLoggingHandler(this.channel, "encapsulated");
            if (this.sslHandler != null) {
                this.pipeline.addLast("ssl", (ChannelHandler)this.sslHandler.makeNormal(this.channel.alloc()));
                this.insertPcapLoggingHandler(this.channel, "ssl-decapsulated");
            }
            if (HttpPipelineBuilder.this.loggingHandler != null) {
                this.pipeline.addLast(new ChannelHandler[]{HttpPipelineBuilder.this.loggingHandler});
            }
        }

        private void onRequestPipelineBuilt() {
            HttpPipelineBuilder.this.server.triggerPipelineListeners(this.pipeline);
        }

        private void insertIdleStateHandler() {
            Duration idleTime = HttpPipelineBuilder.this.server.getServerConfiguration().getIdleTimeout();
            if (!idleTime.isNegative()) {
                this.pipeline.addLast("idle-state", (ChannelHandler)new IdleStateHandler((int)HttpPipelineBuilder.this.server.getServerConfiguration().getReadIdleTimeout().getSeconds(), (int)HttpPipelineBuilder.this.server.getServerConfiguration().getWriteIdleTimeout().getSeconds(), (int)idleTime.getSeconds()));
            }
        }

        void configureForHttp1() {
            this.insertIdleStateHandler();
            this.pipeline.addLast("http-server-codec", (ChannelHandler)this.createServerCodec());
            this.specificGracefulShutdown = new StreamPipeline(this.channel, this.sslHandler, this.connectionCustomizer).insertHttp1DownstreamHandlers();
            this.connectionCustomizer.onInitialPipelineBuilt();
            this.connectionCustomizer.onStreamPipelineBuilt();
            this.onRequestPipelineBuilt();
        }

        private void configureForHttp2() {
            this.insertIdleStateHandler();
            boolean legacyMultiplexHandlers = HttpPipelineBuilder.this.routingInBoundHandler.serverConfiguration.isLegacyMultiplexHandlers();
            if (legacyMultiplexHandlers) {
                Http2FrameCodec http2FrameCodec = this.createHttp2FrameCodec();
                this.pipeline.addLast("http2-connection", (ChannelHandler)http2FrameCodec);
                this.specificGracefulShutdown = new Http2GracefulShutdown(this.pipeline.lastContext(), (Http2ConnectionHandler)http2FrameCodec);
                this.pipeline.addLast(new ChannelHandler[]{this.makeHttp2Handler()});
            } else {
                Http2ConnectionHandler http2ServerHandler = this.createHttp2ServerHandler(true);
                this.pipeline.addLast("http2-connection", (ChannelHandler)http2ServerHandler);
                this.specificGracefulShutdown = new Http2GracefulShutdown(this.pipeline.lastContext(), http2ServerHandler);
            }
            this.connectionCustomizer.onInitialPipelineBuilt();
            this.onRequestPipelineBuilt();
            if (!legacyMultiplexHandlers) {
                new StreamPipeline(this.channel, this.sslHandler, this.connectionCustomizer).afterHttp2ServerHandlerSetUp();
            }
        }

        private Http2FrameCodec createHttp2FrameCodec() {
            Http2FrameCodecBuilder builder = Http2FrameCodecBuilder.forServer().validateHeaders(HttpPipelineBuilder.this.server.getServerConfiguration().isValidateHeaders()).initialSettings(HttpPipelineBuilder.this.server.getServerConfiguration().getHttp2().http2Settings());
            HttpPipelineBuilder.this.server.getServerConfiguration().getLogLevel().ifPresent(logLevel -> builder.frameLogger(new Http2FrameLogger(logLevel, NettyHttpServer.class)));
            return builder.build();
        }

        private Http2ConnectionHandler createHttp2ServerHandler(boolean ssl) {
            Http2ServerHandler.ConnectionHandlerBuilder builder = new Http2ServerHandler.ConnectionHandlerBuilder(HttpPipelineBuilder.this.makeRequestHandler(HttpPipelineBuilder.this.embeddedServices.getWebSocketUpgradeHandler(HttpPipelineBuilder.this.server), ssl)).compressor(HttpPipelineBuilder.this.embeddedServices.getHttpCompressionStrategy()).bodySizeLimits(HttpPipelineBuilder.this.bodySizeLimits()).accessLogManagerFactory(HttpPipelineBuilder.this.accessLogManagerFactory).validateHeaders(HttpPipelineBuilder.this.server.getServerConfiguration().isValidateHeaders()).initialSettings(HttpPipelineBuilder.this.server.getServerConfiguration().getHttp2().http2Settings());
            HttpPipelineBuilder.this.server.getServerConfiguration().getLogLevel().ifPresent(logLevel -> builder.frameLogger(new Http2FrameLogger(logLevel, NettyHttpServer.class)));
            return builder.build();
        }

        void configureForAlpn() {
            this.pipeline.addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler(HttpPipelineBuilder.this.server.getServerConfiguration().getFallbackProtocol()){

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    if (HttpPipelineBuilder.this.routingInBoundHandler.isIgnorable(cause)) {
                        ctx.close();
                    } else {
                        super.exceptionCaught(ctx, cause);
                    }
                }

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    SslHandshakeCompletionEvent event;
                    if (evt instanceof SslHandshakeCompletionEvent && !(event = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                        Throwable cause = event.cause();
                        if (!(cause instanceof ClosedChannelException)) {
                            super.userEventTriggered(ctx, evt);
                        } else {
                            return;
                        }
                    }
                    super.userEventTriggered(ctx, evt);
                }

                protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                    switch (protocol) {
                        case "h2": {
                            ConnectionPipeline.this.configureForHttp2();
                            break;
                        }
                        case "http/1.1": {
                            ConnectionPipeline.this.configureForHttp1();
                            break;
                        }
                        default: {
                            LOG.warn("Negotiated unknown ALPN protocol. Is the fallback protocol configured correctly? Falling back on HTTP 1");
                            ConnectionPipeline.this.configureForHttp1();
                        }
                    }
                    ctx.read();
                }
            }});
        }

        void configureForH2cSupport() {
            Http2MultiplexHandler multiplexHandler;
            Http2ConnectionHandler connectionHandler;
            Http2FrameCodec frameCodec;
            this.insertIdleStateHandler();
            if (HttpPipelineBuilder.this.server.getServerConfiguration().isLegacyMultiplexHandlers()) {
                frameCodec = this.createHttp2FrameCodec();
                connectionHandler = frameCodec;
                multiplexHandler = new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Http2StreamChannel>(){

                    protected void initChannel(@NonNull Http2StreamChannel ch) {
                        StreamPipeline streamPipeline = new StreamPipeline((Channel)ch, ConnectionPipeline.this.sslHandler, ConnectionPipeline.this.connectionCustomizer.specializeForChannel((Channel)ch, NettyServerCustomizer.ChannelRole.REQUEST_STREAM));
                        streamPipeline.insertHttp2FrameHandlers();
                        streamPipeline.streamCustomizer.onStreamPipelineBuilt();
                    }
                });
            } else {
                connectionHandler = this.createHttp2ServerHandler(false);
                frameCodec = null;
                multiplexHandler = null;
            }
            String fallbackHandlerName = "http1-fallback-handler";
            HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = protocol -> {
                if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                    class Http2ServerUpgradeCodecImpl
                    extends Http2ServerUpgradeCodec {
                        public Http2ServerUpgradeCodecImpl(Http2ConnectionHandler connectionHandler2) {
                            super(connectionHandler2);
                        }

                        public Http2ServerUpgradeCodecImpl(Http2FrameCodec http2Codec, ChannelHandler[] handlers) {
                            super(http2Codec, handlers);
                        }

                        public void upgradeTo(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest) {
                            super.upgradeTo(ctx, upgradeRequest);
                            ConnectionPipeline.this.pipeline.remove("http1-fallback-handler");
                            new StreamPipeline(ConnectionPipeline.this.channel, ConnectionPipeline.this.sslHandler, ConnectionPipeline.this.connectionCustomizer).afterHttp2ServerHandlerSetUp();
                            ConnectionPipeline.this.specificGracefulShutdown = new Http2GracefulShutdown(ctx.pipeline().context((ChannelHandler)connectionHandler), connectionHandler);
                            ConnectionPipeline.this.onRequestPipelineBuilt();
                        }
                    }
                    if (frameCodec == null) {
                        return new Http2ServerUpgradeCodecImpl(connectionHandler);
                    }
                    return new Http2ServerUpgradeCodecImpl(frameCodec, new ChannelHandler[]{multiplexHandler});
                }
                return null;
            };
            HttpServerCodec sourceCodec = this.createServerCodec();
            final HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, upgradeCodecFactory, HttpPipelineBuilder.this.server.getServerConfiguration().getMaxH2cUpgradeRequestSize());
            Object priorKnowledgeHandler = frameCodec == null ? connectionHandler : new ChannelInitializer<Channel>(){

                protected void initChannel(@NonNull Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{connectionHandler, multiplexHandler});
                }
            };
            CleartextHttp2ServerUpgradeHandler cleartextHttp2ServerUpgradeHandler = new CleartextHttp2ServerUpgradeHandler(sourceCodec, upgradeHandler, (ChannelHandler)priorKnowledgeHandler);
            this.pipeline.addLast(new ChannelHandler[]{cleartextHttp2ServerUpgradeHandler});
            this.pipeline.addLast("http1-fallback-handler", (ChannelHandler)new SimpleChannelInboundHandler<HttpMessage>(){

                protected void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) {
                    ChannelPipeline cp = ctx.pipeline();
                    cp.remove((ChannelHandler)upgradeHandler);
                    cp.remove((ChannelHandler)this);
                    ConnectionPipeline.this.specificGracefulShutdown = new StreamPipeline(ConnectionPipeline.this.channel, ConnectionPipeline.this.sslHandler, ConnectionPipeline.this.connectionCustomizer).insertHttp1DownstreamHandlers();
                    ConnectionPipeline.this.connectionCustomizer.onStreamPipelineBuilt();
                    ConnectionPipeline.this.onRequestPipelineBuilt();
                    cp.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
                }
            });
            this.pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                    HttpPipelineBuilder.this.makeRequestHandler(Optional.empty(), false).handleUnboundError(cause);
                }
            }});
            this.connectionCustomizer.onInitialPipelineBuilt();
        }

        @NonNull
        private Http2MultiplexHandler makeHttp2Handler() {
            return new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(@NonNull Channel ch) {
                    StreamPipeline streamPipeline = new StreamPipeline(ch, ConnectionPipeline.this.sslHandler, ConnectionPipeline.this.connectionCustomizer.specializeForChannel(ch, NettyServerCustomizer.ChannelRole.REQUEST_STREAM));
                    streamPipeline.insertHttp2FrameHandlers();
                    streamPipeline.streamCustomizer.onStreamPipelineBuilt();
                }
            });
        }

        @NonNull
        private HttpServerCodec createServerCodec() {
            return new HttpServerCodec(HttpPipelineBuilder.this.server.getServerConfiguration().getMaxInitialLineLength(), HttpPipelineBuilder.this.server.getServerConfiguration().getMaxHeaderSize(), HttpPipelineBuilder.this.server.getServerConfiguration().getMaxChunkSize(), HttpPipelineBuilder.this.server.getServerConfiguration().isValidateHeaders(), HttpPipelineBuilder.this.server.getServerConfiguration().getInitialBufferSize());
        }

        public CompletionStage<?> shutdownGracefully() {
            GracefulShutdownCapable specificGracefulShutdown = this.specificGracefulShutdown;
            if (specificGracefulShutdown == null) {
                return NettyHttpServer.toCompletionStage(this.channel.close());
            }
            return specificGracefulShutdown.shutdownGracefully();
        }

        public OptionalLong reportActiveTasks() {
            GracefulShutdownCapable specificGracefulShutdown = this.specificGracefulShutdown;
            if (specificGracefulShutdown == null) {
                return OptionalLong.of(1L);
            }
            return specificGracefulShutdown.reportActiveTasks();
        }
    }

    private static final class QuicFactory {
        private QuicFactory() {
        }

        static Function<QuicChannel, ? extends QuicSslEngine> quicEngineFactory(SslHandlerHolder sslHandlerHolder) {
            return q -> {
                QuicSslEngine e = sslHandlerHolder.pipelineBuilder().quicSslContext.newEngine(q.alloc());
                sslHandlerHolder.quicSslEngine = e;
                return e;
            };
        }
    }

    private final class SslHandlerHolder {
        private SslHandler sslHandler;
        private SSLEngine quicSslEngine;

        private SslHandlerHolder() {
        }

        SslHandler makeNormal(ByteBufAllocator alloc) {
            this.sslHandler = HttpPipelineBuilder.this.sslContext.newHandler(alloc);
            this.sslHandler.setHandshakeTimeoutMillis(HttpPipelineBuilder.this.sslConfiguration.getHandshakeTimeout().toMillis());
            return this.sslHandler;
        }

        Supplier<SSLSession> findSslSession() {
            return SupplierUtil.memoized(() -> (this.quicSslEngine == null ? this.sslHandler.engine() : this.quicSslEngine).getSession());
        }

        HttpPipelineBuilder pipelineBuilder() {
            return HttpPipelineBuilder.this;
        }
    }
}

