/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.subscriber.LazySendingSubscriber;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.ByteBodyHttpResponseWrapper;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.body.AvailableByteBody;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.ConcatenatingSubscriber;
import io.micronaut.http.body.stream.BodySizeLimits;
import io.micronaut.http.body.stream.BufferConsumer;
import io.micronaut.http.netty.EventLoopFlow;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.body.AvailableNettyByteBody;
import io.micronaut.http.netty.body.ByteBufConsumer;
import io.micronaut.http.netty.body.NettyBodyAdapter;
import io.micronaut.http.netty.body.NettyByteBody;
import io.micronaut.http.netty.body.NettyByteBodyFactory;
import io.micronaut.http.netty.body.StreamingNettyByteBody;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.micronaut.http.server.ResponseLifecycle;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.RoutingInBoundHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.OrderedEventExecutor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;

@Internal
final class NettyResponseLifecycle
extends ResponseLifecycle {
    private final RoutingInBoundHandler routingInBoundHandler;
    private final NettyHttpRequest<?> request;

    public NettyResponseLifecycle(RoutingInBoundHandler routingInBoundHandler, NettyHttpRequest<?> request) {
        super(routingInBoundHandler.routeExecutor, routingInBoundHandler.messageBodyHandlerRegistry, routingInBoundHandler.conversionService, (ByteBodyFactory)new NettyByteBodyFactory(request.getChannelHandlerContext().channel()));
        this.routingInBoundHandler = routingInBoundHandler;
        this.request = request;
    }

    protected Executor ioExecutor() {
        return this.routingInBoundHandler.getIoExecutor();
    }

    protected ExecutionFlow<? extends ByteBodyHttpResponse<?>> encodeNoBody(HttpResponse<?> response) {
        NettyHttpResponseBuilder builder;
        io.netty.handler.codec.http.HttpResponse nettyResponse;
        if (response instanceof NettyHttpResponseBuilder && (nettyResponse = (builder = (NettyHttpResponseBuilder)response).toHttpResponse()) instanceof StreamedHttpResponse) {
            StreamedHttpResponse streamed = (StreamedHttpResponse)nettyResponse;
            return LazySendingSubscriber.create((Publisher)streamed).map(contents -> {
                StreamingNettyByteBody body = NettyBodyAdapter.adapt((Publisher)Flux.from((Publisher)contents).map(ByteBufHolder::content), (EventLoop)this.eventLoop());
                return ByteBodyHttpResponseWrapper.wrap((HttpResponse)response, (CloseableByteBody)body);
            }).onErrorResume(e -> this.handleStreamingError(this.request, (Throwable)e));
        }
        return super.encodeNoBody(response);
    }

    private EventLoop eventLoop() {
        return this.request.getChannelHandlerContext().channel().eventLoop();
    }

    @NonNull
    protected CloseableByteBody concatenate(Publisher<ByteBody> items) {
        return NettyConcatenatingSubscriber.concatenate(this.eventLoop(), items);
    }

    @NonNull
    protected CloseableByteBody concatenateJson(Publisher<ByteBody> items) {
        return JsonNettyConcatenatingSubscriber.concatenateJson(this.eventLoop(), items);
    }

    private static class NettyConcatenatingSubscriber
    extends ConcatenatingSubscriber
    implements ByteBufConsumer {
        final StreamingNettyByteBody.SharedBuffer sharedBuffer;
        private final EventLoop eventLoop;
        private final EventLoopFlow flow;

        NettyConcatenatingSubscriber(EventLoop eventLoop) {
            this.eventLoop = eventLoop;
            this.flow = new EventLoopFlow((OrderedEventExecutor)eventLoop);
            this.sharedBuffer = new StreamingNettyByteBody.SharedBuffer(eventLoop, BodySizeLimits.UNLIMITED, (BufferConsumer.Upstream)this);
        }

        static CloseableByteBody concatenate(EventLoop eventLoop, Publisher<ByteBody> publisher) {
            NettyConcatenatingSubscriber subscriber = new NettyConcatenatingSubscriber(eventLoop);
            publisher.subscribe((Subscriber)subscriber);
            return new StreamingNettyByteBody(subscriber.sharedBuffer);
        }

        protected BufferConsumer.Upstream forward(ByteBody body) {
            NettyByteBody adapted = NettyBodyAdapter.adapt((ByteBody)body, (EventLoop)this.eventLoop);
            if (adapted instanceof StreamingNettyByteBody) {
                StreamingNettyByteBody streaming = (StreamingNettyByteBody)adapted;
                return streaming.primary((ByteBufConsumer)this);
            }
            this.add(AvailableNettyByteBody.toByteBuf((AvailableByteBody)((AvailableNettyByteBody)adapted)));
            this.complete();
            return null;
        }

        public void add(@NonNull ByteBuf buffer) {
            int n = buffer.readableBytes();
            this.onForward(n);
            this.add0(buffer);
        }

        void add0(@NonNull ByteBuf buffer) {
            if (this.flow.executeNow(() -> this.sharedBuffer.add(buffer))) {
                this.sharedBuffer.add(buffer);
            }
        }

        protected void forwardComplete() {
            if (this.flow.executeNow(() -> ((StreamingNettyByteBody.SharedBuffer)this.sharedBuffer).complete())) {
                this.sharedBuffer.complete();
            }
        }

        protected void forwardError(Throwable t) {
            if (this.flow.executeNow(() -> this.sharedBuffer.error(t))) {
                this.sharedBuffer.error(t);
            }
        }
    }

    private static final class JsonNettyConcatenatingSubscriber
    extends NettyConcatenatingSubscriber {
        private static final ByteBuf START_ARRAY = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)"[", (Charset)StandardCharsets.UTF_8)).asReadOnly();
        private static final ByteBuf END_ARRAY = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)"]", (Charset)StandardCharsets.UTF_8)).asReadOnly();
        private static final ByteBuf SEPARATOR = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)",", (Charset)StandardCharsets.UTF_8)).asReadOnly();
        private static final ByteBuf EMPTY_ARRAY = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)"[]", (Charset)StandardCharsets.UTF_8)).asReadOnly();

        JsonNettyConcatenatingSubscriber(EventLoop eventLoop) {
            super(eventLoop);
        }

        static CloseableByteBody concatenateJson(EventLoop eventLoop, Publisher<ByteBody> publisher) {
            JsonNettyConcatenatingSubscriber subscriber = new JsonNettyConcatenatingSubscriber(eventLoop);
            publisher.subscribe((Subscriber)subscriber);
            return new StreamingNettyByteBody(subscriber.sharedBuffer);
        }

        protected long emitLeadingSeparator(boolean first) {
            this.add0((first ? START_ARRAY : SEPARATOR).duplicate());
            return 1L;
        }

        protected long emitFinalSeparator(boolean first) {
            this.add0((first ? EMPTY_ARRAY : END_ARRAY).duplicate());
            return first ? 2L : 1L;
        }
    }
}

