/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.DelegateByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.FullHttpRequest;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpParameters;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.PushCapableHttpRequest;
import io.micronaut.http.ServerHttpRequest;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.InternalByteBody;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.NettyHttpParameters;
import io.micronaut.http.netty.NettyHttpRequestBuilder;
import io.micronaut.http.netty.body.AvailableNettyByteBody;
import io.micronaut.http.netty.body.NettyByteBody;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.micronaut.http.netty.cookies.NettyCookies;
import io.micronaut.http.netty.stream.DefaultStreamedHttpRequest;
import io.micronaut.http.netty.stream.DelegateStreamedHttpRequest;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.AbstractNettyHttpRequest;
import io.micronaut.http.server.netty.FormRouteCompleter;
import io.micronaut.http.server.netty.HttpPipelineBuilder;
import io.micronaut.http.server.netty.handler.Http2ServerHandler;
import io.micronaut.http.server.netty.multipart.NettyCompletedFileUpload;
import io.micronaut.web.router.DefaultUriRouteMatch;
import io.micronaut.web.router.RouteAttributes;
import io.micronaut.web.router.RouteMatch;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http2.DefaultHttp2PushPromiseFrame;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.net.ssl.SSLSession;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class NettyHttpRequest<T>
extends AbstractNettyHttpRequest<T>
implements HttpRequest<T>,
PushCapableHttpRequest<T>,
FullHttpRequest<T>,
ServerHttpRequest<T> {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpRequest.class);
    private static final io.netty.handler.codec.http.HttpHeaders SERVER_PUSH_EXCLUDE_HEADERS = new DefaultHttpHeaders();
    @Internal
    public ArgumentBinder.BindingResult<ConvertibleValues<?>> convertibleBody;
    private final NettyHttpHeaders headers;
    private final ChannelHandlerContext channelHandlerContext;
    private final HttpServerConfiguration serverConfiguration;
    private MutableConvertibleValues<Object> attributes;
    private NettyCookies nettyCookies;
    private final CloseableByteBody body;
    @Nullable
    private FormRouteCompleter formRouteCompleter;
    private ExecutionFlow<?> routeWaitsFor = ExecutionFlow.just(null);
    private Object legacyBody;
    private final BodyConvertor bodyConvertor = this.newBodyConvertor();

    public NettyHttpRequest(io.netty.handler.codec.http.HttpRequest nettyRequest, CloseableByteBody body, ChannelHandlerContext ctx, ConversionService environment, HttpServerConfiguration serverConfiguration) throws IllegalArgumentException {
        super(nettyRequest, environment, serverConfiguration.isEscapeHtmlUrl());
        Objects.requireNonNull(nettyRequest, "Netty request cannot be null");
        Objects.requireNonNull(ctx, "ChannelHandlerContext cannot be null");
        Objects.requireNonNull(environment, "Environment cannot be null");
        this.serverConfiguration = serverConfiguration;
        this.channelHandlerContext = ctx;
        this.headers = new NettyHttpHeaders(nettyRequest.headers(), this.conversionService);
        this.body = body;
    }

    public ByteBody byteBody() {
        return this.body;
    }

    public void setLegacyBody(Object legacyBody) {
        this.legacyBody = legacyBody;
    }

    public void addRouteWaitsFor(ExecutionFlow<?> executionFlow) {
        this.routeWaitsFor = this.routeWaitsFor.then(() -> executionFlow);
    }

    public ExecutionFlow<?> getRouteWaitsFor() {
        return this.routeWaitsFor;
    }

    public FormRouteCompleter formRouteCompleter() {
        assert (this.isFormOrMultipartData());
        if (this.formRouteCompleter == null) {
            this.formRouteCompleter = new FormRouteCompleter((RouteMatch)RouteAttributes.getRouteMatch((HttpRequest)this).get(), this.getChannelHandlerContext().channel().eventLoop());
        }
        return this.formRouteCompleter;
    }

    public boolean hasFormRouteCompleter() {
        return this.formRouteCompleter != null;
    }

    public MutableHttpRequest<T> mutate() {
        return new NettyMutableHttpRequest();
    }

    @NonNull
    public Optional<Object> getAttribute(CharSequence name) {
        return Optional.ofNullable(this.getAttributes().getValue((CharSequence)Objects.requireNonNull(name, "Name cannot be null").toString()));
    }

    public HttpVersion getHttpVersion() {
        HttpPipelineBuilder.StreamPipeline pipeline = (HttpPipelineBuilder.StreamPipeline)this.channelHandlerContext.channel().attr(HttpPipelineBuilder.STREAM_PIPELINE_ATTRIBUTE.get()).get();
        if (pipeline != null) {
            return pipeline.httpVersion;
        }
        return this.findConnectionHandler() == null ? HttpVersion.HTTP_1_1 : HttpVersion.HTTP_2_0;
    }

    public String toString() {
        return this.getMethodName() + " " + String.valueOf(this.getUri());
    }

    public io.netty.handler.codec.http.HttpRequest getNativeRequest() {
        return this.nettyRequest;
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.channelHandlerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookies getCookies() {
        NettyCookies cookies = this.nettyCookies;
        if (cookies == null) {
            NettyHttpRequest nettyHttpRequest = this;
            synchronized (nettyHttpRequest) {
                cookies = this.nettyCookies;
                if (cookies == null) {
                    this.nettyCookies = cookies = new NettyCookies(this.getPath(), this.headers.getNettyHeaders(), this.conversionService);
                }
            }
        }
        return cookies;
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.getChannelHandlerContext().channel().remoteAddress();
    }

    public InetSocketAddress getServerAddress() {
        return (InetSocketAddress)this.getChannelHandlerContext().channel().localAddress();
    }

    public String getServerName() {
        return this.getServerAddress().getHostName();
    }

    public boolean isSecure() {
        ChannelHandlerContext channelHandlerContext = this.getChannelHandlerContext();
        return channelHandlerContext.pipeline().get(SslHandler.class) != null;
    }

    public Optional<String> getOrigin() {
        return this.headers.getOrigin();
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap attributes = this.attributes;
        if (attributes == null) {
            NettyHttpRequest nettyHttpRequest = this;
            synchronized (nettyHttpRequest) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = new MutableConvertibleValuesMap(new HashMap(8));
                }
            }
        }
        return attributes;
    }

    public HttpRequest<T> setAttribute(CharSequence name, Object value) {
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            if (value == null) {
                this.getAttributes().remove((CharSequence)name.toString());
            } else {
                this.getAttributes().put((CharSequence)name.toString(), value);
            }
        }
        return this;
    }

    public Optional<SSLSession> getSslSession() {
        Supplier sup = (Supplier)this.channelHandlerContext.channel().attr(HttpPipelineBuilder.SSL_SESSION_ATTRIBUTE.get()).get();
        return sup == null ? Optional.empty() : Optional.ofNullable((SSLSession)sup.get());
    }

    public Optional<T> getBody() {
        if (this.hasFormRouteCompleter()) {
            return Optional.of(this.formRouteCompleter().asMap(this.serverConfiguration.getDefaultCharset()));
        }
        return Optional.ofNullable(this.legacyBody);
    }

    public <T1> Optional<T1> getBody(Class<T1> type) {
        return this.getBody(Argument.of(type));
    }

    public <T1> Optional<T1> getBody(ArgumentConversionContext<T1> conversionContext) {
        return this.getBody().flatMap(t -> this.bodyConvertor.convert(conversionContext, t));
    }

    @Internal
    public void release() {
        this.body.close();
        if (this.formRouteCompleter != null) {
            this.formRouteCompleter.release();
        }
        if (this.attributes != null) {
            this.attributes.forEach(NettyHttpRequest::cleanup);
        }
    }

    private static void cleanup(String k, Object v) {
        if (k == HttpAttributes.ROUTE_MATCH.toString()) {
            RouteMatch routeMatch;
            if (v instanceof DefaultUriRouteMatch) {
                DefaultUriRouteMatch urm = (DefaultUriRouteMatch)v;
                v0 = urm;
            } else {
                v0 = routeMatch = (RouteMatch)v;
            }
            if (routeMatch != null) {
                for (Object toDiscard : routeMatch.getVariableValues().values()) {
                    io.micronaut.core.io.buffer.ReferenceCounted rc;
                    if (toDiscard instanceof io.micronaut.core.io.buffer.ReferenceCounted) {
                        rc = (io.micronaut.core.io.buffer.ReferenceCounted)toDiscard;
                        rc.release();
                    }
                    if (toDiscard instanceof ReferenceCounted) {
                        rc = (ReferenceCounted)toDiscard;
                        rc.release();
                    }
                    if (!(toDiscard instanceof NettyCompletedFileUpload)) continue;
                    NettyCompletedFileUpload fu = (NettyCompletedFileUpload)toDiscard;
                    fu.discard();
                }
            }
            return;
        }
        if (k == HttpAttributes.ROUTE_INFO.toString() || v instanceof String) {
            return;
        }
        NettyHttpRequest.releaseIfNecessary(v);
    }

    private static void releaseIfNecessary(Object value) {
        ReferenceCounted referenceCounted;
        int i;
        if (value instanceof ReferenceCounted && (i = (referenceCounted = (ReferenceCounted)value).refCnt()) != 0) {
            referenceCounted.release();
        }
    }

    @Nullable
    private ChannelHandlerContext findConnectionHandler() {
        ChannelHandlerContext current = this.channelHandlerContext.pipeline().context(Http2ConnectionHandler.class);
        if (current != null) {
            return current;
        }
        Channel parentChannel = this.channelHandlerContext.channel().parent();
        if (parentChannel != null) {
            return parentChannel.pipeline().context(Http2FrameCodec.class);
        }
        return null;
    }

    public boolean isServerPushSupported() {
        ChannelHandlerContext http2ConnectionHandlerContext = this.findConnectionHandler();
        return http2ConnectionHandlerContext != null && ((Http2ConnectionHandler)http2ConnectionHandlerContext.handler()).connection().remote().allowPushTo();
    }

    public PushCapableHttpRequest<T> serverPush(@NonNull HttpRequest<?> request) {
        ChannelHandlerContext connectionHandlerContext = this.findConnectionHandler();
        if (connectionHandlerContext != null) {
            URI fixedUri;
            String path;
            String authority;
            Http2ConnectionHandler connectionHandler = (Http2ConnectionHandler)connectionHandlerContext.handler();
            if (!connectionHandler.connection().remote().allowPushTo()) {
                throw new UnsupportedOperationException("Server push not supported by this client: Client is HTTP2 but does not report support for this feature");
            }
            URI configuredUri = request.getUri();
            String scheme = configuredUri.getScheme();
            if (scheme == null) {
                String string = scheme = connectionHandlerContext.channel().pipeline().get(SslHandler.class) == null ? "http" : "https";
            }
            if ((authority = configuredUri.getAuthority()) == null) {
                authority = (String)this.getHeaders().get((CharSequence)"Host");
            }
            if ((path = configuredUri.getPath()) == null || !path.startsWith("/")) {
                throw new IllegalArgumentException("Request must have an absolute path");
            }
            String query = configuredUri.getQuery();
            String fragment = configuredUri.getFragment();
            try {
                fixedUri = new URI(scheme, authority, path, query, fragment);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Illegal URI", e);
            }
            io.netty.handler.codec.http.HttpRequest inboundRequestNoBody = NettyHttpRequestBuilder.asBuilder(request).toHttpRequestWithoutBody();
            DefaultFullHttpRequest inboundRequest = new DefaultFullHttpRequest(inboundRequestNoBody.protocolVersion(), inboundRequestNoBody.method(), inboundRequestNoBody.uri(), Unpooled.EMPTY_BUFFER, inboundRequestNoBody.headers(), (io.netty.handler.codec.http.HttpHeaders)EmptyHttpHeaders.INSTANCE);
            Iterator itr = this.headers.getNettyHeaders().iteratorCharSequence();
            while (itr.hasNext()) {
                Map.Entry entry = (Map.Entry)itr.next();
                if (inboundRequest.headers().contains((CharSequence)entry.getKey()) || SERVER_PUSH_EXCLUDE_HEADERS.contains((CharSequence)entry.getKey())) continue;
                inboundRequest.headers().add((CharSequence)entry.getKey(), entry.getValue());
            }
            if (!inboundRequest.headers().contains((CharSequence)HttpHeaderNames.REFERER)) {
                inboundRequest.headers().add((CharSequence)HttpHeaderNames.REFERER, (Object)this.getUri().toString());
            }
            DefaultHttpRequest outboundRequest = new DefaultHttpRequest(inboundRequest.protocolVersion(), inboundRequest.method(), fixedUri.toString(), inboundRequest.headers());
            final Http2Headers outboundHeaders = HttpConversionUtil.toHttp2Headers((HttpMessage)outboundRequest, (boolean)false);
            Channel channel = this.channelHandlerContext.channel();
            if (channel instanceof Http2StreamChannel) {
                Http2StreamChannel streamChannel = (Http2StreamChannel)channel;
                int ourStream = streamChannel.stream().id();
                final HttpPipelineBuilder.StreamPipeline originalStreamPipeline = (HttpPipelineBuilder.StreamPipeline)this.channelHandlerContext.channel().attr(HttpPipelineBuilder.STREAM_PIPELINE_ATTRIBUTE.get()).get();
                new Http2StreamChannelBootstrap(this.channelHandlerContext.channel().parent()).handler((ChannelHandler)new ChannelInitializer<Http2StreamChannel>((io.netty.handler.codec.http.FullHttpRequest)inboundRequest, ourStream, connectionHandlerContext){
                    final /* synthetic */ io.netty.handler.codec.http.FullHttpRequest val$inboundRequest;
                    final /* synthetic */ int val$ourStream;
                    final /* synthetic */ ChannelHandlerContext val$connectionHandlerContext;
                    {
                        this.val$inboundRequest = fullHttpRequest;
                        this.val$ourStream = n;
                        this.val$connectionHandlerContext = channelHandlerContext;
                    }

                    protected void initChannel(@NonNull Http2StreamChannel ch) throws Exception {
                        int newStream = ch.stream().id();
                        NettyHttpRequest.this.channelHandlerContext.write((Object)new DefaultHttp2PushPromiseFrame(outboundHeaders).stream(((Http2StreamChannel)NettyHttpRequest.this.channelHandlerContext.channel()).stream()).pushStream(ch.stream()));
                        originalStreamPipeline.initializeChildPipelineForPushPromise((Channel)ch);
                        this.val$inboundRequest.headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), newStream);
                        this.val$inboundRequest.headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_PROMISE_ID.text(), this.val$ourStream);
                        this.val$connectionHandlerContext.executor().execute(() -> {
                            try {
                                ch.pipeline().context("http-decoder").fireChannelRead((Object)this.val$inboundRequest);
                            }
                            catch (Exception e) {
                                LOG.warn("Failed to complete push promise", (Throwable)e);
                            }
                        });
                    }
                }).open().addListener(future -> {
                    try {
                        future.sync();
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        LOG.warn("Failed to complete push promise", (Throwable)e);
                    }
                });
            } else {
                int ourStreamId = this.headers.getNettyHeaders().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
                if (this.channelHandlerContext.executor().inEventLoop()) {
                    NettyHttpRequest.serverPush0(connectionHandler, ourStreamId, (io.netty.handler.codec.http.FullHttpRequest)inboundRequest, connectionHandlerContext, outboundHeaders);
                } else {
                    this.channelHandlerContext.executor().execute(() -> NettyHttpRequest.lambda$serverPush$3(connectionHandler, ourStreamId, (io.netty.handler.codec.http.FullHttpRequest)inboundRequest, connectionHandlerContext, outboundHeaders));
                }
            }
            return this;
        }
        throw new UnsupportedOperationException("Server push not supported by this client: Not a HTTP2 client");
    }

    private static void serverPush0(Http2ConnectionHandler connectionHandler, int ourStreamId, io.netty.handler.codec.http.FullHttpRequest inboundRequest, ChannelHandlerContext connectionHandlerContext, Http2Headers outboundHeaders) {
        try {
            Http2Stream ourStream = connectionHandler.connection().stream(ourStreamId);
            if (ourStream == null) {
                throw new IllegalStateException("Push promise origin stream is already gone. This can happen if serverPush() is called outside the event loop, and the primary response is sent before the push promise. Please either call serverPush() on the event loop, or delay the primary response.");
            }
            int newStreamId = connectionHandler.connection().local().incrementAndGetNextStreamId();
            inboundRequest.headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), newStreamId);
            inboundRequest.headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_PROMISE_ID.text(), ourStreamId);
            connectionHandler.encoder().writePushPromise(connectionHandlerContext, ourStreamId, newStreamId, outboundHeaders, 0, connectionHandlerContext.newPromise()).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    try {
                        ((Http2ServerHandler.ConnectionHandler)connectionHandler).handleFakeRequest(connectionHandler.connection().stream(newStreamId), inboundRequest);
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to send push promise", (Throwable)e);
                    }
                } else {
                    LOG.warn("Failed to send push promise", future.cause());
                }
            }));
        }
        catch (Exception e) {
            LOG.warn("Failed to send push promise", (Throwable)e);
        }
    }

    @Override
    protected Charset initCharset(Charset characterEncoding) {
        return characterEncoding == null ? this.serverConfiguration.getDefaultCharset() : characterEncoding;
    }

    @Override
    protected int getMaxParams() {
        return this.serverConfiguration.getMaxParams();
    }

    @Override
    protected boolean isSemicolonIsNormalChar() {
        return this.serverConfiguration.isSemicolonIsNormalChar();
    }

    @Internal
    public boolean isFormOrMultipartData() {
        MediaType ct = this.getContentType().orElse(null);
        return ct != null && (ct.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE) || ct.equals((Object)MediaType.MULTIPART_FORM_DATA_TYPE));
    }

    @Override
    @Deprecated
    public io.netty.handler.codec.http.HttpRequest toHttpRequest() {
        return this.toHttpRequestWithoutBody();
    }

    public Optional<io.netty.handler.codec.http.HttpRequest> toHttpRequestDirect() {
        return Optional.of(new DelegateStreamedHttpRequest(this.nettyRequest, (Publisher)NettyByteBody.toByteBufs((ByteBody)this.byteBody()).map(DefaultHttpContent::new)));
    }

    public ByteBody byteBodyDirect() {
        return this.byteBody();
    }

    public io.netty.handler.codec.http.HttpRequest toHttpRequestWithoutBody() {
        if (this.nettyRequest instanceof io.netty.handler.codec.http.FullHttpRequest) {
            DefaultHttpRequest copy = new DefaultHttpRequest(this.nettyRequest.protocolVersion(), this.nettyRequest.method(), this.nettyRequest.uri(), this.nettyRequest.headers());
            copy.setDecoderResult(this.nettyRequest.decoderResult());
            return copy;
        }
        return this.nettyRequest;
    }

    public Optional<MediaType> getContentType() {
        return this.headers.contentType();
    }

    private BodyConvertor newBodyConvertor() {
        return new BodyConvertor(){

            public Optional convert(ArgumentConversionContext conversionContext, Object value) {
                if (value == null) {
                    return Optional.empty();
                }
                if (Argument.OBJECT_ARGUMENT.equalsType(conversionContext.getArgument())) {
                    return Optional.of(value);
                }
                return this.convertFromNext(NettyHttpRequest.this.conversionService, conversionContext, value);
            }
        };
    }

    public long getContentLength() {
        return this.headers.contentLength().orElse(-1L);
    }

    public boolean isFull() {
        return this.byteBody() instanceof AvailableNettyByteBody;
    }

    public ByteBuffer<?> contents() {
        ByteBody byteBody = this.byteBody();
        if (byteBody instanceof AvailableNettyByteBody) {
            AvailableNettyByteBody immediate = (AvailableNettyByteBody)byteBody;
            return NettyHttpRequest.toByteBuffer(immediate);
        }
        return null;
    }

    public ExecutionFlow<ByteBuffer<?>> bufferContents() {
        return InternalByteBody.bufferFlow((ByteBody)this.byteBody()).map(c -> NettyHttpRequest.toByteBuffer((AvailableNettyByteBody)c));
    }

    private static ByteBuffer<ByteBuf> toByteBuffer(AvailableNettyByteBody immediateByteBody) {
        return new DelegateByteBuffer(NettyByteBufferFactory.DEFAULT.wrap(immediateByteBody.peek()));
    }

    private static /* synthetic */ void lambda$serverPush$3(Http2ConnectionHandler connectionHandler, int ourStreamId, io.netty.handler.codec.http.FullHttpRequest inboundRequest, ChannelHandlerContext connectionHandlerContext, Http2Headers outboundHeaders) {
        NettyHttpRequest.serverPush0(connectionHandler, ourStreamId, inboundRequest, connectionHandlerContext, outboundHeaders);
    }

    static {
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.ETAG, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.IF_MATCH, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.IF_NONE_MATCH, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.IF_UNMODIFIED_SINCE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.ACCEPT_RANGES, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.CONTENT_RANGE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.IF_RANGE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.RANGE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.EXPECT, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.REFERER, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.PROXY_AUTHENTICATE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.PATH.text(), (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_PROMISE_ID.text(), (Object)"");
    }

    private static abstract class BodyConvertor<T> {
        private BodyConvertor<T> nextConvertor;

        private BodyConvertor() {
        }

        public abstract Optional<T> convert(ArgumentConversionContext<T> var1, T var2);

        protected synchronized Optional<T> convertFromNext(final ConversionService conversionService, final ArgumentConversionContext<T> conversionContext, T value) {
            if (this.nextConvertor == null) {
                final Optional conversion = conversionService.convert(value, conversionContext);
                this.nextConvertor = new BodyConvertor<T>(){

                    @Override
                    public Optional<T> convert(ArgumentConversionContext<T> currentConversionContext, T value) {
                        if (currentConversionContext == conversionContext) {
                            return conversion;
                        }
                        if (currentConversionContext.getArgument().equalsType(conversionContext.getArgument())) {
                            conversionContext.getLastError().ifPresent(error -> error.getOriginalValue().ifPresentOrElse(originalValue -> currentConversionContext.reject(originalValue, error.getCause()), () -> currentConversionContext.reject(error.getCause())));
                            return conversion;
                        }
                        return this.convertFromNext(conversionService, currentConversionContext, value);
                    }
                };
                return conversion;
            }
            return this.nextConvertor.convert(conversionContext, value);
        }
    }

    private final class NettyMutableHttpRequest
    implements MutableHttpRequest<T>,
    NettyHttpRequestBuilder {
        private URI uri;
        @Nullable
        private MutableHttpParameters httpParameters;
        @Nullable
        private Object body;

        private NettyMutableHttpRequest() {
        }

        public void setConversionService(ConversionService conversionService) {
            if (this.httpParameters != null) {
                this.httpParameters.setConversionService(conversionService);
            }
        }

        public MutableHttpRequest<T> cookie(Cookie cookie) {
            if (cookie instanceof NettyCookie) {
                NettyCookie nettyCookie = (NettyCookie)cookie;
                String value = ClientCookieEncoder.LAX.encode(nettyCookie.getNettyCookie());
                NettyHttpRequest.this.headers.add((CharSequence)HttpHeaderNames.COOKIE, (CharSequence)value);
            }
            return this;
        }

        public MutableHttpRequest<T> uri(URI uri) {
            this.uri = uri;
            if (uri.getQuery() != null) {
                this.httpParameters = null;
            }
            return this;
        }

        public <T1> MutableHttpRequest<T1> body(T1 body) {
            this.body = body;
            return this;
        }

        public MutableHttpHeaders getHeaders() {
            return NettyHttpRequest.this.headers;
        }

        @NonNull
        public MutableConvertibleValues<Object> getAttributes() {
            return NettyHttpRequest.this.getAttributes();
        }

        @NonNull
        public Optional<T> getBody() {
            if (this.body != null) {
                return Optional.of(this.body);
            }
            return NettyHttpRequest.this.getBody();
        }

        @NonNull
        public Cookies getCookies() {
            return NettyHttpRequest.this.getCookies();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MutableHttpParameters getParameters() {
            MutableHttpParameters httpParameters = this.httpParameters;
            if (httpParameters == null) {
                NettyMutableHttpRequest nettyMutableHttpRequest = this;
                synchronized (nettyMutableHttpRequest) {
                    httpParameters = this.httpParameters;
                    if (httpParameters == null) {
                        QueryStringDecoder queryStringDecoder = NettyHttpRequest.this.createDecoder(this.getUri());
                        this.httpParameters = httpParameters = new NettyHttpParameters(queryStringDecoder.parameters(), NettyHttpRequest.this.conversionService, null);
                    }
                }
            }
            return httpParameters;
        }

        @NonNull
        public HttpMethod getMethod() {
            return NettyHttpRequest.this.getMethod();
        }

        @NonNull
        public URI getUri() {
            if (this.uri != null) {
                return this.uri;
            }
            return NettyHttpRequest.this.getUri();
        }

        @NonNull
        @Deprecated
        public io.netty.handler.codec.http.FullHttpRequest toFullHttpRequest() {
            io.netty.handler.codec.http.HttpRequest nr = NettyHttpRequest.this.nettyRequest;
            if (nr instanceof io.netty.handler.codec.http.FullHttpRequest) {
                return (io.netty.handler.codec.http.FullHttpRequest)NettyHttpRequest.this.nettyRequest;
            }
            return new DefaultFullHttpRequest(nr.protocolVersion(), nr.method(), nr.uri(), Unpooled.EMPTY_BUFFER, nr.headers(), (io.netty.handler.codec.http.HttpHeaders)EmptyHttpHeaders.INSTANCE);
        }

        @NonNull
        @Deprecated
        public StreamedHttpRequest toStreamHttpRequest() {
            if (this.isStream()) {
                return (StreamedHttpRequest)NettyHttpRequest.this.nettyRequest;
            }
            io.netty.handler.codec.http.FullHttpRequest fullHttpRequest = this.toFullHttpRequest();
            DefaultStreamedHttpRequest request = new DefaultStreamedHttpRequest(fullHttpRequest.protocolVersion(), fullHttpRequest.method(), fullHttpRequest.uri(), true, Publishers.just((Object)new DefaultLastHttpContent(fullHttpRequest.content())));
            request.headers().setAll(fullHttpRequest.headers());
            return request;
        }

        @NonNull
        @Deprecated
        public io.netty.handler.codec.http.HttpRequest toHttpRequest() {
            if (this.isStream()) {
                return this.toStreamHttpRequest();
            }
            return this.toFullHttpRequest();
        }

        @Deprecated
        public boolean isStream() {
            return NettyHttpRequest.this.nettyRequest instanceof StreamedHttpRequest;
        }

        public MutableHttpRequest<T> mutate() {
            return new NettyMutableHttpRequest();
        }

        public io.netty.handler.codec.http.HttpRequest toHttpRequestWithoutBody() {
            return NettyHttpRequest.this.toHttpRequestWithoutBody();
        }

        public Optional<io.netty.handler.codec.http.HttpRequest> toHttpRequestDirect() {
            return this.body != null ? Optional.empty() : NettyHttpRequest.this.toHttpRequestDirect();
        }

        public ByteBody byteBodyDirect() {
            return this.body != null ? null : NettyHttpRequest.this.byteBodyDirect();
        }
    }
}

