/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog.element;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.server.netty.handler.accesslog.element.ConnectionMetadata;
import io.micronaut.http.server.netty.handler.accesslog.element.ConnectionMetadataImpl;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public interface LogElement {
    public Set<Event> events();

    default public void reset() {
    }

    @Deprecated
    default public String onRequestHeaders(SocketChannel channel, String method, HttpHeaders headers, String uri, String protocol) {
        return "-";
    }

    default public String onRequestHeaders(@NonNull ConnectionMetadata metadata, @NonNull String method, @NonNull HttpHeaders headers, @NonNull String uri, @NonNull String protocol) {
        SocketChannel socketChannel;
        if (metadata instanceof ConnectionMetadataImpl.SocketChannelMetadata) {
            ConnectionMetadataImpl.SocketChannelMetadata m = (ConnectionMetadataImpl.SocketChannelMetadata)metadata;
            socketChannel = m.ch();
        } else {
            socketChannel = null;
        }
        SocketChannel ch = socketChannel;
        return this.onRequestHeaders(ch, method, headers, uri, protocol);
    }

    default public String onResponseHeaders(ChannelHandlerContext ctx, HttpHeaders headers, String status) {
        return "-";
    }

    default public void onResponseWrite(int bytesSent) {
    }

    default public String onLastResponseWrite(int bytesSent) {
        return "-";
    }

    public LogElement copy();

    public static enum Event {
        ON_REQUEST_HEADERS,
        ON_RESPONSE_HEADERS,
        ON_RESPONSE_WRITE,
        ON_LAST_RESPONSE_WRITE;

        public static final Set<Event> REQUEST_HEADERS_EVENTS;
        public static final Set<Event> RESPONSE_HEADERS_EVENTS;

        static {
            REQUEST_HEADERS_EVENTS = Collections.unmodifiableSet(EnumSet.of(ON_REQUEST_HEADERS));
            RESPONSE_HEADERS_EVENTS = Collections.unmodifiableSet(EnumSet.of(ON_RESPONSE_HEADERS));
        }
    }
}

