/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog;

import io.micronaut.http.server.netty.handler.accesslog.element.AccessLog;
import io.micronaut.http.server.netty.handler.accesslog.element.AccessLogFormatParser;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpAccessLogHandler
extends ChannelDuplexHandler {
    public static final String HTTP_ACCESS_LOGGER = "HTTP_ACCESS_LOGGER";
    private static final AttributeKey<AccessLog> ACCESS_LOGGER = AttributeKey.valueOf((String)"ACCESS_LOGGER");
    private static final String H2_PROTOCOL_NAME = "HTTP/2.0";
    private final Logger logger;
    private final AccessLogFormatParser accessLogFormatParser;

    public HttpAccessLogHandler(String loggerName, String spec) {
        this(loggerName == null || loggerName.isEmpty() ? null : LoggerFactory.getLogger((String)loggerName), spec);
    }

    public HttpAccessLogHandler(Logger logger, String spec) {
        this.logger = logger == null ? LoggerFactory.getLogger((String)HTTP_ACCESS_LOGGER) : logger;
        this.accessLogFormatParser = new AccessLogFormatParser(spec);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Http2Exception {
        if (this.logger.isInfoEnabled() && msg instanceof HttpRequest) {
            SocketChannel channel = (SocketChannel)ctx.channel();
            HttpRequest request = (HttpRequest)msg;
            HttpHeaders headers = request.headers();
            String protocol = headers.contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text()) || headers.contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text()) ? H2_PROTOCOL_NAME : request.protocolVersion().text();
            this.accessLog(channel).onRequestHeaders(channel, request.method().name(), request.headers(), request.uri(), protocol);
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.logger.isInfoEnabled()) {
            this.processWriteEvent(ctx, msg, promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    private AccessLog accessLog(SocketChannel channel) {
        Attribute attr = channel.attr(ACCESS_LOGGER);
        AccessLog accessLog = (AccessLog)attr.get();
        if (accessLog == null) {
            accessLog = this.accessLogFormatParser.newAccessLogger();
            attr.set((Object)accessLog);
        } else {
            accessLog.reset();
        }
        return accessLog;
    }

    private void log(ChannelHandlerContext ctx, Object msg, ChannelPromise promise, AccessLog accessLog) {
        ctx.write(msg, promise.unvoid()).addListener(future -> {
            if (future.isSuccess()) {
                accessLog.log(this.logger);
            }
        });
    }

    private static boolean processHttpResponse(HttpResponse response, AccessLog accessLogger, ChannelHandlerContext ctx, ChannelPromise promise) {
        HttpResponseStatus status = response.status();
        if (status.equals((Object)HttpResponseStatus.CONTINUE)) {
            ctx.write((Object)response, promise);
            return true;
        }
        accessLogger.onResponseHeaders(ctx, response.headers(), status.codeAsText().toString());
        return false;
    }

    private void processWriteEvent(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        AccessLog accessLogger = (AccessLog)ctx.channel().attr(ACCESS_LOGGER).get();
        if (accessLogger != null) {
            if (msg instanceof HttpResponse && HttpAccessLogHandler.processHttpResponse((HttpResponse)msg, accessLogger, ctx, promise)) {
                return;
            }
            if (msg instanceof LastHttpContent) {
                accessLogger.onLastResponseWrite(((LastHttpContent)msg).content().readableBytes());
                this.log(ctx, msg, promise, accessLogger);
                return;
            }
            if (msg instanceof ByteBufHolder) {
                accessLogger.onResponseWrite(((ByteBufHolder)msg).content().readableBytes());
            } else if (msg instanceof ByteBuf) {
                accessLogger.onResponseWrite(((ByteBuf)msg).readableBytes());
            }
        }
        super.write(ctx, msg, promise);
    }
}

