/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.converters;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Produces
public class UnsatisfiedRouteHandler
implements ExceptionHandler<UnsatisfiedRouteException, HttpResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(UnsatisfiedRouteHandler.class);
    private final ErrorResponseProcessor<?> responseProcessor;

    @Deprecated
    public UnsatisfiedRouteHandler() {
        this.responseProcessor = null;
    }

    @Inject
    public UnsatisfiedRouteHandler(ErrorResponseProcessor<?> responseProcessor) {
        this.responseProcessor = responseProcessor;
    }

    public HttpResponse handle(HttpRequest request, final UnsatisfiedRouteException exception) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} (Bad Request): {}", (Object)request, (Object)exception.getMessage());
        }
        MutableHttpResponse response = HttpResponse.badRequest();
        if (this.responseProcessor != null) {
            return this.responseProcessor.processResponse(ErrorContext.builder((HttpRequest)request).cause((Throwable)exception).error(new Error(){

                public String getMessage() {
                    return exception.getMessage();
                }

                public Optional<String> getPath() {
                    return Optional.of('/' + exception.getArgument().getName());
                }
            }).build(), response);
        }
        return response.body((Object)new JsonError(exception.getMessage()).path('/' + exception.getArgument().getName()).link(Link.SELF, Link.of((URI)request.getUri())));
    }
}

