/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseFactory;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.Optional;

@Internal
public class NettyHttpResponseFactory
implements HttpResponseFactory {
    private static final AttributeKey<NettyMutableHttpResponse> KEY = AttributeKey.valueOf((String)NettyMutableHttpResponse.class.getSimpleName());

    public <T> MutableHttpResponse<T> ok(T body) {
        NettyMutableHttpResponse ok = new NettyMutableHttpResponse(ConversionService.SHARED);
        return body != null ? ok.body(body) : ok;
    }

    public <T> MutableHttpResponse<T> status(HttpStatus status, T body) {
        NettyMutableHttpResponse ok = new NettyMutableHttpResponse(ConversionService.SHARED);
        ok.status(status);
        return body != null ? ok.body(body) : ok;
    }

    public MutableHttpResponse status(HttpStatus status, String reason) {
        HttpResponseStatus nettyStatus = reason == null ? HttpResponseStatus.valueOf((int)status.getCode()) : new HttpResponseStatus(status.getCode(), reason);
        return new NettyMutableHttpResponse(HttpVersion.HTTP_1_1, nettyStatus, ConversionService.SHARED);
    }

    @Internal
    public static NettyMutableHttpResponse getOrCreate(NettyHttpRequest<?> request) {
        return NettyHttpResponseFactory.getOr(request, HttpResponse.ok());
    }

    @Internal
    public static NettyMutableHttpResponse getOr(NettyHttpRequest<?> request, HttpResponse<?> alternative) {
        Attribute attr = request.attr(KEY);
        NettyMutableHttpResponse nettyHttpResponse = (NettyMutableHttpResponse)attr.get();
        if (nettyHttpResponse == null) {
            nettyHttpResponse = (NettyMutableHttpResponse)alternative;
            attr.set((Object)nettyHttpResponse);
        }
        return nettyHttpResponse;
    }

    @Internal
    public static Optional<NettyMutableHttpResponse> get(NettyHttpRequest<?> request) {
        NettyMutableHttpResponse nettyHttpResponse = (NettyMutableHttpResponse)request.attr(KEY).get();
        return Optional.ofNullable(nettyHttpResponse);
    }

    @Internal
    public static Optional<NettyMutableHttpResponse> set(NettyHttpRequest<?> request, HttpResponse<?> response) {
        request.attr(KEY).set((Object)((NettyMutableHttpResponse)response));
        return Optional.ofNullable((NettyMutableHttpResponse)response);
    }
}

