/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.ssl;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.http.server.netty.ssl.ServerSslBuilder;
import io.micronaut.http.ssl.ClientAuthentication;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.http.ssl.SslBuilder;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.http.ssl.SslConfigurationException;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Optional;
import javax.inject.Singleton;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;

@Requirements(value={@Requires(property="micronaut.ssl.enabled", value="true", defaultValue="false"), @Requires(property="micronaut.ssl.build-self-signed", value="false", defaultValue="false")})
@Singleton
@Internal
public class CertificateProvidedSslBuilder
extends SslBuilder<SslContext>
implements ServerSslBuilder {
    private final ServerSslConfiguration ssl;
    private KeyStore keyStoreCache = null;
    private KeyStore trustStoreCache = null;

    public CertificateProvidedSslBuilder(ServerSslConfiguration ssl, ResourceResolver resourceResolver) {
        super(resourceResolver);
        this.ssl = ssl;
    }

    @Override
    public ServerSslConfiguration getSslConfiguration() {
        return this.ssl;
    }

    @Override
    public Optional<SslContext> build() {
        return this.build((SslConfiguration)this.ssl);
    }

    public Optional<SslContext> build(SslConfiguration ssl) {
        SslContextBuilder sslBuilder = SslContextBuilder.forServer((KeyManagerFactory)this.getKeyManagerFactory(ssl)).trustManager(this.getTrustManagerFactory(ssl));
        if (ssl.getProtocols().isPresent()) {
            sslBuilder.protocols((String[])ssl.getProtocols().get());
        }
        if (ssl.getCiphers().isPresent()) {
            sslBuilder = sslBuilder.ciphers(Arrays.asList((Object[])ssl.getCiphers().get()));
        }
        if (ssl.getClientAuthentication().isPresent()) {
            ClientAuthentication clientAuth = (ClientAuthentication)ssl.getClientAuthentication().get();
            if (clientAuth == ClientAuthentication.NEED) {
                sslBuilder = sslBuilder.clientAuth(ClientAuth.REQUIRE);
            } else if (clientAuth == ClientAuthentication.WANT) {
                sslBuilder = sslBuilder.clientAuth(ClientAuth.OPTIONAL);
            }
        }
        try {
            return Optional.of(sslBuilder.build());
        }
        catch (SSLException ex) {
            throw new SslConfigurationException("An error occurred while setting up SSL", (Throwable)ex);
        }
    }

    protected Optional<KeyStore> getTrustStore(SslConfiguration ssl) throws Exception {
        if (this.trustStoreCache == null) {
            super.getTrustStore(ssl).ifPresent(trustStore -> {
                this.trustStoreCache = trustStore;
            });
        }
        return Optional.ofNullable(this.trustStoreCache);
    }

    protected Optional<KeyStore> getKeyStore(SslConfiguration ssl) throws Exception {
        if (this.keyStoreCache == null) {
            super.getKeyStore(ssl).ifPresent(keyStore -> {
                this.keyStoreCache = keyStore;
            });
        }
        return Optional.ofNullable(this.keyStoreCache);
    }
}

