/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.http.client.netty.BlockHint;
import io.micronaut.http.client.netty.ConnectionManager;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.EventExecutor;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
interface Pool {
    public void onNewConnectionFailure(@NonNull EventLoop var1, @Nullable Throwable var2) throws Exception;

    @NonNull
    public PendingRequest createPendingRequest(@Nullable BlockHint var1);

    @NonNull
    public Http1PoolEntry createHttp1PoolEntry(@NonNull EventLoop var1, @NonNull ResizerConnection var2);

    @NonNull
    public Http2PoolEntry createHttp2PoolEntry(@NonNull EventLoop var1, @NonNull ResizerConnection var2);

    public void forEachConnection(@NonNull Consumer<ResizerConnection> var1);

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Http2PoolEntry {
        public void onConnectionEstablished(int var1);

        public void onConnectionInactive();

        public void markAvailable();

        public void markUnavailable();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Http1PoolEntry {
        public void onConnectionEstablished();

        public void onConnectionInactive();

        public void markAvailable();

        public void markUnavailable();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface PendingRequest {
        @NonNull
        public ExecutionFlow<ConnectionManager.PoolHandle> flow();

        public void dispatch();

        public void redispatch();

        @Nullable
        public EventExecutor likelyEventLoop();

        public boolean tryComplete(ConnectionManager.PoolHandle var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ResizerConnection {
        public void dispatch(PendingRequest var1) throws Exception;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Listener {
        @NonNull
        public Throwable wrapError(@Nullable Throwable var1);

        public void openNewConnection(@NonNull EventLoop var1);
    }
}

