/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.client.netty.BlockHint;
import io.micronaut.http.client.netty.PoolSink;
import java.util.concurrent.locks.ReentrantLock;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

@Internal
final class CancellableMonoSink<T>
implements Publisher<T>,
Sinks.One<T>,
Subscription,
PoolSink<T> {
    private static final Object EMPTY = new Object();
    private final ReentrantLock lock = new ReentrantLock();
    @Nullable
    private final BlockHint blockHint;
    private T value;
    private Throwable failure;
    private boolean complete = false;
    private boolean cancelled = false;
    private Subscriber<? super T> subscriber = null;
    private boolean subscriberWaiting = false;

    CancellableMonoSink(@Nullable BlockHint blockHint) {
        this.blockHint = blockHint;
    }

    @Override
    @Nullable
    public BlockHint getBlockHint() {
        return this.blockHint;
    }

    public void subscribe(Subscriber<? super T> s) {
        this.lock.lock();
        try {
            if (this.subscriber != null) {
                s.onError((Throwable)new IllegalStateException("Only one subscriber allowed"));
            }
            this.subscriber = s;
            this.subscriber.onSubscribe((Subscription)this);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void tryForward() {
        if (this.subscriberWaiting && this.complete && !this.cancelled) {
            if (this.failure == null) {
                if (this.value != EMPTY) {
                    this.subscriber.onNext(this.value);
                }
                this.subscriber.onComplete();
            } else {
                this.subscriber.onError(this.failure);
            }
        }
    }

    @NonNull
    public Sinks.EmitResult tryEmitValue(T value) {
        this.lock.lock();
        try {
            if (this.complete) {
                Sinks.EmitResult emitResult = Sinks.EmitResult.FAIL_OVERFLOW;
                return emitResult;
            }
            this.value = value;
            this.complete = true;
            this.tryForward();
            Sinks.EmitResult emitResult = Sinks.EmitResult.OK;
            return emitResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void emitValue(T value, @NonNull Sinks.EmitFailureHandler failureHandler) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public Sinks.EmitResult tryEmitEmpty() {
        return this.tryEmitValue(EMPTY);
    }

    @NonNull
    public Sinks.EmitResult tryEmitError(@NonNull Throwable error) {
        this.lock.lock();
        try {
            if (this.complete) {
                Sinks.EmitResult emitResult = Sinks.EmitResult.FAIL_OVERFLOW;
                return emitResult;
            }
            this.failure = error;
            this.complete = true;
            this.tryForward();
            Sinks.EmitResult emitResult = Sinks.EmitResult.OK;
            return emitResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void emitEmpty(@NonNull Sinks.EmitFailureHandler failureHandler) {
        throw new UnsupportedOperationException();
    }

    public void emitError(@NonNull Throwable error, @NonNull Sinks.EmitFailureHandler failureHandler) {
        throw new UnsupportedOperationException();
    }

    public int currentSubscriberCount() {
        this.lock.lock();
        try {
            int n = this.subscriber == null ? 0 : 1;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @NonNull
    public Mono<T> asMono() {
        return Mono.from((Publisher)this);
    }

    public Object scanUnsafe(@NonNull Scannable.Attr key) {
        return null;
    }

    public void request(long n) {
        this.lock.lock();
        try {
            if (n > 0L && !this.subscriberWaiting) {
                this.subscriberWaiting = true;
                this.tryForward();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void cancel() {
        this.lock.lock();
        try {
            this.complete = true;
            this.cancelled = true;
        }
        finally {
            this.lock.unlock();
        }
    }
}

