/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpRequestWrapper;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpParameters;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.cookie.Cookie;
import java.net.URI;
import java.util.Optional;

@Internal
class MutableHttpRequestWrapper<B>
extends HttpRequestWrapper<B>
implements MutableHttpRequest<B> {
    private ConversionService conversionService;
    @Nullable
    private B body;
    @Nullable
    private URI uri;

    MutableHttpRequestWrapper(ConversionService conversionService, HttpRequest<B> delegate) {
        super(delegate);
        this.conversionService = conversionService;
    }

    static MutableHttpRequest<?> wrapIfNecessary(ConversionService conversionService, HttpRequest<?> request) {
        if (request instanceof MutableHttpRequest) {
            MutableHttpRequest httpRequest = (MutableHttpRequest)request;
            return httpRequest;
        }
        return new MutableHttpRequestWrapper(conversionService, request);
    }

    @NonNull
    public Optional<B> getBody() {
        if (this.body == null) {
            return this.getDelegate().getBody();
        }
        return Optional.of(this.body);
    }

    @NonNull
    public <T> Optional<T> getBody(@NonNull Class<T> type) {
        if (this.body == null) {
            return this.getDelegate().getBody(type);
        }
        return this.conversionService.convert(this.body, ConversionContext.of(type));
    }

    public <T> Optional<T> getBody(ArgumentConversionContext<T> conversionContext) {
        if (this.body == null) {
            return this.getDelegate().getBody(conversionContext);
        }
        return this.conversionService.convert(this.body, conversionContext);
    }

    public MutableHttpRequest<B> cookie(Cookie cookie) {
        throw new UnsupportedOperationException();
    }

    public MutableHttpRequest<B> uri(URI uri) {
        this.uri = uri;
        return this;
    }

    @NonNull
    public URI getUri() {
        if (this.uri == null) {
            return this.getDelegate().getUri();
        }
        return this.uri;
    }

    @NonNull
    public MutableHttpParameters getParameters() {
        return (MutableHttpParameters)super.getParameters();
    }

    @NonNull
    public MutableHttpHeaders getHeaders() {
        return (MutableHttpHeaders)super.getHeaders();
    }

    public <T> MutableHttpRequest<T> body(T body) {
        this.body = body;
        return this;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }
}

