/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.body.stream.BodySizeLimits;
import io.micronaut.http.client.exceptions.ContentLengthExceededException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.ReferenceCounted;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Flux;

@Internal
final class SseSplitter {
    SseSplitter() {
    }

    @NonNull
    static List<ByteBuf> split(@NonNull ByteBuf buf) {
        int eol;
        buf.touch();
        ArrayList<ByteBuf> split = new ArrayList<ByteBuf>();
        while ((eol = SseSplitter.findEndOfLine(buf)) != -1) {
            split.add(buf.readSlice(eol).copy());
            if (buf.readByte() != 13) continue;
            buf.skipBytes(1);
        }
        split.add(buf);
        return split;
    }

    @NonNull
    static Flux<ByteBuf> split(@NonNull Flux<ByteBuf> buf, @NonNull BodySizeLimits limits) {
        AtomicReference last = new AtomicReference();
        return buf.concatMapIterable(bb -> {
            ByteBuf here;
            CompositeByteBuf joined = last.getAndSet(null);
            if (joined == null) {
                here = bb;
            } else {
                long combinedLength = (long)joined.readableBytes() + (long)bb.readableBytes();
                if (combinedLength > limits.maxBufferSize()) {
                    bb.release();
                    throw new ContentLengthExceededException(limits.maxBufferSize(), combinedLength);
                }
                joined.addComponent(true, bb);
                here = joined;
            }
            List<ByteBuf> split = SseSplitter.split(here);
            ByteBuf l = split.get(split.size() - 1);
            if (l.isReadable()) {
                l.discardSomeReadBytes();
                if (joined != null) {
                    assert (l == joined);
                } else {
                    joined = l.alloc().compositeBuffer();
                    joined.addComponent(true, l);
                }
                last.set(joined);
            } else {
                l.release();
            }
            return split.subList(0, split.size() - 1);
        }).doOnDiscard(ByteBuf.class, ReferenceCounted::release).doOnTerminate(() -> {
            ByteBuf l = last.getAndSet(null);
            if (l != null) {
                l.release();
            }
        });
    }

    private static int findEndOfLine(ByteBuf buffer) {
        int i = buffer.indexOf(buffer.readerIndex(), buffer.readerIndex() + buffer.readableBytes(), (byte)10);
        if (i >= 0) {
            if (i > 0 && buffer.getByte(i - 1) == 13) {
                --i;
            }
            i -= buffer.readerIndex();
        }
        return i;
    }
}

