/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.client.HttpVersionSelection;
import io.micronaut.http.ssl.ClientSslConfiguration;
import io.micronaut.http.ssl.SslBuilder;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.http.ssl.SslConfigurationException;
import jakarta.inject.Singleton;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Internal
@BootstrapContextCompatible
public final class JdkClientSslBuilder
extends SslBuilder<SSLContext> {
    private static final Logger LOG = LoggerFactory.getLogger(JdkClientSslBuilder.class);

    public JdkClientSslBuilder(ResourceResolver resourceResolver) {
        super(resourceResolver);
    }

    public Optional<SSLContext> build(SslConfiguration ssl) {
        return this.build(ssl, HttpVersion.HTTP_1_1);
    }

    public Optional<SSLContext> build(SslConfiguration ssl, HttpVersion httpVersion) {
        return Optional.ofNullable(this.build(ssl, HttpVersionSelection.forLegacyVersion((HttpVersion)httpVersion)));
    }

    @Nullable
    public SSLContext build(SslConfiguration ssl, HttpVersionSelection versionSelection) {
        if (!ssl.isEnabled()) {
            return null;
        }
        TrustManagerFactory trustManagerFactory = this.getTrustManagerFactory(ssl);
        KeyManagerFactory keyManagerFactory = this.getKeyManagerFactory(ssl);
        try {
            ClientSslConfiguration clientSslConfiguration;
            SSLContext tls = SSLContext.getInstance(ssl.getProtocol().orElse("TLS"));
            if (trustManagerFactory == null) {
                trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            }
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            if (ssl instanceof ClientSslConfiguration && (clientSslConfiguration = (ClientSslConfiguration)ssl).isInsecureTrustAllCertificates()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Trust all certificates is enabled. This is insecure and should not be used in production");
                }
                trustManagers = new TrustManager[]{new TrustAllTrustManager()};
            }
            tls.init(keyManagerFactory.getKeyManagers(), trustManagers, null);
            return tls;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new SslConfigurationException("Error initializing SSL context: " + e.getMessage(), (Throwable)e);
        }
    }

    private static class TrustAllTrustManager
    implements X509TrustManager {
        private TrustAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

