/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpHeaders;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@Internal
public class HttpHeadersAdapter
implements HttpHeaders {
    private final java.net.http.HttpHeaders httpHeaders;
    private final ConversionService conversionService;

    public HttpHeadersAdapter(java.net.http.HttpHeaders httpHeaders, ConversionService conversionService) {
        this.httpHeaders = httpHeaders;
        this.conversionService = conversionService;
    }

    public List<String> getAll(CharSequence name) {
        return this.httpHeaders.allValues(name.toString());
    }

    public String get(CharSequence name) {
        return this.httpHeaders.firstValue(name.toString()).orElse(null);
    }

    public Set<String> names() {
        return this.httpHeaders.map().keySet();
    }

    public Collection<List<String>> values() {
        return this.httpHeaders.map().values();
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        return this.conversionService.convert((Object)this.get(name), conversionContext);
    }
}

