/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.annotation;

import io.micronaut.aop.Introduction;
import io.micronaut.context.annotation.AliasFor;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpVersionSelection;
import io.micronaut.http.hateoas.JsonError;
import jakarta.inject.Singleton;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.jspecify.annotations.NonNull;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Introduction
@Singleton
public @interface Client {
    @AliasFor(member="id")
    public String value() default "";

    @AliasFor(member="value")
    public String id() default "";

    public @NonNull DefinitionType definitionType() default DefinitionType.CLIENT;

    public String path() default "";

    public Class<?> errorType() default JsonError.class;

    public Class<? extends HttpClientConfiguration> configuration() default HttpClientConfiguration.class;

    @Deprecated
    public HttpVersion httpVersion() default HttpVersion.HTTP_1_1;

    public @NonNull HttpVersionSelection.PlaintextMode plaintextMode() default HttpVersionSelection.PlaintextMode.HTTP_1;

    public @NonNull String[] alpnModes() default {"h2", "http/1.1"};

    public static enum DefinitionType {
        CLIENT,
        SERVER;


        public boolean isClient() {
            return this == CLIENT;
        }

        public boolean isServer() {
            return this == SERVER;
        }
    }
}

